/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.internal.ui;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import net.refractions.udig.core.internal.ExtensionPointProcessor;
import net.refractions.udig.core.internal.ExtensionPointUtil;
import net.refractions.udig.internal.ui.UDIGDropHandler;
import net.refractions.udig.internal.ui.UDIGTransfer;
import net.refractions.udig.internal.ui.UDigByteAndLocalTransfer;
import net.refractions.udig.internal.ui.UiPlugin;
import net.refractions.udig.ui.IDropAction;
import net.refractions.udig.ui.TransferFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.Transfer;

public class UDIGDNDProcessor {
    private static TransferProcessor processor;

    public static Set<Transfer> getTransfers() {
        if (processor == null) {
            processor = new TransferProcessor();
            ExtensionPointUtil.process((Plugin)UiPlugin.getDefault(), (String)"net.refractions.udig.ui.dropTransfers", (ExtensionPointProcessor)processor);
        }
        return new LinkedHashSet<Transfer>(UDIGDNDProcessor.processor.transfers);
    }

    public static List<IDropAction> process(Object data, UDIGDropHandler handler, DropTargetEvent event) {
        if (data == null || handler == null || handler.getTarget() == null) {
            return new ArrayList<IDropAction>();
        }
        DropActionProcessor d = new DropActionProcessor(data, handler, event);
        ExtensionPointUtil.process((Plugin)UiPlugin.getDefault(), (String)"net.refractions.udig.ui.dropAction", (ExtensionPointProcessor)d);
        return d.actions;
    }

    public static class DropActionProcessor
    implements ExtensionPointProcessor {
        Object data;
        UDIGDropHandler handler;
        List<IDropAction> actions;
        private DropTargetEvent event;

        DropActionProcessor(Object data, UDIGDropHandler handler, DropTargetEvent event) {
            this.data = data;
            this.handler = handler;
            this.event = event;
            this.actions = new ArrayList<IDropAction>();
        }

        public void process(IExtension extension, IConfigurationElement element) throws Exception {
            EnablesFor enablesFor = new EnablesFor(element);
            if (enablesFor.minimum < 1 && !enablesFor.expandable) {
                return;
            }
            Object concreteTarget = this.findTarget(element);
            if (concreteTarget == null) {
                return;
            }
            List<Object> concreteData = this.findData(element);
            if (!concreteData.isEmpty()) {
                try {
                    this.addActions(element, concreteTarget, concreteData, enablesFor);
                }
                catch (Throwable t) {
                    String msg = "Error validating drop action";
                    String ns = element.getNamespaceIdentifier();
                    Status s = new Status(2, ns, 0, msg, t);
                    UiPlugin.getDefault().getLog().log((IStatus)s);
                }
            }
        }

        private void addActions(IConfigurationElement element, Object concreteTarget, List<Object> concreteData, EnablesFor enablesFor) throws CoreException {
            if (enablesFor.minimum > concreteData.size()) {
                return;
            }
            if (enablesFor.minimum == concreteData.size()) {
                this.addAction(element, concreteTarget, concreteData);
                return;
            }
            if (enablesFor.expandable && enablesFor.minimum < concreteData.size()) {
                this.addAction(element, concreteTarget, concreteData);
                return;
            }
            if (!enablesFor.expandable) {
                ArrayList<Object> data = new ArrayList<Object>();
                for (Object object : concreteData) {
                    if (data.size() < enablesFor.minimum) {
                        data.add(object);
                        continue;
                    }
                    this.addAction(element, concreteTarget, data);
                    data = new ArrayList();
                    data.add(object);
                }
                if (data.size() == enablesFor.minimum) {
                    this.addAction(element, concreteTarget, data);
                }
            }
        }

        private void addAction(IConfigurationElement element, Object concreteTarget, List<Object> concreteData) throws CoreException {
            if (concreteData.isEmpty()) {
                throw new IllegalArgumentException("Data cannot be null");
            }
            Object data = concreteData.size() == 1 ? concreteData.get(0) : concreteData.toArray();
            IDropAction action = (IDropAction)element.createExecutableExtension("class");
            action.init(element, this.event, this.handler.getViewerLocation(), concreteTarget, data);
            if (action.accept()) {
                this.actions.add(action);
            }
        }

        private List<Object> findData(IConfigurationElement element) {
            IConfigurationElement[] acceptedTypes = element.getChildren("acceptedType");
            ArrayList<Object> data = new ArrayList<Object>(Arrays.asList((Object[])this.data));
            Class<? extends Object> c = null;
            ArrayList<Object> concreteData = new ArrayList<Object>();
            int i = 0;
            while (i < acceptedTypes.length && !data.isEmpty()) {
                IConfigurationElement acceptedType = acceptedTypes[i];
                try {
                    String clazz = acceptedType.getAttribute("class");
                    c = this.loadClass(clazz, true);
                    if (c != null) {
                        String adapt = acceptedType.getAttribute("adapt");
                        boolean doAdapt = "true".equals(adapt);
                        concreteData.addAll(this.processArray(data, c, doAdapt));
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {}
                ++i;
            }
            return concreteData;
        }

        private Class<? extends Object> loadClass(String clazz, boolean isArray) throws ClassNotFoundException {
            if (isArray) {
                Object[] array;
                Object[] objectArray = array = (Object[])this.data;
                int n = array.length;
                int n2 = 0;
                while (n2 < n) {
                    Object object = objectArray[n2];
                    Class<?> c = this.getClassLoader(object).loadClass(clazz);
                    if (c != null) {
                        return c;
                    }
                    ++n2;
                }
                return null;
            }
            return this.getClassLoader(this.data).loadClass(clazz);
        }

        private List<Object> processArray(List<Object> data, Class<? extends Object> c, boolean doAdapt) {
            ArrayList<Object> tmp = new ArrayList<Object>(data.size());
            for (Object obj : data) {
                Object d = this.getConcreteObject(obj, c, doAdapt);
                if (d == null) continue;
                tmp.add(d);
            }
            data.removeAll(tmp);
            return tmp;
        }

        private Object findTarget(IConfigurationElement element) {
            IConfigurationElement[] targets = element.getChildren("destination");
            Object concreteTarget = null;
            ClassLoader dloader = this.getClassLoader(this.handler.getTarget());
            Class<?> c = null;
            int i = 0;
            while (i < targets.length && c == null) {
                IConfigurationElement target = targets[i];
                try {
                    String clazz = target.getAttribute("class");
                    c = dloader.loadClass(clazz);
                    if (c != null) {
                        String adapt = target.getAttribute("adapt");
                        concreteTarget = this.getConcreteObject(this.handler.getTarget(), c, "true".equals(adapt));
                        if (concreteTarget == null) {
                            c = null;
                        }
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {}
                ++i;
            }
            return concreteTarget;
        }

        private ClassLoader getClassLoader(Object data) {
            ClassLoader sloader = data.getClass().getClassLoader();
            if (sloader == null) {
                sloader = ClassLoader.getSystemClassLoader();
            }
            return sloader;
        }

        private Object getConcreteObject(Object obj, Class<? extends Object> desiredClass, boolean adapt) {
            IAdaptable adaptable;
            Object adapter;
            if (desiredClass.isAssignableFrom(obj.getClass())) {
                return obj;
            }
            if (!adapt) {
                return null;
            }
            if (obj instanceof IAdaptable && (adapter = (adaptable = (IAdaptable)obj).getAdapter(desiredClass)) != null) {
                return adapter;
            }
            return null;
        }
    }

    private static class EnablesFor {
        int minimum;
        boolean expandable;

        public EnablesFor(IConfigurationElement element) {
            String enablesFor = element.getAttribute("enablesFor");
            this.minimum = 1;
            this.expandable = false;
            if (enablesFor != null) {
                if (enablesFor.contains("+")) {
                    this.expandable = true;
                    enablesFor = enablesFor.substring(0, enablesFor.indexOf(43)).trim();
                }
                if (enablesFor.trim().length() > 0) {
                    try {
                        this.minimum = Integer.valueOf(enablesFor);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new NumberFormatException("enablesFor in DropAction: " + element.getName() + " is not a number or a +.  " + "See extension point for legal values.");
                    }
                }
            }
        }
    }

    static class TransferComparator
    implements Comparator<Transfer>,
    Serializable {
        private static final long serialVersionUID = 1L;

        TransferComparator() {
        }

        @Override
        public int compare(Transfer o1, Transfer o2) {
            if (o1 instanceof UDigByteAndLocalTransfer) {
                return -1;
            }
            if (o2 instanceof UDigByteAndLocalTransfer) {
                return 1;
            }
            if (o1 instanceof UDIGTransfer) {
                return -1;
            }
            if (o2 instanceof UDIGTransfer) {
                return 1;
            }
            return -1;
        }
    }

    static class TransferProcessor
    implements ExtensionPointProcessor {
        TreeSet<Transfer> transfers = new TreeSet<Transfer>(new TransferComparator());

        TransferProcessor() {
        }

        public void process(IExtension extension, IConfigurationElement element) throws Exception {
            Transfer[] tmp;
            Transfer[] transferArray = tmp = ((TransferFactory)element.createExecutableExtension("class")).getTransfers();
            int n = tmp.length;
            int n2 = 0;
            while (n2 < n) {
                Transfer transfer = transferArray[n2];
                this.transfers.add(transfer);
                ++n2;
            }
        }
    }
}

