/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.internal.ui;

import net.refractions.udig.internal.ui.IDropTargetProvider;
import net.refractions.udig.internal.ui.UDIGDropHandler;
import net.refractions.udig.ui.UDIGDropTargetListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;

public class UDIGControlDropListener
extends DropTargetAdapter
implements UDIGDropTargetListener {
    UDIGDropHandler handler;
    private IDropTargetProvider destinationProvider;

    public UDIGControlDropListener(IDropTargetProvider destinationProvider, UDIGDropHandler dropHandler) {
        this.handler = dropHandler;
        if (destinationProvider == null) {
            destinationProvider = new NullProvider();
        }
        this.destinationProvider = destinationProvider;
    }

    private void initHandler(DropTargetEvent event) {
        this.handler.setTarget(this.destinationProvider.getTarget(event));
    }

    public void dragEnter(DropTargetEvent event) {
        this.initHandler(event);
        this.handler.dragEnter(event);
    }

    public void dragOperationChanged(DropTargetEvent event) {
        this.initHandler(event);
        this.handler.dragOperationChanged(event);
    }

    public void dragLeave(DropTargetEvent event) {
        this.initHandler(event);
        this.handler.dragLeave(event);
    }

    public void dragOver(DropTargetEvent event) {
        this.initHandler(event);
        this.handler.dragOver(event);
    }

    public void dropAccept(DropTargetEvent event) {
        this.initHandler(event);
        this.handler.dropAccept(event);
    }

    public void drop(DropTargetEvent event) {
        this.initHandler(event);
        this.handler.drop(event);
    }

    public UDIGDropHandler getHandler() {
        return this.handler;
    }

    @Override
    public IDropTargetProvider getDropTargetProvider() {
        return this.destinationProvider;
    }

    @Override
    public void setDropTargetProvider(IDropTargetProvider newProvider) {
        this.destinationProvider = newProvider;
    }

    public static class NullProvider
    implements ISelectionProvider,
    IDropTargetProvider {
        public void addSelectionChangedListener(ISelectionChangedListener listener) {
        }

        public ISelection getSelection() {
            return new StructuredSelection();
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        }

        public void setSelection(ISelection selection) {
        }

        @Override
        public Object getTarget(DropTargetEvent event) {
            return null;
        }
    }
}

