/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.internal.ui;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.text.MessageFormat;
import net.refractions.udig.internal.ui.UDIGWorkbenchAdvisor;
import net.refractions.udig.internal.ui.UiPlugin;
import net.refractions.udig.libs.internal.Activator;
import net.refractions.udig.ui.internal.Messages;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.osgi.framework.Bundle;

public class UDIGApplication
implements IApplication {
    boolean quiet = true;

    public Object start(IApplicationContext context) throws Exception {
        int returnCode;
        block14: {
            WorkbenchAdvisor workbenchAdvisor = this.createWorkbenchAdvisor();
            Display display = PlatformUI.createDisplay();
            String udigNameStr = "udig";
            if (Platform.getOS().equals("win32")) {
                udigNameStr = "udig.exe";
            }
            String[] stringArray = Platform.getCommandLineArgs();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String arg = stringArray[n2];
                if ("--help".equalsIgnoreCase(arg) || "-h".equalsIgnoreCase(arg)) {
                    String helpString = MessageFormat.format(Messages.UDIGApplication_helpstring, udigNameStr);
                    System.out.println(helpString);
                    return EXIT_OK;
                }
                if ("--version".equalsIgnoreCase(arg) || "-v".equalsIgnoreCase(arg)) {
                    URL mappingsUrl = Platform.getBundle((String)"net.refractions.udig").getResource("about.mappings");
                    String mappingsPathPath = FileLocator.toFileURL((URL)mappingsUrl).getPath();
                    BufferedReader bR = new BufferedReader(new FileReader(mappingsPathPath));
                    String udigVersion = "version not available";
                    String line = null;
                    while ((line = bR.readLine()) != null) {
                        if (!line.startsWith("1=")) continue;
                        udigVersion = line.split("=")[1];
                        break;
                    }
                    System.out.println("Version Information:");
                    System.out.println("uDig version: " + udigVersion);
                    System.out.println("Java VM: " + System.getProperty("java.version"));
                    System.out.println("OS:      " + System.getProperty("os.name") + " " + System.getProperty("os.arch"));
                    return EXIT_OK;
                }
                ++n2;
            }
            if (!this.login()) {
                return EXIT_OK;
            }
            if (!this.init()) {
                return EXIT_OK;
            }
            returnCode = EXIT_OK;
            try {
                try {
                    returnCode = PlatformUI.createAndRunWorkbench((Display)display, (WorkbenchAdvisor)workbenchAdvisor);
                }
                catch (Throwable t) {
                    UiPlugin.log(Messages.UDIGApplication_error, t);
                    context.applicationRunning();
                    display.dispose();
                    break block14;
                }
            }
            catch (Throwable throwable) {
                context.applicationRunning();
                display.dispose();
                throw throwable;
            }
            context.applicationRunning();
            display.dispose();
        }
        if (returnCode == 1) {
            String systemExitCode = System.getProperty("eclipse.exitcode");
            if ("24".equals(systemExitCode)) {
                return EXIT_RELAUNCH;
            }
            return EXIT_RESTART;
        }
        return EXIT_OK;
    }

    protected boolean init() {
        boolean unpacked;
        File epsgFile = Activator.epsgDatabaseFile();
        boolean bl = unpacked = epsgFile != null && epsgFile.exists();
        if (unpacked || this.quiet) {
            Activator.initializeReferencingModule(null);
        } else {
            Bundle bundle = Platform.getBundle((String)Activator.ID);
            try {
                ProgressMonitorDialog progress = new ProgressMonitorDialog(Display.getCurrent().getActiveShell());
                progress.run(true, false, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        Activator.initializeReferencingModule((IProgressMonitor)monitor);
                    }
                });
            }
            catch (InvocationTargetException e) {
                Platform.getLog((Bundle)bundle).log((IStatus)new Status(4, "net.refractions.udig.ui", e.getCause().getLocalizedMessage(), e.getCause()));
                return false;
            }
            catch (InterruptedException e) {
                Platform.getLog((Bundle)bundle).log((IStatus)new Status(4, "net.refractions.udig.ui", e.getCause().getLocalizedMessage(), e.getCause()));
                return false;
            }
        }
        return true;
    }

    protected boolean login() {
        return true;
    }

    protected WorkbenchAdvisor createWorkbenchAdvisor() {
        return new UDIGWorkbenchAdvisor();
    }

    public void stop() {
        final IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench == null) {
            return;
        }
        final Display display = workbench.getDisplay();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                if (!display.isDisposed()) {
                    workbench.close();
                }
            }
        });
    }
}

