/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.internal.ui;

import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;
import net.refractions.udig.core.internal.ExtensionPointList;
import net.refractions.udig.internal.ui.UiPlugin;
import net.refractions.udig.ui.MenuBuilder;
import net.refractions.udig.ui.UDIGMenuBuilder;
import net.refractions.udig.ui.action.NewObjectDelegate;
import net.refractions.udig.ui.action.NewObjectDelegateComparator;
import net.refractions.udig.ui.internal.Messages;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ICoolBarManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ContributionItemFactory;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;

public class UDIGActionBarAdvisor
extends ActionBarAdvisor {
    private MenuBuilder menuBuilder;

    public UDIGActionBarAdvisor(IActionBarConfigurer configurer) {
        super(configurer);
    }

    private MenuBuilder lookupMenuBuilder() {
        Class<MenuBuilder> interfaceClass = MenuBuilder.class;
        String prefConstant = "menuBuilder";
        String xpid = "net.refractions.udig.ui.menuBuilders";
        String idField = "id";
        String classField = "class";
        MenuBuilder mb = (MenuBuilder)UiPlugin.lookupConfigurationObject(interfaceClass, UiPlugin.getDefault().getPreferenceStore(), "net.refractions.udig.ui", prefConstant, xpid, idField, classField);
        if (mb != null) {
            return mb;
        }
        return new UDIGMenuBuilder();
    }

    protected MenuBuilder getMenuFactory() {
        if (this.menuBuilder == null) {
            this.menuBuilder = this.lookupMenuBuilder();
        }
        return this.menuBuilder;
    }

    protected void fillCoolBar(ICoolBarManager coolBar) {
        IWorkbenchWindow window = this.getActionBarConfigurer().getWindowConfigurer().getWindow();
        MenuBuilder override = this.getMenuFactory();
        if (override != null && !(override instanceof UDIGMenuBuilder)) {
            override.fillCoolBar(coolBar, window);
        } else {
            new UDIGMenuBuilder().fillCoolBar(coolBar, window);
        }
    }

    protected void fillMenuBar(IMenuManager menuBar) {
        menuBar.add((IContributionItem)new GroupMarker("wbStart"));
        MenuBuilder override = this.getMenuFactory();
        if (override != null && !(override instanceof UDIGMenuBuilder)) {
            IWorkbenchWindow window = this.getActionBarConfigurer().getWindowConfigurer().getWindow();
            override.fillMenuBar(menuBar, window);
            return;
        }
        MenuManager fileMenu = new MenuManager(Messages.UDIGWorkbenchAdvisor_file, "file");
        this.fillFileMenu((IMenuManager)fileMenu);
        menuBar.add((IContributionItem)fileMenu);
        MenuManager editMenu = new MenuManager(Messages.UDIGWorkbenchAdvisor_edit, "edit");
        this.fillEditMenu((IMenuManager)editMenu);
        menuBar.add((IContributionItem)editMenu);
        MenuManager navMenu = new MenuManager(Messages.UDIGWorkbenchAdvisor_navigationMenu, "navigate");
        this.fillNavigateMenu((IMenuManager)navMenu);
        menuBar.add((IContributionItem)navMenu);
        MenuManager toolMenu = new MenuManager(Messages.UDIGWorkbenchAdvisor_tools, "tools");
        this.fillToolMenu((IMenuManager)toolMenu);
        menuBar.add((IContributionItem)toolMenu);
        menuBar.add((IContributionItem)new GroupMarker("additions"));
        MenuManager windowMenu = new MenuManager(Messages.UDIGWorkbenchAdvisor_window, "window");
        this.fillWindowMenu((IMenuManager)windowMenu);
        menuBar.add((IContributionItem)windowMenu);
        MenuManager helpMenu = new MenuManager(Messages.UDIGWorkbenchAdvisor_help, "help");
        this.fillHelpMenu((IMenuManager)helpMenu);
        menuBar.add((IContributionItem)helpMenu);
        menuBar.add((IContributionItem)new GroupMarker("wbEnd"));
        IWorkbenchWindow window = this.getActionBarConfigurer().getWindowConfigurer().getWindow();
        UiPlugin.getDefault().getOperationMenuFactory().setWindow(window);
    }

    protected void fillNavigateMenu(IMenuManager menu) {
        menu.add((IContributionItem)new GroupMarker("navStart"));
        menu.add((IContributionItem)new Separator());
        menu.add((IContributionItem)new GroupMarker("zoom.ext"));
        menu.add((IContributionItem)new Separator());
        menu.add((IContributionItem)new GroupMarker("additions"));
        menu.add((IContributionItem)new Separator());
        menu.add((IContributionItem)new GroupMarker("bottom"));
        menu.add((IContributionItem)new GroupMarker("navEnd"));
        menu.setVisible(true);
    }

    protected void fillToolMenu(IMenuManager menu) {
        menu.add((IContributionItem)new GroupMarker("wbStart"));
        menu.add((IContributionItem)new GroupMarker("action.ext"));
        menu.add((IContributionItem)new Separator());
        menu.add((IContributionItem)new GroupMarker("modal.ext"));
        menu.add((IContributionItem)new Separator());
        menu.add((IContributionItem)new GroupMarker("additions"));
        menu.add((IContributionItem)new GroupMarker("wbEnd"));
    }

    protected void fillFileMenu(IMenuManager fileMenu) {
        IWorkbenchWindow window = this.getActionBarConfigurer().getWindowConfigurer().getWindow();
        fileMenu.add((IContributionItem)new GroupMarker("fileStart"));
        MenuManager newMenu = new MenuManager(Messages.UDIGWorkbenchAdvisor_new, ActionFactory.NEW.getId());
        newMenu.add((IContributionItem)new GroupMarker("new.start"));
        List list = ExtensionPointList.getExtensionPointList((String)"net.refractions.udig.ui.newObjectAction");
        Collections.sort(list, new NewObjectDelegateComparator());
        for (IConfigurationElement element : list) {
            final NewObjectDelegate item = new NewObjectDelegate(element, window);
            Action newAction = new Action(){

                public void runWithEvent(Event event) {
                    item.runAction();
                }
            };
            newAction.setText(item.text);
            newAction.setImageDescriptor(item.icon);
            newMenu.appendToGroup("new.start", (IAction)newAction);
        }
        newMenu.add(ContributionItemFactory.NEW_WIZARD_SHORTLIST.create(window));
        fileMenu.add((IContributionItem)newMenu);
        fileMenu.add((IContributionItem)new GroupMarker("open.ext"));
        fileMenu.add((IContributionItem)new Separator());
        fileMenu.add((IContributionItem)new GroupMarker("open.ext"));
        fileMenu.add((IContributionItem)new Separator());
        fileMenu.add((IContributionItem)new GroupMarker("close.ext"));
        fileMenu.add((IAction)ActionFactory.CLOSE.create(window));
        fileMenu.add((IAction)ActionFactory.CLOSE_ALL.create(window));
        fileMenu.add((IContributionItem)new Separator());
        fileMenu.add((IContributionItem)new GroupMarker("save.ext"));
        fileMenu.add((IAction)ActionFactory.SAVE.create(window));
        fileMenu.add((IAction)ActionFactory.SAVE_ALL.create(window));
        fileMenu.add((IContributionItem)new Separator());
        fileMenu.add((IContributionItem)new GroupMarker("additions"));
        fileMenu.add((IContributionItem)new GroupMarker(ActionFactory.REFRESH.getId()));
        fileMenu.add((IContributionItem)new GroupMarker("rename.ext"));
        fileMenu.add((IContributionItem)new Separator());
        fileMenu.add((IContributionItem)new GroupMarker("print.ext"));
        fileMenu.add((IContributionItem)new Separator());
        fileMenu.add((IAction)ActionFactory.IMPORT.create(window));
        fileMenu.add((IAction)ActionFactory.EXPORT.create(window));
        fileMenu.add((IContributionItem)new Separator());
        fileMenu.add((IAction)ActionFactory.PROPERTIES.create(window));
        fileMenu.add((IContributionItem)new GroupMarker("config.ext"));
        fileMenu.add((IContributionItem)new Separator());
        fileMenu.add((IContributionItem)new GroupMarker("mru"));
        fileMenu.add((IContributionItem)new GroupMarker("fileEnd"));
        ActionFactory.IWorkbenchAction quit = ActionFactory.QUIT.create(window);
        ActionContributionItem item = new ActionContributionItem((IAction)quit);
        item.setVisible(!"macosx".equals(Platform.getOS()));
        fileMenu.add((IContributionItem)item);
    }

    protected void fillEditMenu(IMenuManager editMenu) {
        IWorkbenchWindow window = this.getActionBarConfigurer().getWindowConfigurer().getWindow();
        editMenu.add((IContributionItem)new GroupMarker("editStart"));
        editMenu.add((IContributionItem)new GroupMarker("undo.ext"));
        editMenu.add((IAction)ActionFactory.UNDO.create(window));
        editMenu.add((IAction)ActionFactory.REDO.create(window));
        editMenu.add((IContributionItem)new Separator());
        editMenu.add((IContributionItem)new GroupMarker("cut.ext"));
        editMenu.add((IAction)ActionFactory.CUT.create(window));
        editMenu.add((IAction)ActionFactory.COPY.create(window));
        editMenu.add((IAction)ActionFactory.PASTE.create(window));
        editMenu.add((IContributionItem)new Separator());
        editMenu.add((IAction)ActionFactory.DELETE.create(window));
        editMenu.add((IAction)ActionFactory.SELECT_ALL.create(window));
        editMenu.add((IContributionItem)new GroupMarker("add.ext"));
        editMenu.add((IContributionItem)new Separator());
        editMenu.add((IContributionItem)new GroupMarker("additions"));
        editMenu.add((IContributionItem)new GroupMarker("other"));
        editMenu.add((IContributionItem)new Separator());
        editMenu.add((IContributionItem)new GroupMarker("commit.exe"));
        editMenu.add((IContributionItem)new GroupMarker("editEnd"));
    }

    private void fillLayerMenu(IMenuManager menu) {
        menu.add((IContributionItem)new GroupMarker("wbStart"));
        menu.add((IContributionItem)new GroupMarker("add.ext"));
        menu.add((IContributionItem)new Separator());
        menu.add((IContributionItem)new GroupMarker("mapGraphic.ext"));
        menu.add((IContributionItem)new GroupMarker("mapGraphicOther.ext"));
        menu.add((IContributionItem)new Separator());
        menu.add((IContributionItem)new GroupMarker("additions"));
        menu.add((IContributionItem)new GroupMarker("edit.ext"));
        menu.add((IContributionItem)new GroupMarker("wbEnd"));
    }

    protected void fillWindowMenu(IMenuManager windowMenu) {
        IWorkbenchWindow window = this.getActionBarConfigurer().getWindowConfigurer().getWindow();
        windowMenu.add((IContributionItem)new GroupMarker("wbStart"));
        MenuManager perspectiveMenu = new MenuManager(Messages.UDIGWorkbenchAdvisor_open_perspective, ContributionItemFactory.PERSPECTIVES_SHORTLIST.getId());
        perspectiveMenu.add(ContributionItemFactory.PERSPECTIVES_SHORTLIST.create(window));
        windowMenu.add((IContributionItem)perspectiveMenu);
        MenuManager viewMenu = new MenuManager(Messages.UDIGWorkbenchAdvisor_show_view, ContributionItemFactory.VIEWS_SHORTLIST.getId());
        viewMenu.add(ContributionItemFactory.VIEWS_SHORTLIST.create(window));
        windowMenu.add((IContributionItem)viewMenu);
        windowMenu.add((IContributionItem)new Separator());
        ActionFactory.IWorkbenchAction resetPerspective = ActionFactory.RESET_PERSPECTIVE.create(window);
        resetPerspective.setText(Messages.UDIGWorkbenchAdvisor_resetPerspective_text);
        windowMenu.add((IAction)resetPerspective);
        ActionFactory.IWorkbenchAction closePerspective = ActionFactory.CLOSE_PERSPECTIVE.create(window);
        closePerspective.setText(Messages.UDIGWorkbenchAdvisor_closePerspective_text);
        windowMenu.add((IAction)closePerspective);
        ActionFactory.IWorkbenchAction closeAllPerspectives = ActionFactory.CLOSE_ALL_PERSPECTIVES.create(window);
        closeAllPerspectives.setText(Messages.UDIGWorkbenchAdvisor_closeAllPerspectives_text);
        windowMenu.add((IAction)closeAllPerspectives);
        windowMenu.add((IContributionItem)new GroupMarker("additions"));
        windowMenu.add((IContributionItem)new Separator());
        ActionFactory.IWorkbenchAction preferences = ActionFactory.PREFERENCES.create(window);
        preferences.setText(Messages.UDIGWorkbenchAdvisor_preferences_text);
        ActionContributionItem item = new ActionContributionItem((IAction)preferences);
        item.setVisible(!"macosx".equals(Platform.getOS()));
        windowMenu.add((IContributionItem)item);
        windowMenu.add(ContributionItemFactory.OPEN_WINDOWS.create(window));
        windowMenu.add((IContributionItem)new GroupMarker("wbEnd"));
    }

    protected void fillHelpMenu(IMenuManager helpMenu) {
        Separator welcome;
        IWorkbenchWindow window = this.getActionBarConfigurer().getWindowConfigurer().getWindow();
        boolean hasIntro = window.getWorkbench().getIntroManager().hasIntro();
        if (hasIntro) {
            if (helpMenu.findUsingPath(ActionFactory.INTRO.getId()) == null) {
                welcome = ActionFactory.INTRO.create(window);
                welcome.setText(Messages.UDIGWorkbenchAdvisor_welcome_text);
                if (helpMenu.getItems().length > 0) {
                    helpMenu.insertBefore(helpMenu.getItems()[0].getId(), (IAction)welcome);
                } else {
                    helpMenu.add((IAction)welcome);
                }
            }
        } else {
            welcome = new Separator(ActionFactory.INTRO.getId());
            if (helpMenu.getItems().length > 0) {
                helpMenu.insertBefore(helpMenu.getItems()[0].getId(), (IContributionItem)welcome);
            } else {
                helpMenu.add((IContributionItem)welcome);
            }
        }
        if (helpMenu.findUsingPath("helpStart") == null) {
            helpMenu.insertAfter(ActionFactory.INTRO.getId(), (IContributionItem)new GroupMarker("helpStart"));
        }
        if (helpMenu.findUsingPath(ActionFactory.HELP_CONTENTS.getId()) == null) {
            ActionFactory.IWorkbenchAction helpContents = ActionFactory.HELP_CONTENTS.create(window);
            helpContents.setText(Messages.UDIGWorkbenchAdvisor_helpContents_text);
            helpMenu.insertBefore("helpStart", (IAction)helpContents);
        }
        if (helpMenu.findUsingPath("helpEnd") == null) {
            helpMenu.insertAfter("helpStart", (IContributionItem)new GroupMarker("helpEnd"));
        }
        if (helpMenu.findUsingPath("additions") == null) {
            helpMenu.insertAfter("helpEnd", (IContributionItem)new GroupMarker("additions"));
        }
        helpMenu.insertAfter(ActionFactory.INTRO.getId(), (IContributionItem)new Separator());
        helpMenu.insertBefore("helpStart", (IContributionItem)new Separator());
        helpMenu.insertAfter("helpEnd", (IContributionItem)new Separator());
        this.addAboutItem(helpMenu, window);
    }

    private void addAboutItem(IMenuManager helpMenu, IWorkbenchWindow window) {
        if (helpMenu.findUsingPath(ActionFactory.ABOUT.getId()) == null) {
            String productName;
            ActionFactory.IWorkbenchAction about = ActionFactory.ABOUT.create(window);
            String pattern = Messages.UDIGWorkbenchAdvisor_aboutUDig_text;
            IProduct product = Platform.getProduct();
            if (product == null) {
                UiPlugin.log("there is no product so default to uDig", null);
                productName = "uDig";
            } else {
                productName = product.getName();
            }
            about.setText(MessageFormat.format(pattern, productName));
            ActionContributionItem item = new ActionContributionItem((IAction)about);
            item.setVisible(!"macosx".equals(Platform.getOS()));
            helpMenu.add((IContributionItem)item);
        }
    }
}

