/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.internal.ui;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import net.refractions.udig.core.internal.ExtensionPointList;
import net.refractions.udig.internal.ui.UiPlugin;
import net.refractions.udig.ui.internal.Messages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.service.prefs.Preferences;

public class TipDialog
extends Dialog {
    public static final String PREFERENCE_ID = "net.refractions.udig.ui.tips";
    public static final String EXTENSION_ID = "net.refractions.udig.ui.tip";
    private static Tip current;
    private static Configuration currentConfiguration;
    private Image image;
    private Label title;
    private Text tip;
    private Button check;
    private Label imageLabel;

    protected TipDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
    }

    protected void configureShell(Shell newShell) {
        newShell.setText(Messages.TipDialog_shellText);
        super.configureShell(newShell);
    }

    protected Point getInitialSize() {
        return new Point(400, 300);
    }

    protected Control createDialogArea(Composite parent) {
        boolean selected;
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setLayout((Layout)new GridLayout(2, false));
        this.imageLabel = new Label(composite, 0);
        this.imageLabel.setLayoutData((Object)new GridData(0, 0, false, false));
        this.title = new Label(composite, 0);
        GridData gridData = new GridData(4, 0, true, false);
        gridData.verticalAlignment = 0x1000008;
        this.title.setLayoutData((Object)gridData);
        this.tip = new Text(composite, 584);
        this.tip.setBackground(this.getShell().getDisplay().getSystemColor(22));
        gridData = new GridData(4, 4, true, true);
        gridData.horizontalSpan = 2;
        this.tip.setLayoutData((Object)gridData);
        this.updateTip();
        this.check = new Button(composite, 32);
        gridData = new GridData(4, 4, true, true);
        gridData.horizontalSpan = 2;
        this.check.setLayoutData((Object)gridData);
        this.check.setText(Messages.TipDialog_question);
        try {
            IPreferenceStore store = UiPlugin.getDefault().getPreferenceStore();
            selected = store.getBoolean("showTips");
        }
        catch (Exception e) {
            UiPlugin.log("", e);
            selected = true;
        }
        this.check.setSelection(selected);
        return composite;
    }

    private void updateTip() {
        if (TipDialog.getCurrentTip().image != null) {
            this.image = TipDialog.getCurrentTip().image.createImage();
            this.imageLabel.setImage(this.image);
        }
        this.title.setText(TipDialog.getCurrentTip().name);
        FontData[] fontData = this.getShell().getFont().getFontData();
        FontData[] newData = new FontData[fontData.length];
        int i = 0;
        while (i < fontData.length) {
            FontData data = fontData[i];
            newData[i] = new FontData(data.getName(), data.getHeight() + 2, 1);
            ++i;
        }
        this.title.setFont(new Font((Device)this.getShell().getDisplay(), newData));
        if (TipDialog.getCurrentTip() != null && TipDialog.getCurrentTip().hint != null) {
            this.tip.setText(TipDialog.getCurrentTip().hint);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 15, IDialogConstants.NEXT_LABEL, false);
        this.createButton(parent, 12, IDialogConstants.CLOSE_LABEL, true);
    }

    protected void buttonPressed(int buttonId) {
        if (15 == buttonId) {
            TipDialog.next(-1);
            this.updateTip();
        }
        if (buttonId == 12) {
            IPreferenceStore store = UiPlugin.getDefault().getPreferenceStore();
            store.setValue("showTips", this.check.getSelection());
            this.okPressed();
        }
    }

    public static boolean hasTips() {
        return TipDialog.getCurrentTip() != null;
    }

    private static Tip getCurrentTip() {
        if (current == null) {
            TipDialog.next(-1);
        }
        return current;
    }

    private static boolean isInCurrentConfiguration(IConfigurationElement elem) {
        if (currentConfiguration == null) {
            List extensions = ExtensionPointList.getExtensionPointList((String)EXTENSION_ID);
            IConfigurationElement mostRecent = null;
            for (IConfigurationElement element : extensions) {
                String attribute;
                if (!element.getName().equals("activeConfiguration") || (attribute = element.getAttribute("configurationID")) == null) continue;
                mostRecent = element;
            }
            if (mostRecent == null) {
                currentConfiguration = Configuration.DEFAULT;
            } else {
                for (IConfigurationElement element : extensions) {
                    if (!mostRecent.getAttribute("configurationID").equals(element.getAttribute("id"))) continue;
                    currentConfiguration = new Configuration(element);
                    break;
                }
                if (TipDialog.currentConfiguration.extensionIDs.size() == 0 && TipDialog.currentConfiguration.tipIDs.size() == 0) {
                    currentConfiguration = Configuration.DEFAULT;
                }
            }
        }
        if (currentConfiguration == Configuration.DEFAULT) {
            return true;
        }
        return TipDialog.currentConfiguration.tipIDs.contains(elem.getAttribute("id")) || TipDialog.currentConfiguration.extensionIDs.contains(elem.getDeclaringExtension().getUniqueIdentifier());
    }

    private static void next(int next2) {
        int next = next2;
        try {
            IConfigurationElement elem;
            Preferences node = TipDialog.getPreferences();
            List extensions = ExtensionPointList.getExtensionPointList((String)EXTENSION_ID);
            if (next == -1) {
                Random r = new Random();
                next = r.nextInt(extensions.size());
            }
            int i = next;
            while (i < extensions.size()) {
                elem = (IConfigurationElement)extensions.get(i);
                if (TipDialog.isPermittedNext(node, elem)) {
                    node.put(elem.getAttribute("id"), "");
                    current = new Tip(elem);
                    return;
                }
                ++i;
            }
            i = 0;
            while (i < next) {
                elem = (IConfigurationElement)extensions.get(i);
                if (TipDialog.isPermittedNext(node, elem)) {
                    node.put(elem.getAttribute("id"), "");
                    current = new Tip(elem);
                    return;
                }
                ++i;
            }
            if (node.keys().length == 0) {
                current = null;
                return;
            }
            node.clear();
            TipDialog.next(next);
        }
        catch (Exception e) {
            UiPlugin.log("", e);
        }
    }

    private static boolean isPermittedNext(Preferences node, IConfigurationElement elem) {
        boolean notSameAsCurrent;
        if (!elem.getName().equals("tip")) {
            return false;
        }
        boolean notPreviouslyShown = node.get(elem.getAttribute("id"), null) == null;
        boolean bl = notSameAsCurrent = current == null || !elem.getAttribute("id").equals(TipDialog.current.id);
        return notPreviouslyShown && notSameAsCurrent && TipDialog.isInCurrentConfiguration(elem);
    }

    public static Preferences getPreferences() throws CoreException, IOException {
        Preferences userPreferences = UiPlugin.getUserPreferences();
        Preferences node = userPreferences.node(PREFERENCE_ID);
        return node;
    }

    private static class Configuration {
        public static final Configuration DEFAULT = new Configuration();
        Collection<String> tipIDs;
        Collection<String> extensionIDs;

        Configuration(IConfigurationElement confElem) {
            IConfigurationElement[] extensionRefs;
            IConfigurationElement[] tipRefs;
            this.tipIDs = new HashSet<String>();
            this.extensionIDs = new HashSet<String>();
            IConfigurationElement[] iConfigurationElementArray = tipRefs = confElem.getChildren("tipRef");
            int n = tipRefs.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                String attribute = element.getAttribute("tipID");
                if (attribute != null) {
                    this.tipIDs.add(attribute);
                }
                ++n2;
            }
            IConfigurationElement[] iConfigurationElementArray2 = extensionRefs = confElem.getChildren("tipExtensionRef");
            int n3 = extensionRefs.length;
            n = 0;
            while (n < n3) {
                IConfigurationElement element = iConfigurationElementArray2[n];
                String attribute = element.getAttribute("extensionID");
                if (attribute != null) {
                    this.extensionIDs.add(attribute);
                }
                ++n;
            }
        }

        Configuration() {
        }
    }

    private static class Tip {
        public String id;
        ImageDescriptor image;
        String name;
        String hint;

        Tip(IConfigurationElement tipElem) {
            this.id = tipElem.getAttribute("id");
            this.name = tipElem.getAttribute("name");
            this.hint = tipElem.getValue();
            this.image = tipElem.getAttribute("icon") != null ? AbstractUIPlugin.imageDescriptorFromPlugin((String)tipElem.getNamespaceIdentifier(), (String)tipElem.getAttribute("icon")) : AbstractUIPlugin.imageDescriptorFromPlugin((String)"net.refractions.udig.ui", (String)"icons/elcl16/light.GIF");
        }
    }
}

