/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.internal.ui;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import net.refractions.udig.ui.PlatformGIS;
import net.refractions.udig.ui.UIUtilities;
import net.refractions.udig.ui.internal.Messages;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SubmitIssueDialog
extends TitleAreaDialog {
    private Link submitIssueLink;
    private Label logLabel;
    private Text log;
    private boolean hasLog = false;

    public SubmitIssueDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(0x10870 | SubmitIssueDialog.getDefaultOrientation());
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.SendLogDialog_title);
    }

    protected Point getInitialSize() {
        return new Point(640, 720);
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.SendLogDialog_description);
        Composite composite = new Composite(parent, 16);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        SubmitIssueDialog.applyDialogFont((Control)composite);
        this.submitIssueLink = new Link(composite, 74);
        GridData gridData = new GridData(4, 4, true, false);
        gridData.horizontalSpan = 2;
        this.submitIssueLink.setBackground(this.getShell().getDisplay().getSystemColor(22));
        this.submitIssueLink.setLayoutData((Object)gridData);
        this.submitIssueLink.setText(Messages.SubmitIssueDialog_instructions);
        this.submitIssueLink.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                UIUtilities.openLink(event.text);
            }
        });
        this.logLabel = new Label(composite, 0);
        gridData = new GridData(4, 4, true, false);
        gridData.verticalAlignment = 0x1000008;
        this.logLabel.setLayoutData((Object)gridData);
        this.logLabel.setText(Messages.SendLogDialog_log);
        this.log = new Text(composite, 2634);
        this.log.setBackground(this.getShell().getDisplay().getSystemColor(22));
        gridData = new GridData(4, 4, true, true);
        gridData.horizontalSpan = 2;
        this.log.setLayoutData((Object)gridData);
        this.log.setText(Messages.SendLogDialog_reading);
        this.log.setEnabled(false);
        PopulateLogRunnable populateLog = new PopulateLogRunnable();
        PlatformGIS.run(populateLog);
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 10, Messages.SubmitIssueDialog_copy, false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.refreshButtons();
    }

    private void refreshButtons() {
        Button proceed = this.getButton(10);
        proceed.setEnabled(this.hasLog);
    }

    protected void buttonPressed(int buttonId) {
        if (10 == buttonId) {
            try {
                this.log.selectAll();
                this.log.copy();
            }
            catch (RuntimeException e) {
                throw (RuntimeException)new RuntimeException().initCause(e);
            }
        }
        if (buttonId == 1) {
            this.okPressed();
        }
    }

    public static boolean logExists() {
        String filename = Platform.getLogFileLocation().toOSString();
        File log = new File(filename);
        return log.exists();
    }

    /*
     * Loose catch block
     */
    private String getLogText(IProgressMonitor monitor) {
        String line;
        String filename = Platform.getLogFileLocation().toOSString();
        File file = new File(filename);
        FileReader in = null;
        BufferedReader br = null;
        StringBuilder content = new StringBuilder();
        in = new FileReader(file);
        br = new BufferedReader(in);
        while ((line = br.readLine()) != null) {
            content.append(line);
            content.append("\n");
        }
        String string = content.toString();
        try {
            if (br != null) {
                br.close();
            }
            if (in != null) {
                in.close();
            }
        }
        catch (IOException iOException) {}
        return string;
        catch (IOException iOException) {
            try {}
            catch (Throwable throwable) {
                try {
                    if (br != null) {
                        br.close();
                    }
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException iOException2) {}
                throw throwable;
            }
            try {
                if (br != null) {
                    br.close();
                }
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException3) {}
            return null;
        }
    }

    private class PopulateLogRunnable
    implements IRunnableWithProgress {
        private PopulateLogRunnable() {
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            String text = SubmitIssueDialog.logExists() ? SubmitIssueDialog.this.getLogText(monitor) : Messages.SendLogDialog_empty;
            if (monitor.isCanceled()) {
                throw new InterruptedException("Log acquisition was canceled.");
            }
            final String logText = text;
            PlatformGIS.syncInDisplayThread(new Runnable(){

                @Override
                public void run() {
                    SubmitIssueDialog.this.log.setText(logText);
                    SubmitIssueDialog.this.log.setEnabled(true);
                    SubmitIssueDialog.this.hasLog = true;
                    SubmitIssueDialog.this.refreshButtons();
                }
            });
        }
    }
}

