/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.internal.ui;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import net.refractions.udig.internal.ui.UiPlugin;
import net.refractions.udig.ui.PlatformGIS;
import net.refractions.udig.ui.internal.Messages;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SendLogDialog
extends TitleAreaDialog {
    private Label contactLabel;
    private Text contact;
    private Label noteLabel;
    private Text notes;
    private Label logLabel;
    private Text log;
    boolean hasLog = false;

    protected SendLogDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(0x10870 | SendLogDialog.getDefaultOrientation());
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.SendLogDialog_title);
    }

    protected Point getInitialSize() {
        return new Point(640, 720);
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.SendLogDialog_description);
        ImageDescriptor image = UiPlugin.getDefault().getImageDescriptor("wizban/log_wiz.png");
        if (image != null) {
            this.setTitleImage(image.createImage());
        }
        Composite composite = new Composite(parent, 16);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        SendLogDialog.applyDialogFont((Control)composite);
        this.contactLabel = new Label(composite, 0);
        this.contactLabel.setLayoutData((Object)new GridData(0, 0, false, false));
        this.contactLabel.setText(Messages.SendLogDialog_contact);
        this.contact = new Text(composite, 2048);
        GridData gridData = new GridData(4, 4, true, false);
        gridData = new GridData(4, 4, true, false);
        gridData.horizontalSpan = 2;
        this.contact.setLayoutData((Object)gridData);
        this.contact.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SendLogDialog.this.refreshButtons();
            }
        });
        this.noteLabel = new Label(composite, 0);
        this.noteLabel.setLayoutData((Object)new GridData(0, 0, false, false));
        this.noteLabel.setText(Messages.SendLogDialog_notes);
        this.notes = new Text(composite, 2114);
        gridData = new GridData(4, 4, true, false);
        gridData = new GridData(4, 4, true, false);
        gridData.heightHint = this.notes.getLineHeight() * 2;
        gridData.horizontalSpan = 2;
        this.notes.setLayoutData((Object)gridData);
        this.notes.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SendLogDialog.this.refreshButtons();
            }
        });
        this.logLabel = new Label(composite, 0);
        gridData = new GridData(4, 4, true, false);
        gridData.verticalAlignment = 0x1000008;
        this.logLabel.setLayoutData((Object)gridData);
        this.logLabel.setText(Messages.SendLogDialog_log);
        this.log = new Text(composite, 2634);
        this.log.setBackground(this.getShell().getDisplay().getSystemColor(22));
        gridData = new GridData(4, 4, true, true);
        gridData.horizontalSpan = 2;
        this.log.setLayoutData((Object)gridData);
        this.log.setText(Messages.SendLogDialog_reading);
        this.log.setEnabled(false);
        PopulateLogRunnable populateLog = new PopulateLogRunnable();
        PlatformGIS.run(populateLog);
        this.contact.setFocus();
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 10, Messages.SendLogDialog_submit, false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.refreshButtons();
    }

    private void refreshButtons() {
        boolean hasContact = false;
        boolean hasNote = false;
        if (this.notes.getText() != null && this.notes.getText().length() > 0) {
            hasNote = true;
        }
        if (this.contact.getText() != null && this.contact.getText().length() > 0) {
            hasContact = true;
        }
        Button proceed = this.getButton(10);
        if (hasContact && hasNote) {
            this.setMessage(null);
            proceed.setEnabled(this.hasLog);
        } else if (!hasContact) {
            this.setMessage(Messages.SendLogDialog_contact_message, 2);
            proceed.setEnabled(false);
        } else {
            this.setMessage(Messages.SendLogDialog_notes_message, 2);
            proceed.setEnabled(false);
        }
    }

    protected void buttonPressed(int buttonId) {
        if (10 == buttonId) {
            try {
                try {
                    this.sendLog();
                }
                catch (RuntimeException e) {
                    throw (RuntimeException)new RuntimeException().initCause(e);
                }
            }
            finally {
                this.okPressed();
            }
        }
        if (buttonId == 1) {
            this.okPressed();
        }
    }

    private void sendLog() {
        try {
            try {
                URL url = new URL("http://udig.refractions.net/errorlog.php");
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("POST");
                connection.setDoOutput(true);
                connection.setRequestProperty("Content-type", "application/x-www-form-urlencoded");
                connection.setDoInput(true);
                StringBuilder text = new StringBuilder();
                text.append("Contact:\r\n");
                text.append(this.contact.getText());
                text.append("\r\n\r\nUser comments:\r\n");
                text.append(this.notes.getText());
                text.append("\r\n\r\nSystem Info:\r\n");
                text.append(this.getSystemInfo());
                text.append("\r\n----\r\n\r\n");
                text.append(this.log.getText());
                text.append("\r\n");
                String body = "body=" + URLEncoder.encode(text.toString(), "UTF-8");
                OutputStream outStream = connection.getOutputStream();
                outStream.write(body.getBytes());
                outStream.flush();
                outStream.close();
                connection.getResponseCode();
            }
            catch (Exception e) {
                UiPlugin.log("Error log submission failed", e);
                UiPlugin.log("Log submitted, chars: " + this.log.getText().length(), null);
            }
        }
        finally {
            UiPlugin.log("Log submitted, chars: " + this.log.getText().length(), null);
        }
    }

    public static boolean logExists() {
        String filename = Platform.getLogFileLocation().toOSString();
        File log = new File(filename);
        return log.exists();
    }

    private String getSystemInfo() {
        StringBuilder content = new StringBuilder();
        content.append("uDig ");
        content.append(UiPlugin.getDefault().getVersion());
        return content.toString();
    }

    /*
     * Loose catch block
     */
    private String getLogText(IProgressMonitor monitor) {
        String line;
        String filename = Platform.getLogFileLocation().toOSString();
        File file = new File(filename);
        FileReader in = null;
        BufferedReader br = null;
        StringBuilder content = new StringBuilder();
        in = new FileReader(file);
        br = new BufferedReader(in);
        while ((line = br.readLine()) != null) {
            content.append(line);
            content.append("\n");
        }
        String string = content.toString();
        try {
            if (br != null) {
                br.close();
            }
            if (in != null) {
                in.close();
            }
        }
        catch (IOException iOException) {}
        return string;
        catch (IOException iOException) {
            try {}
            catch (Throwable throwable) {
                try {
                    if (br != null) {
                        br.close();
                    }
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException iOException2) {}
                throw throwable;
            }
            try {
                if (br != null) {
                    br.close();
                }
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException3) {}
            return null;
        }
    }

    private class PopulateLogRunnable
    implements IRunnableWithProgress {
        private PopulateLogRunnable() {
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            String text = SendLogDialog.logExists() ? SendLogDialog.this.getLogText(monitor) : Messages.SendLogDialog_empty;
            if (monitor.isCanceled()) {
                throw new InterruptedException("Log acquisition was canceled.");
            }
            final String logText = text;
            PlatformGIS.syncInDisplayThread(new Runnable(){

                @Override
                public void run() {
                    SendLogDialog.this.log.setText(logText);
                    SendLogDialog.this.log.setEnabled(true);
                    ((PopulateLogRunnable)PopulateLogRunnable.this).SendLogDialog.this.hasLog = true;
                    SendLogDialog.this.refreshButtons();
                }
            });
        }
    }
}

