/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.internal.ui;

import java.io.StringReader;
import javax.xml.transform.TransformerException;
import net.refractions.udig.internal.ui.TransferStrategy;
import net.refractions.udig.internal.ui.UDIGTransfer;
import net.refractions.udig.ui.AbstractTextStrategizedTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.TransferData;
import org.geotools.filter.FilterFilter;
import org.geotools.filter.FilterHandler;
import org.geotools.filter.FilterTransformer;
import org.geotools.gml.GMLFilterDocument;
import org.geotools.gml.GMLFilterGeometry;
import org.geotools.gml.GMLHandlerGeometry;
import org.geotools.gml.GMLHandlerJTS;
import org.opengis.filter.Filter;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class FilterTextTransfer
extends AbstractTextStrategizedTransfer
implements UDIGTransfer {
    private static FilterTextTransfer _instance = new FilterTextTransfer();
    private TransferStrategy[] transferStrategies;

    private FilterTextTransfer() {
    }

    public static FilterTextTransfer getInstance() {
        return _instance;
    }

    @Override
    public synchronized TransferStrategy[] getAllStrategies() {
        if (this.transferStrategies == null) {
            this.transferStrategies = new TransferStrategy[]{new GMLFilterStrategy()};
        }
        TransferStrategy[] copy = new TransferStrategy[this.transferStrategies.length];
        System.arraycopy(this.transferStrategies, 0, copy, 0, this.transferStrategies.length);
        return copy;
    }

    @Override
    public String[] getStrategyNames() {
        return new String[]{"GML"};
    }

    @Override
    public String getTransferName() {
        return "Filter";
    }

    @Override
    public TransferStrategy getDefaultStrategy() {
        return this.getAllStrategies()[0];
    }

    public TransferData[] getSupportedTypes() {
        return TextTransfer.getInstance().getSupportedTypes();
    }

    public boolean isSupportedType(TransferData transferData) {
        return TextTransfer.getInstance().isSupportedType(transferData);
    }

    @Override
    public boolean validate(Object object) {
        return object instanceof Filter;
    }

    private static class GMLFilterStrategy
    implements TransferStrategy {
        private GMLFilterStrategy() {
        }

        @Override
        public void javaToNative(Object object, TransferData transferData) {
            Filter filter = (Filter)object;
            FilterTransformer transformer = new FilterTransformer();
            transformer.setIndentation(4);
            try {
                String transform = transformer.transform(filter);
                TextTransfer.getInstance().javaToNative((Object)transform, transferData);
            }
            catch (TransformerException e) {
                throw (RuntimeException)new RuntimeException().initCause(e);
            }
        }

        @Override
        public Object nativeToJava(TransferData transferData) {
            String string = (String)TextTransfer.getInstance().nativeToJava(transferData);
            InputSource input = new InputSource(new StringReader(string));
            SimpleFilterHandler simpleFilterHandler = new SimpleFilterHandler();
            FilterFilter filterFilter = new FilterFilter((FilterHandler)simpleFilterHandler, null);
            GMLFilterGeometry filterGeometry = new GMLFilterGeometry((GMLHandlerJTS)filterFilter);
            GMLFilterDocument filterDocument = new GMLFilterDocument((GMLHandlerGeometry)filterGeometry);
            try {
                XMLReader reader = XMLReaderFactory.createXMLReader();
                reader.setContentHandler((ContentHandler)filterDocument);
                reader.parse(input);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return simpleFilterHandler.getFilter();
        }
    }

    public static class SimpleFilterHandler
    extends DefaultHandler
    implements FilterHandler {
        private Filter filter;

        public void filter(Filter filter) {
            this.filter = filter;
        }

        public Filter getFilter() {
            return this.filter;
        }
    }
}

