/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.aoi;

import com.vividsolutions.jts.geom.Geometry;
import net.refractions.udig.aoi.AOIListener;
import net.refractions.udig.aoi.IAOIStrategy;
import net.refractions.udig.internal.ui.UiPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.part.IPageBookViewPage;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class AOIProxy
extends IAOIStrategy {
    private IConfigurationElement configElement = null;
    private IAOIStrategy strategy = null;
    private String id;

    public AOIProxy(IConfigurationElement config) {
        this.configElement = config;
        this.id = this.configElement.getAttribute("id");
    }

    @Override
    public ReferencedEnvelope getExtent() {
        return this.getStrategy().getExtent();
    }

    @Override
    public Geometry getGeometry() {
        return this.getStrategy().getGeometry();
    }

    @Override
    public CoordinateReferenceSystem getCrs() {
        return this.getStrategy().getCrs();
    }

    @Override
    public String getName() {
        return this.configElement.getAttribute("name");
    }

    public synchronized IAOIStrategy getStrategy() {
        if (this.strategy == null) {
            try {
                this.strategy = (IAOIStrategy)this.configElement.createExecutableExtension("class");
            }
            catch (CoreException e) {
                String name = this.configElement.getAttribute("class");
                this.blame("Strategy " + name + " not available (" + this.id + ")", e);
            }
        }
        return this.strategy;
    }

    @Override
    public synchronized IPageBookViewPage createPage() {
        String name;
        IPageBookViewPage page = null;
        try {
            page = this.getStrategy().createPage();
        }
        catch (Throwable t) {
            this.blame("Page " + this.id + " not available", t);
        }
        if (page == null && (name = this.configElement.getAttribute("page")) != null && !name.isEmpty()) {
            try {
                page = (IPageBookViewPage)this.configElement.createExecutableExtension("page");
            }
            catch (CoreException e) {
                this.blame("Page " + name + " not available (" + this.id + ")", e);
            }
        }
        return page;
    }

    public void blame(String message, Throwable t) {
        String contributorId = this.configElement.getContributor().getName();
        String msg = message == null ? t.getMessage() : String.valueOf(message) + t.getMessage();
        Status status = new Status(2, contributorId, msg, t);
        UiPlugin.getDefault().getLog().log((IStatus)status);
    }

    public String getId() {
        return this.id;
    }

    @Override
    public void addListener(AOIListener listener) {
        this.getStrategy().addListener(listener);
    }

    @Override
    public void removeListener(AOIListener listener) {
        this.getStrategy().removeListener(listener);
    }

    @Override
    protected void notifyListeners(AOIListener.Event changed) {
        this.getStrategy().notifyListeners(changed);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AOIProxy other = (AOIProxy)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }
}

