/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.internal.mysql.ui;

import com.mysql.jdbc.jdbc2.optional.MysqlDataSource;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Set;
import net.refractions.udig.catalog.internal.mysql.ui.MySqlDialect;
import net.refractions.udig.catalog.service.database.LookUpSchemaRunnable;
import net.refractions.udig.catalog.service.database.TableDescriptor;
import net.refractions.udig.core.Pair;
import org.eclipse.core.runtime.IProgressMonitor;

public class MySqlLookUpSchemaRunnable
implements LookUpSchemaRunnable {
    private final String host;
    private final int port;
    private final String username;
    private final String password;
    private final String database;
    private final Set<TableDescriptor> tables = new HashSet<TableDescriptor>();
    private volatile String error;
    private volatile boolean ran = false;

    public MySqlLookUpSchemaRunnable(String host, int port, String username, String password, String database) {
        this.host = host;
        this.port = port;
        this.username = username;
        this.password = password;
        this.database = database;
    }

    public void run(IProgressMonitor monitor) {
        MysqlDataSource ds = new MysqlDataSource();
        ds.setServerName(this.host);
        ds.setPort(this.port);
        ds.setDatabaseName(this.database);
        ds.setUser(this.username);
        ds.setPassword(this.password);
        DriverManager.setLoginTimeout(3);
        try {
            this.loadTableDescriptrs(ds);
        }
        catch (SQLException sQLException) {
            this.error = "Unrecognized connection failure.  Check parameters and database.";
        }
        this.ran = true;
    }

    private void loadTableDescriptrs(MysqlDataSource ds) throws SQLException {
        MySqlDialect dialect = new MySqlDialect();
        Connection connection = ds.getConnection(this.username, this.password);
        try {
            try {
                Statement statement = connection.createStatement();
                if (statement.execute("SHOW TABLES;")) {
                    ResultSet resultSet = statement.getResultSet();
                    while (resultSet.next()) {
                        String table = resultSet.getString("Tables_in_" + this.database);
                        Pair<String, Pair<String, String>> results = this.lookupGeometryColumn(table, connection);
                        if (results == null) continue;
                        String geometryColumn = (String)results.getLeft();
                        String geometryType = (String)((Pair)results.getRight()).getLeft();
                        String srid = (String)((Pair)results.getRight()).getRight();
                        this.tables.add(new TableDescriptor(table, dialect.toGeomClass(geometryType), null, geometryColumn, srid, false));
                    }
                }
                statement.close();
            }
            catch (SQLException e) {
                this.error = "An error occurred when querying the database about the data it contains. Please talk to the administrator: " + e.getMessage();
                connection.close();
            }
        }
        finally {
            connection.close();
        }
    }

    private Pair<String, Pair<String, String>> lookupGeometryColumn(String table, Connection connection) throws SQLException {
        Statement statement = connection.createStatement();
        try {
            String sql = "SHOW FIELDS FROM " + table + " ;";
            if (statement.execute(sql)) {
                ResultSet results = statement.getResultSet();
                while (results.next()) {
                    Pair all;
                    if (!results.getString("Type").equalsIgnoreCase("geometry")) continue;
                    Pair typeSrid = new Pair((Object)results.getString("Type"), (Object)"4362");
                    String geom = results.getString("Field");
                    Pair pair = all = new Pair((Object)geom, (Object)typeSrid);
                    return pair;
                }
            }
            return null;
        }
        finally {
            statement.close();
        }
    }

    public String getError() throws IllegalStateException {
        if (!this.ran) {
            throw new IllegalStateException("run must complete running before this method is called.");
        }
        return this.error;
    }

    public Set<TableDescriptor> getTableDescriptors() {
        return this.tables;
    }
}

