/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.internal.mysql.ui;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.sql.DataSource;
import net.refractions.udig.catalog.MySQLServiceExtension;
import net.refractions.udig.catalog.internal.mysql.MySQLPlugin;
import net.refractions.udig.catalog.internal.mysql.ui.MySQLuDigConnectionFactory;
import net.refractions.udig.catalog.mysql.internal.Messages;
import net.refractions.udig.catalog.ui.UDIGConnectionPage;
import net.refractions.udig.catalog.ui.wizard.DataBaseConnInfo;
import net.refractions.udig.catalog.ui.wizard.DataBaseRegistryWizardPage;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.PlatformUI;
import org.geotools.data.DataStoreFactorySpi;
import org.geotools.data.mysql.MySQLDataStoreFactory;
import org.geotools.jdbc.JDBCDataStoreFactory;

public class MySQLWizardPage
extends DataBaseRegistryWizardPage
implements UDIGConnectionPage {
    private static final String MYSQL_WIZARD = "MYSQL_WIZARD";
    private static final String MYSQL_RECENT = "MYSQL_RECENT";
    private static final DataBaseConnInfo DEFAULT_MYSQL_CONN_INFO = new DataBaseConnInfo("localhost", "3306", "", "", "test", "");
    private static MySQLDataStoreFactory factory = new MySQLDataStoreFactory();
    public final String IMAGE_KEY = "MySQLWizardPageImage";
    MySQLuDigConnectionFactory mycFactory = new MySQLuDigConnectionFactory();

    public MySQLWizardPage() {
        super(Messages.MySQLWizardPage_title);
        try {
            Class.forName("com.mysql.jdbc.Driver");
        }
        catch (ClassNotFoundException e) {
            throw (RuntimeException)new RuntimeException().initCause(e);
        }
        this.settings = MySQLPlugin.getDefault().getDialogSettings().getSection(MYSQL_WIZARD);
        if (this.settings == null) {
            this.settings = MySQLPlugin.getDefault().getDialogSettings().addNewSection(MYSQL_WIZARD);
        }
        this.settingsArrayName = MYSQL_RECENT;
        String[] recent = this.settings.getArray(MYSQL_RECENT);
        if (recent != null) {
            String[] stringArray = recent;
            int n = recent.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                DataBaseConnInfo dbs = new DataBaseConnInfo(s);
                if (!this.storedDBCIList.contains(dbs)) {
                    this.storedDBCIList.add(dbs);
                }
                ++n2;
            }
        }
        this.defaultDBCI.setParameters(DEFAULT_MYSQL_CONN_INFO);
        this.currentDBCI.setParameters(this.defaultDBCI);
        this.dbExclusionList.add("mysql");
        this.dbExclusionList.add("information_schema");
    }

    protected Map<String, Serializable> getParamsFromWorkbenchSelection() {
        IStructuredSelection selection = (IStructuredSelection)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
        if (selection == null) {
            return Collections.emptyMap();
        }
        Iterator itr = selection.iterator();
        while (itr.hasNext()) {
            Map<String, Serializable> params = this.mycFactory.createConnectionParameters(itr.next());
            if (params == null || params.isEmpty()) continue;
            return params;
        }
        return Collections.emptyMap();
    }

    public void createControl(Composite arg0) {
        super.createControl(arg0);
        Map<String, Serializable> params = this.getParamsFromWorkbenchSelection();
        String selectedHost = (String)((Object)params.get(MySQLDataStoreFactory.HOST.key));
        if (selectedHost != null) {
            this.hostTextWgt.setText(params.get(JDBCDataStoreFactory.HOST.key).toString());
            this.portTextWgt.setText(params.get(JDBCDataStoreFactory.PORT.key).toString());
            this.userTextWgt.setText(params.get(JDBCDataStoreFactory.USER.key).toString());
            this.passTextWgt.setText(params.get(JDBCDataStoreFactory.PASSWD.key).toString());
            this.dbComboWgt.setText(params.get(JDBCDataStoreFactory.DATABASE.key).toString());
        }
    }

    protected DataStoreFactorySpi getDataStoreFactorySpi() {
        return factory;
    }

    public String getId() {
        return "net.refractions.udig.catalog.ui.mysql";
    }

    protected Map<String, Serializable> defaultParams() {
        IStructuredSelection selection = (IStructuredSelection)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
        return this.toParams(selection);
    }

    protected Map<String, Serializable> toParams(IStructuredSelection context) {
        if (context == null) {
            return Collections.emptyMap();
        }
        Iterator itr = context.iterator();
        while (itr.hasNext()) {
            Map<String, Serializable> params = this.mycFactory.createConnectionParameters(itr.next());
            if (params == null || params.isEmpty()) continue;
            return params;
        }
        return Collections.emptyMap();
    }

    protected DataSource getDataSource() {
        this.runInPage(new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                Connection connection;
                block19: {
                    block20: {
                        monitor.beginTask(Messages.MySQLWizardPage_0, -1);
                        if (MySQLWizardPage.this.dataSource != null) {
                            try {
                                MySQLWizardPage.this.dataSource.close();
                            }
                            catch (SQLException sQLException) {}
                        }
                        connection = null;
                        HashMap<String, Object> params = new HashMap<String, Object>();
                        params.put(JDBCDataStoreFactory.DBTYPE.key, "mysql");
                        params.put(JDBCDataStoreFactory.HOST.key, MySQLWizardPage.this.currentDBCI.getHostString());
                        try {
                            params.put(JDBCDataStoreFactory.PORT.key, (Integer)JDBCDataStoreFactory.PORT.parse(MySQLWizardPage.this.currentDBCI.getPortString()));
                        }
                        catch (Throwable throwable) {}
                        params.put(JDBCDataStoreFactory.DATABASE.key, MySQLWizardPage.this.currentDBCI.getDbString());
                        MySQLWizardPage.this.dataSource = MySQLServiceExtension.getFactory().createDataSource(params);
                        MySQLWizardPage.this.dataSource.setUsername(MySQLWizardPage.this.currentDBCI.getUserString());
                        MySQLWizardPage.this.dataSource.setPassword(MySQLWizardPage.this.currentDBCI.getPassString());
                        DriverManager.setLoginTimeout(3);
                        if (!monitor.isCanceled()) break block19;
                        MySQLWizardPage.this.dataSource = null;
                        if (connection == null) break block20;
                        try {
                            connection.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                    return;
                }
                try {
                    try {
                        connection = MySQLWizardPage.this.dataSource.getConnection();
                        monitor.done();
                    }
                    catch (IOException e) {
                        throw new InvocationTargetException(e);
                    }
                    catch (SQLException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                catch (Throwable throwable) {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                    throw throwable;
                }
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
        });
        return this.dataSource;
    }

    protected boolean dbmsUsesSchema() {
        return false;
    }

    public boolean isPageComplete() {
        return this.dataSource != null && factory.canProcess(this.getParams());
    }

    public Map<String, Serializable> getParams() {
        HashMap<String, Serializable> params = new HashMap<String, Serializable>();
        params.put(MySQLDataStoreFactory.DBTYPE.key, (Serializable)((Object)"mysql"));
        this.currentDBCI.treatEmptyStringAsNull(true);
        params.put(MySQLDataStoreFactory.HOST.key, (Serializable)((Object)this.currentDBCI.getHostString()));
        params.put(MySQLDataStoreFactory.PORT.key, new Integer(this.currentDBCI.getPortString()));
        params.put(MySQLDataStoreFactory.USER.key, (Serializable)((Object)this.currentDBCI.getUserString()));
        params.put(MySQLDataStoreFactory.PASSWD.key, (Serializable)((Object)this.currentDBCI.getPassString()));
        params.put(MySQLDataStoreFactory.DATABASE.key, (Serializable)((Object)this.currentDBCI.getDbString()));
        this.currentDBCI.treatEmptyStringAsNull(false);
        params.put("namespace", (Serializable)((Object)""));
        return params;
    }
}

