/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import net.refractions.udig.catalog.AbstractDataStoreServiceExtension;
import net.refractions.udig.catalog.IService;
import net.refractions.udig.catalog.MySQLServiceImpl;
import net.refractions.udig.catalog.ServiceExtension2;
import net.refractions.udig.catalog.internal.mysql.MySQLPlugin;
import net.refractions.udig.catalog.mysql.internal.Messages;
import net.refractions.udig.core.internal.CorePlugin;
import org.geotools.data.DataAccessFactory;
import org.geotools.data.DataStoreFactorySpi;
import org.geotools.data.mysql.MySQLDataStoreFactory;

public class MySQLServiceExtension
extends AbstractDataStoreServiceExtension
implements ServiceExtension2 {
    private static MySQLDataStoreFactory factory = null;

    public IService createService(URL id, Map<String, Serializable> params) {
        if (params != null && params.containsKey(MySQLDataStoreFactory.PORT.key) && params.get(MySQLDataStoreFactory.PORT.key) instanceof Integer) {
            String val = params.get(MySQLDataStoreFactory.PORT.key).toString();
            params.remove(val);
            params.put(MySQLDataStoreFactory.PORT.key, (Serializable)((Object)val));
        }
        if (!MySQLServiceExtension.getFactory().canProcess(params)) {
            return null;
        }
        if (id == null) {
            try {
                URL toURL = MySQLServiceExtension.toURL(params);
                return new MySQLServiceImpl(toURL, params);
            }
            catch (MalformedURLException e) {
                MySQLPlugin.log("Unable to construct proper service URL.", e);
                return null;
            }
        }
        return new MySQLServiceImpl(id, params);
    }

    public static URL toURL(Map<String, Serializable> params) throws MalformedURLException {
        String the_host = (String)((Object)params.get(MySQLDataStoreFactory.HOST.key));
        String intPort = (String)((Object)params.get(MySQLDataStoreFactory.PORT.key));
        String the_database = (String)((Object)params.get(MySQLDataStoreFactory.DATABASE.key));
        String the_username = (String)((Object)params.get(MySQLDataStoreFactory.USER.key));
        String the_password = (String)((Object)params.get(MySQLDataStoreFactory.PASSWD.key));
        URL toURL = MySQLServiceExtension.toURL(the_username, the_password, the_host, intPort, the_database);
        return toURL;
    }

    public Map<String, Serializable> createParams(URL url) {
        if (!MySQLServiceExtension.isMySQL(url)) {
            return null;
        }
        AbstractDataStoreServiceExtension.ParamInfo info = this.parseParamInfo(url);
        HashMap<String, Serializable> params = new HashMap<String, Serializable>();
        params.put(MySQLDataStoreFactory.DBTYPE.key, (Serializable)MySQLDataStoreFactory.DBTYPE.sample);
        params.put(MySQLDataStoreFactory.HOST.key, (Serializable)((Object)info.host));
        params.put(MySQLDataStoreFactory.PORT.key, (Serializable)((Object)info.the_port.toString()));
        params.put(MySQLDataStoreFactory.DATABASE.key, (Serializable)((Object)info.the_database));
        params.put(MySQLDataStoreFactory.USER.key, (Serializable)((Object)info.username));
        params.put(MySQLDataStoreFactory.PASSWD.key, (Serializable)((Object)info.password));
        return params;
    }

    public static MySQLDataStoreFactory getFactory() {
        if (factory == null) {
            factory = new MySQLDataStoreFactory();
        }
        return factory;
    }

    public static DataAccessFactory.Param getPram(String key) {
        DataAccessFactory.Param[] paramArray = MySQLServiceExtension.getFactory().getParametersInfo();
        int n = paramArray.length;
        int n2 = 0;
        while (n2 < n) {
            DataAccessFactory.Param param = paramArray[n2];
            if (key.equals(param.key)) {
                return param;
            }
            ++n2;
        }
        return null;
    }

    public static final boolean isMySQL(URL url) {
        if (url == null) {
            return false;
        }
        return url.getProtocol().toLowerCase().equals("mysql") || url.getProtocol().toLowerCase().equals("mysql.jdbc") || url.getProtocol().toLowerCase().equals("jdbc.mysql");
    }

    public static URL toURL(String username, String password, String host, String database) throws MalformedURLException {
        return MySQLServiceExtension.toURL(username, password, host, 3306, database);
    }

    public static URL toURL(String username, String password, String host, Integer port, String database) throws MalformedURLException {
        return MySQLServiceExtension.toURL(username, password, host, port.toString(), database);
    }

    public static URL toURL(String username, String password, String host, String port, String database) throws MalformedURLException {
        String the_spec = "mysql.jdbc://" + username + ":" + password + "@" + host + ":" + port + "/" + database;
        return MySQLServiceExtension.toURL(the_spec);
    }

    public static URL toURL(String the_spec) throws MalformedURLException {
        return new URL(null, the_spec, CorePlugin.RELAXED_HANDLER);
    }

    public String reasonForFailure(URL url) {
        if (!MySQLServiceExtension.isMySQL(url)) {
            return Messages.MySQLServiceExtension_badURL;
        }
        return this.reasonForFailure(this.createParams(url));
    }

    protected DataStoreFactorySpi getDataStoreFactory() {
        return MySQLServiceExtension.getFactory();
    }
}

