/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog;

import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.sql.Connection;
import net.refractions.udig.catalog.CatalogPlugin;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.catalog.IGeoResourceInfo;
import net.refractions.udig.catalog.IResolve;
import net.refractions.udig.catalog.IService;
import net.refractions.udig.catalog.MySQLServiceImpl;
import net.refractions.udig.catalog.internal.mysql.MySQLPlugin;
import net.refractions.udig.catalog.mysql.internal.Messages;
import net.refractions.udig.core.internal.CorePlugin;
import net.refractions.udig.ui.graphics.Glyph;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.geotools.data.DataSourceException;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.data.simple.SimpleFeatureStore;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.feature.FeatureIterator;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class MySQLGeoResource
extends IGeoResource {
    MySQLServiceImpl parent;
    String typename = null;
    private volatile IResolve.Status status;
    private volatile Throwable message;
    private URL identifier;

    public MySQLGeoResource(MySQLServiceImpl parent, String typename) {
        this.service = parent;
        this.parent = parent;
        this.typename = typename;
        try {
            this.identifier = new URL(null, String.valueOf(parent.getIdentifier().toString()) + "#" + typename, CorePlugin.RELAXED_HANDLER);
        }
        catch (MalformedURLException malformedURLException) {
            this.identifier = parent.getIdentifier();
        }
    }

    public URL getIdentifier() {
        return this.identifier;
    }

    public IResolve.Status getStatus() {
        if (this.status != null) {
            return this.status;
        }
        return this.parent.getStatus();
    }

    public Throwable getMessage() {
        if (this.message != null) {
            return this.message;
        }
        return this.parent.getMessage();
    }

    public <T> T resolve(Class<T> adaptee, IProgressMonitor monitor) throws IOException {
        if (adaptee == null) {
            return null;
        }
        if (adaptee.isAssignableFrom(IGeoResourceInfo.class)) {
            return adaptee.cast((Object)this.createInfo(monitor));
        }
        if (adaptee.isAssignableFrom(IGeoResource.class)) {
            return adaptee.cast((Object)this);
        }
        if (adaptee.isAssignableFrom(SimpleFeatureStore.class)) {
            ContentFeatureSource fs = this.parent.getDS().getFeatureSource(this.typename);
            if (fs instanceof SimpleFeatureStore) {
                return adaptee.cast(fs);
            }
            if (adaptee.isAssignableFrom(SimpleFeatureSource.class)) {
                return adaptee.cast(this.parent.getDS().getFeatureSource(this.typename));
            }
        }
        if (adaptee.isAssignableFrom(Connection.class)) {
            return this.parent.resolve(adaptee, monitor);
        }
        return (T)super.resolve(adaptee, monitor);
    }

    public <T> boolean canResolve(Class<T> adaptee) {
        if (adaptee == null) {
            return false;
        }
        return adaptee.isAssignableFrom(IGeoResourceInfo.class) || adaptee.isAssignableFrom(SimpleFeatureStore.class) || adaptee.isAssignableFrom(SimpleFeatureSource.class) || adaptee.isAssignableFrom(IService.class) || adaptee.isAssignableFrom(Connection.class) || super.canResolve(adaptee);
    }

    public MySQLResourceInfo getInfo(IProgressMonitor monitor) throws IOException {
        return (MySQLResourceInfo)super.getInfo(monitor);
    }

    protected MySQLResourceInfo createInfo(IProgressMonitor monitor) throws IOException {
        if (this.getStatus() == IResolve.Status.BROKEN) {
            return null;
        }
        this.parent.rLock.lock();
        try {
            MySQLResourceInfo mySQLResourceInfo = new MySQLResourceInfo();
            return mySQLResourceInfo;
        }
        finally {
            this.parent.rLock.unlock();
        }
    }

    class MySQLResourceInfo
    extends IGeoResourceInfo {
        private SimpleFeatureType ft = null;

        MySQLResourceInfo() throws IOException {
            try {
                this.ft = MySQLGeoResource.this.parent.getDS().getSchema(MySQLGeoResource.this.typename);
            }
            catch (DataSourceException e) {
                if (e.getMessage().contains("permission")) {
                    MySQLGeoResource.this.status = IResolve.Status.RESTRICTED_ACCESS;
                } else {
                    MySQLGeoResource.this.status = IResolve.Status.BROKEN;
                }
                MySQLGeoResource.this.message = e;
                MySQLPlugin.log("Unable to retrieve FeatureType schema for type '" + MySQLGeoResource.this.typename + "'.", e);
                this.keywords = new String[]{"mysql", MySQLGeoResource.this.typename};
                return;
            }
            this.keywords = new String[]{"mysql", MySQLGeoResource.this.typename, this.ft.getName().getNamespaceURI()};
            this.icon = Glyph.icon((SimpleFeatureType)this.ft);
        }

        public synchronized ReferencedEnvelope getBounds() {
            block10: {
                if (this.bounds == null) {
                    try {
                        ContentFeatureSource source = MySQLGeoResource.this.parent.getDS().getFeatureSource(MySQLGeoResource.this.typename);
                        this.bounds = source.getBounds();
                        CoordinateReferenceSystem crs = this.getCRS();
                        if (this.bounds != null) break block10;
                        org.opengis.geometry.Envelope envelope = CRS.getEnvelope((CoordinateReferenceSystem)crs);
                        if (envelope != null) {
                            this.bounds = new ReferencedEnvelope(envelope.getLowerCorner().getOrdinate(0), envelope.getUpperCorner().getOrdinate(0), envelope.getLowerCorner().getOrdinate(1), envelope.getUpperCorner().getOrdinate(1), crs);
                            break block10;
                        }
                        this.bounds = new ReferencedEnvelope(new Envelope(), crs);
                        FeatureIterator iter = source.getFeatures().features();
                        try {
                            while (iter.hasNext()) {
                                SimpleFeature element = (SimpleFeature)iter.next();
                                if (this.bounds.isNull()) {
                                    this.bounds.init(element.getBounds());
                                    continue;
                                }
                                this.bounds.include(element.getBounds());
                            }
                        }
                        finally {
                            iter.close();
                        }
                    }
                    catch (DataSourceException e) {
                        MySQLPlugin.log("Exception while generating MySQLGeoResource.", e);
                    }
                    catch (Exception e) {
                        CatalogPlugin.getDefault().getLog().log((IStatus)new Status(2, "net.refractions.udig.catalog", 0, Messages.MySQLGeoResource_error_layer_bounds, (Throwable)e));
                        this.bounds = new ReferencedEnvelope(new Envelope(), null);
                    }
                }
            }
            return super.getBounds();
        }

        public CoordinateReferenceSystem getCRS() {
            if (MySQLGeoResource.this.status == IResolve.Status.BROKEN || MySQLGeoResource.this.status == IResolve.Status.RESTRICTED_ACCESS) {
                return DefaultGeographicCRS.WGS84;
            }
            return this.ft.getCoordinateReferenceSystem();
        }

        public String getName() {
            return MySQLGeoResource.this.typename;
        }

        public URI getSchema() {
            if (MySQLGeoResource.this.status == IResolve.Status.BROKEN || MySQLGeoResource.this.status == IResolve.Status.RESTRICTED_ACCESS) {
                return null;
            }
            try {
                return new URI(this.ft.getName().getNamespaceURI());
            }
            catch (URISyntaxException uRISyntaxException) {
                return null;
            }
        }

        public String getTitle() {
            return MySQLGeoResource.this.typename;
        }
    }
}

