/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.plugins.netcdf;

import it.geosolutions.imageio.ndplugin.BaseImageReaderSpi;
import it.geosolutions.imageio.plugins.netcdf.NetCDFImageReader;
import it.geosolutions.imageio.stream.input.FileImageInputStreamExtImpl;
import it.geosolutions.imageio.stream.input.URIImageInputStream;
import java.io.File;
import java.io.IOException;
import java.util.EnumSet;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageReader;
import javax.imageio.spi.ImageReaderSpi;
import ucar.nc2.NetcdfFile;
import ucar.nc2.dataset.NetcdfDataset;

public class NetCDFImageReaderSpi
extends BaseImageReaderSpi {
    private static final Logger LOGGER;
    static final String[] suffixes;
    static final String[] formatNames;
    static final String[] MIMETypes;
    static final String version = "1.0";
    static final String readerCN = "it.geosolutions.imageio.plugins.netcdf.NetCDFImageReader";
    static final String[] wSN;
    static final boolean supportsStandardStreamMetadataFormat = false;
    static final String nativeStreamMetadataFormatName;
    static final String nativeStreamMetadataFormatClassName;
    static final String[] extraStreamMetadataFormatNames;
    static final String[] extraStreamMetadataFormatClassNames;
    static final boolean supportsStandardImageMetadataFormat = false;
    static final String nativeImageMetadataFormatName;
    static final String nativeImageMetadataFormatClassName;
    static final String[] extraImageMetadataFormatNames;
    static final String[] extraImageMetadataFormatClassNames;

    public NetCDFImageReaderSpi() {
        super("GeoSolutions", version, formatNames, suffixes, MIMETypes, readerCN, DIRECT_STANDARD_INPUT_TYPES, wSN, false, nativeStreamMetadataFormatName, nativeStreamMetadataFormatClassName, extraStreamMetadataFormatNames, extraStreamMetadataFormatClassNames, false, nativeImageMetadataFormatName, nativeImageMetadataFormatClassName, extraImageMetadataFormatNames, extraImageMetadataFormatClassNames);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("NetCDFImageReaderSpi Constructor");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canDecodeInput(Object source) throws IOException {
        boolean canDecode = false;
        File input = null;
        if (source instanceof FileImageInputStreamExtImpl) {
            input = ((FileImageInputStreamExtImpl)source).getFile();
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Found a valid FileImageInputStream");
            }
        }
        if (source instanceof File) {
            input = (File)source;
        }
        if (source instanceof URIImageInputStream) {
            URIImageInputStream uriInStream = (URIImageInputStream)source;
            try {
                NetcdfDataset openDataset = NetcdfDataset.openDataset((String)uriInStream.getUri().toString());
                openDataset.close();
                return true;
            }
            catch (IOException e) {
                return false;
            }
        }
        if (input != null) {
            NetcdfFile file = null;
            try {
                file = NetcdfFile.open((String)input.getPath());
                if (file != null) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("File successfully opened");
                    }
                    canDecode = true;
                }
            }
            catch (IOException ioe) {
                canDecode = false;
            }
            finally {
                if (file != null) {
                    file.close();
                }
            }
        }
        return canDecode;
    }

    public ImageReader createReaderInstance(Object extension) throws IOException {
        return new NetCDFImageReader((ImageReaderSpi)((Object)this));
    }

    public String getDescription(Locale locale) {
        return new StringBuffer("NetCDF-CF Image Reader, version ").append(version).toString();
    }

    static {
        NetcdfDataset.setDefaultEnhanceMode(EnumSet.of(NetcdfDataset.Enhance.CoordSystems));
        LOGGER = Logger.getLogger("it.geosolutions.imageio.plugins.netcdf");
        suffixes = new String[]{"nc", "NC"};
        formatNames = new String[]{"netcdf", "NetCDF"};
        MIMETypes = new String[]{"image/x-netcdf", "image/x-nc"};
        wSN = new String[]{null};
        nativeStreamMetadataFormatName = null;
        nativeStreamMetadataFormatClassName = null;
        extraStreamMetadataFormatNames = new String[]{null};
        extraStreamMetadataFormatClassNames = new String[]{null};
        nativeImageMetadataFormatName = null;
        nativeImageMetadataFormatClassName = null;
        extraImageMetadataFormatNames = new String[]{null};
        extraImageMetadataFormatClassNames = new String[]{null};
    }
}

