/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.render;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import net.refractions.udig.project.internal.render.Renderer;
import net.refractions.udig.project.internal.render.impl.RenderExecutorComposite;
import net.refractions.udig.project.render.TileStateChangedListener;
import net.refractions.udig.ui.graphics.AWTSWTImageUtils;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.swt.graphics.Image;
import org.geotools.geometry.jts.ReferencedEnvelope;

public class Tile {
    private ReferencedEnvelope env;
    private RenderExecutorComposite renderExecutorComp;
    private Image swtImage;
    private int tileSize;
    private RenderState renderState = RenderState.NEW;
    private ContextState contextState = ContextState.INVALID;
    private ScreenState screenState = ScreenState.OFFSCREEN;
    private ValidatedState tileState = ValidatedState.VALIDATED;
    private TileStateChangedListener listener = null;
    private Object SWTLock = new Object();

    public Tile(ReferencedEnvelope env, RenderExecutorComposite rec, int tileSize) {
        this.env = env;
        this.renderExecutorComp = rec;
        this.tileSize = tileSize;
        rec.eAdapters().add((Object)new AdapterImpl(){

            public void notifyChanged(Notification msg) {
                if (msg.getFeatureID(Renderer.class) == 0 && (Tile.this.swtImage == null || msg.getNewIntValue() == 4)) {
                    Tile.this.disposeSWTImage();
                }
            }
        });
    }

    public void setStateChangedListener(TileStateChangedListener listener) {
        this.listener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disposeSWTImage() {
        Object object = this.SWTLock;
        synchronized (object) {
            if (this.swtImage != null) {
                this.swtImage.dispose();
                this.swtImage = null;
            }
        }
        this.setScreenState(ScreenState.OFFSCREEN);
    }

    public void dispose() {
        this.disposeSWTImage();
        this.setScreenState(ScreenState.OFFSCREEN);
    }

    public Image getSWTImage() {
        if (this.swtImage == null || this.swtImage.isDisposed()) {
            this.createSWTImage();
        }
        return this.swtImage;
    }

    public BufferedImage getBufferedImage() {
        BufferedImage buffImage = null;
        try {
            if (this.renderExecutorComp == null) {
                buffImage = new BufferedImage(this.getTileSize(), this.getTileSize(), 2);
                Graphics2D graphics = buffImage.createGraphics();
                graphics.setColor(Color.WHITE);
                graphics.fillRect(0, 0, this.getTileSize(), this.getTileSize());
                graphics.setColor(Color.RED);
                graphics.drawLine(0, 0, this.getTileSize(), this.getTileSize());
                graphics.drawLine(0, this.getTileSize(), this.getTileSize(), 0);
                graphics.drawString("No Render Executor For Tile", this.getTileSize() / 2, this.getTileSize() / 2);
                graphics.dispose();
            } else {
                buffImage = this.renderExecutorComp.getContext().getImage();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return buffImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createSWTImage() {
        Object object = this.SWTLock;
        synchronized (object) {
            if (this.swtImage != null && !this.swtImage.isDisposed()) {
                return;
            }
            try {
                BufferedImage buffImage = this.getBufferedImage();
                this.swtImage = AWTSWTImageUtils.createSWTImage((RenderedImage)buffImage, (boolean)false);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public int getTileSize() {
        return this.tileSize;
    }

    public ReferencedEnvelope getReferencedEnvelope() {
        return this.env;
    }

    public RenderExecutorComposite getRenderExecutor() {
        return this.renderExecutorComp;
    }

    public void setRenderState(RenderState newState) {
        this.renderState = newState;
        if (this.listener != null) {
            this.listener.renderStateChanged(this);
        }
    }

    public RenderState getRenderState() {
        return this.renderState;
    }

    public ContextState getContextState() {
        return this.contextState;
    }

    public void setContextState(ContextState newState) {
        this.contextState = newState;
        if (this.listener != null) {
            this.listener.contextStateChanged(this);
        }
    }

    public ScreenState getScreenState() {
        return this.screenState;
    }

    public void setScreenState(ScreenState newState) {
        this.screenState = newState;
        if (this.listener != null) {
            this.listener.screenStateChanged(this);
        }
    }

    public ValidatedState getTileState() {
        return this.tileState;
    }

    public void setTileState(ValidatedState newState) {
        this.tileState = newState;
        if (this.listener != null) {
            this.listener.validationStateChanged(this);
        }
    }

    public static enum ContextState {
        OKAY,
        INVALID;

    }

    public static enum RenderState {
        NEW,
        RENDERED,
        INVALID;

    }

    public static enum ScreenState {
        ONSCREEN,
        OFFSCREEN;

    }

    public static enum ValidatedState {
        VALIDATED,
        OLD;

    }
}

