/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.internal.render.impl;

import java.awt.Dimension;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SequencedCollection;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.core.internal.ExtensionPointProcessor;
import net.refractions.udig.core.internal.ExtensionPointUtil;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.internal.ContextModel;
import net.refractions.udig.project.internal.Layer;
import net.refractions.udig.project.internal.ProjectPlugin;
import net.refractions.udig.project.internal.render.CompositeRenderContext;
import net.refractions.udig.project.internal.render.RenderContext;
import net.refractions.udig.project.internal.render.RenderManager;
import net.refractions.udig.project.internal.render.Renderer;
import net.refractions.udig.project.internal.render.RendererCreator;
import net.refractions.udig.project.internal.render.SelectionLayer;
import net.refractions.udig.project.internal.render.impl.AbstractRenderMetricsSorter;
import net.refractions.udig.project.internal.render.impl.CompositeRenderContextImpl;
import net.refractions.udig.project.internal.render.impl.InternalRenderMetricsFactory;
import net.refractions.udig.project.internal.render.impl.RenderContextImpl;
import net.refractions.udig.project.internal.render.impl.RenderMetricsFactoryExtensionPointProcessor;
import net.refractions.udig.project.render.AbstractRenderMetrics;
import net.refractions.udig.project.render.IMultiLayerRenderer;
import net.refractions.udig.project.render.IRenderContext;
import net.refractions.udig.project.render.IRenderMetricsFactory;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.notify.Notification;
import org.geotools.data.FeatureSource;
import org.geotools.geometry.jts.ReferencedEnvelope;

public class TiledRendererCreatorImpl
implements RendererCreator {
    protected final SortedSet<Layer> layers = Collections.synchronizedSortedSet(new TreeSet());
    Map<Layer, List<AbstractRenderMetrics>> layerToRenderMetrics = new HashMap<Layer, List<AbstractRenderMetrics>>();
    private Collection<IRenderMetricsFactory> renderMetricsFactories = null;
    private int tilesize;
    private RenderManager manager;

    public TiledRendererCreatorImpl(int tilesize, RenderManager manager) {
        this.manager = manager;
        this.tilesize = tilesize;
    }

    @Override
    public void changed(Notification msg) {
        if ((msg.getNotifier() instanceof ContextModel || msg.getNotifier() instanceof RenderManager) && msg.getFeatureID(ContextModel.class) == 0) {
            this.handleMapCompositionEvent(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleMapCompositionEvent(Notification event) {
        switch (event.getEventType()) {
            case 3: {
                Layer layer = (Layer)event.getNewValue();
                ArrayList<Layer> layers = new ArrayList<Layer>();
                layers.add(layer);
                if (layer.hasResource(FeatureSource.class)) {
                    layers.add(new SelectionLayer(layer));
                }
                SortedSet<Layer> sortedSet = this.layers;
                synchronized (sortedSet) {
                    this.layers.addAll(layers);
                    break;
                }
            }
            case 5: {
                Object layer2;
                ArrayList<Object> layers = new ArrayList<Object>();
                for (Object layer2 : (Collection)event.getNewValue()) {
                    layers.add(layer2);
                    if (!layer2.hasResource(FeatureSource.class) || this.findSelectionLayer((ILayer)layer2) != null) continue;
                    layers.add(new SelectionLayer((Layer)layer2));
                }
                layer2 = this.layers;
                synchronized (layer2) {
                    this.layers.addAll(layers);
                    break;
                }
            }
            case 4: {
                SortedSet<Layer> layers = this.layers;
                synchronized (layers) {
                    Layer removedLayer = (Layer)event.getOldValue();
                    Iterator iter = this.layers.iterator();
                    while (iter.hasNext()) {
                        SelectionLayer sl;
                        Layer l = (Layer)iter.next();
                        if (removedLayer == l) {
                            iter.remove();
                            continue;
                        }
                        if (!(l instanceof SelectionLayer) || removedLayer != (sl = (SelectionLayer)l).getWrappedLayer()) continue;
                        iter.remove();
                    }
                    break;
                }
            }
            case 6: {
                SortedSet<Layer> layers = this.layers;
                synchronized (layers) {
                    Collection removedLayers = (Collection)event.getOldValue();
                    Iterator iter = this.layers.iterator();
                    while (iter.hasNext()) {
                        SelectionLayer sl;
                        Layer l = (Layer)iter.next();
                        if (removedLayers.contains(l)) {
                            iter.remove();
                            continue;
                        }
                        if (!(l instanceof SelectionLayer) || !removedLayers.contains((sl = (SelectionLayer)l).getWrappedLayer())) continue;
                        iter.remove();
                    }
                    break;
                }
            }
            case 7: {
                Layer newV = (Layer)event.getNewValue();
                SortedSet<Layer> removedLayers = this.layers;
                synchronized (removedLayers) {
                    SelectionLayer selectionLayer = null;
                    Iterator iter = this.layers.iterator();
                    while (iter.hasNext()) {
                        SelectionLayer sl;
                        Layer l = (Layer)iter.next();
                        if (newV == l) {
                            iter.remove();
                            continue;
                        }
                        if (!(l instanceof SelectionLayer) || newV != (sl = (SelectionLayer)l).getWrappedLayer()) continue;
                        iter.remove();
                        selectionLayer = sl;
                    }
                    this.layers.add(newV);
                    if (selectionLayer != null) {
                        this.layers.add(selectionLayer);
                    }
                    break;
                }
            }
            case 1: {
                Layer oldV = (Layer)event.getOldValue();
                Layer newV = (Layer)event.getNewValue();
                SelectionLayer selectionLayer = null;
                if (newV.hasResource(FeatureSource.class)) {
                    selectionLayer = new SelectionLayer(newV);
                }
                SortedSet<Layer> sortedSet = this.layers;
                synchronized (sortedSet) {
                    Iterator iter = this.layers.iterator();
                    while (iter.hasNext()) {
                        SelectionLayer sl;
                        Layer l = (Layer)iter.next();
                        if (oldV == l) {
                            iter.remove();
                            continue;
                        }
                        if (!(l instanceof SelectionLayer) || oldV != (sl = (SelectionLayer)l).getWrappedLayer()) continue;
                        iter.remove();
                    }
                    this.layers.add(newV);
                    if (selectionLayer != null) {
                        this.layers.add(selectionLayer);
                    }
                    break;
                }
            }
        }
    }

    @Override
    public SelectionLayer findSelectionLayer(ILayer targetLayer) {
        try {
            if (targetLayer.getResource(FeatureSource.class, null) == null) {
                return null;
            }
        }
        catch (IOException iOException) {
            return null;
        }
        for (Layer layer : this.getLayers()) {
            if (!(layer instanceof SelectionLayer) || ((SelectionLayer)layer).getWrappedLayer() != targetLayer) continue;
            return (SelectionLayer)layer;
        }
        return null;
    }

    @Override
    public Collection<AbstractRenderMetrics> getAvailableRendererMetrics(Layer layer) {
        Collection metrics = this.layerToRenderMetrics.get(layer);
        if (metrics == null) {
            this.initRenderMetricsPerLayer(layer);
            metrics = this.layerToRenderMetrics.get(layer);
        }
        return metrics;
    }

    @Override
    public Map<String, String> getAvailableRenderersInfo(Layer layer) {
        throw new UnsupportedOperationException("Renderers don't have information in this system.");
    }

    @Override
    public Collection<RenderContext> getConfiguration() {
        throw new UnsupportedOperationException("A single configuration doesn't exist in a tiled system.  Use getConfiguration(RenderenceEnvelope) instead.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<AbstractRenderMetrics> getConfiguration(ReferencedEnvelope bounds) {
        ArrayList<AbstractRenderMetrics> metrics = null;
        Map<Layer, AbstractRenderMetrics> metricsmap = this.createConfiguration(bounds);
        metrics = new ArrayList<AbstractRenderMetrics>();
        Map<Layer, AbstractRenderMetrics> map = metricsmap;
        synchronized (map) {
            for (Map.Entry<Layer, AbstractRenderMetrics> entry : metricsmap.entrySet()) {
                if (entry.getValue() == null || metrics.contains(entry.getValue())) continue;
                metrics.add(entry.getValue());
            }
        }
        return metrics;
    }

    @Override
    public RenderContext getContext() {
        throw new UnsupportedOperationException("Tiled system doesn't have a context.");
    }

    @Override
    public SortedSet<Layer> getLayers() {
        return this.layers;
    }

    @Override
    public RenderContext getRenderContext(Layer layer) {
        throw new UnsupportedOperationException("A layer doesn't have a single render context in the Tiled system.");
    }

    @Override
    public Renderer getRenderer(RenderContext context) {
        throw new UnsupportedOperationException("Cannot get renderer for tiled system.");
    }

    @Override
    public void reset() {
        if (this.renderMetricsFactories != null) {
            this.renderMetricsFactories.clear();
            this.layerToRenderMetrics.clear();
        }
        this.initRenderMetricFactories();
    }

    @Override
    public void setContext(RenderContext value) {
        throw new UnsupportedOperationException("Tiled system doesn't have a context.");
    }

    private void initRenderMetricFactories() {
        RenderMetricsFactoryExtensionPointProcessor p = new RenderMetricsFactoryExtensionPointProcessor();
        ExtensionPointUtil.process((Plugin)ProjectPlugin.getPlugin(), (String)"net.refractions.udig.project.renderer", (ExtensionPointProcessor)p);
        this.renderMetricsFactories = p.getRFactories();
    }

    private void initRenderMetricsPerLayer(Layer layer) {
        SequencedCollection<Layer> layers = this.layers;
        if (layer == null) {
            this.layerToRenderMetrics = new HashMap<Layer, List<AbstractRenderMetrics>>();
        } else {
            layers = new ArrayList();
            layers.add(layer);
        }
        if (this.renderMetricsFactories == null) {
            this.initRenderMetricFactories();
        }
        for (Layer l : layers) {
            List<AbstractRenderMetrics> m = this.createRenderMetrics(this.renderMetricsFactories, l, this.manager.getViewportModelInternal().getBounds());
            this.layerToRenderMetrics.put(l, m);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Layer, AbstractRenderMetrics> createConfiguration(ReferencedEnvelope bounds) {
        if (this.renderMetricsFactories == null) {
            this.initRenderMetricFactories();
        }
        Collection<IRenderMetricsFactory> factories = this.renderMetricsFactories;
        Map<Layer, AbstractRenderMetrics> configuration = new HashMap<Layer, AbstractRenderMetrics>();
        boolean configurationPassed = false;
        while (!configurationPassed) {
            ArrayList<Layer> layers = new ArrayList<Layer>();
            SortedSet<Layer> sortedSet = this.layers;
            synchronized (sortedSet) {
                layers.addAll(this.layers);
            }
            int i = 0;
            while (i < layers.size()) {
                Layer layer = (Layer)layers.get(i);
                if (configuration.get(layer) == null) {
                    List<AbstractRenderMetrics> availableMetrics = this.createRenderMetrics(factories, layer, bounds);
                    Collections.sort(availableMetrics, new AbstractRenderMetricsSorter(layers));
                    if (availableMetrics.isEmpty()) {
                        configuration.put(layer, null);
                    } else {
                        AbstractRenderMetrics metrics = availableMetrics.get(0);
                        if (metrics != null) {
                            RenderContext renderContext = (RenderContext)metrics.getRenderContext();
                            if (renderContext instanceof CompositeRenderContextImpl) {
                                this.constructCompositeContext(layers, configuration, i, metrics, (CompositeRenderContext)renderContext, bounds, factories);
                            }
                            configuration.put(layer, metrics);
                        }
                    }
                }
                ++i;
            }
            sortedSet = this.layers;
            synchronized (sortedSet) {
                Iterator iter1 = layers.iterator();
                Iterator iter2 = this.layers.iterator();
                boolean failed = false;
                while (iter1.hasNext()) {
                    if (!iter2.hasNext()) {
                        failed = true;
                        break;
                    }
                    if (((Layer)iter1.next()).equals(iter2.next())) continue;
                    failed = true;
                    break;
                }
                if (!failed) {
                    configuration = Collections.synchronizedMap(configuration);
                    configurationPassed = true;
                }
            }
        }
        return configuration;
    }

    private List<AbstractRenderMetrics> createRenderMetrics(Collection<IRenderMetricsFactory> factories, Layer layer, ReferencedEnvelope bounds) {
        ArrayList<AbstractRenderMetrics> metrics = new ArrayList<AbstractRenderMetrics>();
        for (IRenderMetricsFactory renderMetricsFactory : factories) {
            List<IGeoResource> data = layer.getGeoResources();
            for (IGeoResource resource : data) {
                RenderContextImpl context;
                try {
                    context = IMultiLayerRenderer.class.isAssignableFrom(renderMetricsFactory.getRendererType()) ? new CompositeRenderContextImpl() : new RenderContextImpl(layer instanceof SelectionLayer);
                }
                catch (Throwable throwable) {
                    context = new RenderContextImpl(layer instanceof SelectionLayer);
                }
                context.setMapInternal(this.manager.getMapInternal());
                context.setRenderManagerInternal(this.manager);
                context.setLayerInternal(layer);
                context.setGeoResourceInternal(resource);
                context.setImageSize(new Dimension(this.tilesize, this.tilesize));
                context.setImageBounds(bounds);
                try {
                    if (!renderMetricsFactory.canRender(context)) continue;
                    AbstractRenderMetrics metric = ((InternalRenderMetricsFactory.InternalRenderMetrics)renderMetricsFactory.createMetrics((IRenderContext)context)).delegate;
                    metric.setId(((RenderMetricsFactoryExtensionPointProcessor.IdRenderMetricsFactory)renderMetricsFactory).getId());
                    metrics.add(metric);
                }
                catch (IOException e) {
                    ProjectPlugin.log("Cannot determine if context is renderable.", e);
                }
            }
        }
        return metrics;
    }

    private void constructCompositeContext(List<Layer> layers, Map<Layer, AbstractRenderMetrics> configuration, int startindex, AbstractRenderMetrics parentMetrics, CompositeRenderContext parentRenderContext, ReferencedEnvelope bounds, Collection<IRenderMetricsFactory> factories) {
        int j = startindex;
        while (j < layers.size()) {
            try {
                Layer layer = layers.get(j);
                if (!parentMetrics.canAddLayer(layer) || configuration.get(layer) != null) break;
                this.addChildContextToComposite(configuration, parentRenderContext, layer, parentMetrics);
            }
            catch (Exception exception) {
                break;
            }
            ++j;
        }
    }

    private void addChildContextToComposite(Map<Layer, AbstractRenderMetrics> configuration, CompositeRenderContext parentRenderContext, Layer layer, AbstractRenderMetrics parentMetrics) {
        RenderContextImpl childcontext = new RenderContextImpl(layer instanceof SelectionLayer);
        childcontext.setMapInternal(parentRenderContext.getMapInternal());
        childcontext.setRenderManagerInternal(parentRenderContext.getRenderManagerInternal());
        childcontext.setLayerInternal(layer);
        childcontext.setGeoResourceInternal(layer.getGeoResource());
        childcontext.setImageSize(parentRenderContext.getImageSize());
        childcontext.setImageBounds(parentRenderContext.getImageBounds());
        AbstractRenderMetrics childmetric = parentMetrics.getRenderMetricsFactory().createMetrics(childcontext);
        Set<RenderContext> child = Collections.singleton((RenderContext)childmetric.getRenderContext());
        parentRenderContext.addContexts(child);
        configuration.put(layer, parentMetrics);
    }
}

