/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.internal.render.impl;

import java.awt.Color;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import net.refractions.udig.project.internal.Layer;
import net.refractions.udig.project.internal.Messages;
import net.refractions.udig.project.internal.ProjectPlugin;
import org.geotools.data.ows.StyleImpl;
import org.geotools.data.wms.WebMapServer;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.RasterSymbolizer;
import org.geotools.styling.Style;
import org.geotools.styling.StyleBuilder;
import org.geotools.styling.Symbolizer;

public class Styling {
    public static final Map STYLES;

    static {
        HashMap<String, Integer> styles = new HashMap<String, Integer>();
        styles.put(Messages.Styling_blueLine, 0);
        styles.put(Messages.Styling_greenLine, 1);
        styles.put(Messages.Styling_blackLine, 2);
        styles.put(Messages.Styling_blackLine_blueFill, 3);
        styles.put(Messages.Styling_blackLine_greenFill, 4);
        styles.put(Messages.Styling_blackLine_semitransparentBlueFill, 5);
        styles.put(Messages.Styling_blackLine_semitransparentYellowFill, 6);
        styles.put(Messages.Styling_pointStyle, 7);
        STYLES = Collections.unmodifiableMap(styles);
    }

    public static Style getStyle(String styleName, String typeName) {
        return Styling.getStyle((Integer)STYLES.get(styleName), typeName);
    }

    public static Style getStyle(int index, String typeName) {
        switch (index) {
            case 0: {
                return Styling.createLineStyle(typeName, Color.BLUE);
            }
            case 1: {
                return Styling.createLineStyle(typeName, Color.GREEN);
            }
            case 2: {
                return Styling.createLineStyle(typeName, Color.BLACK);
            }
            case 3: {
                return Styling.createPolyStyle(typeName, Color.BLACK, Color.BLUE);
            }
            case 4: {
                return Styling.createPolyStyle(typeName, Color.BLACK, Color.GREEN);
            }
            case 5: {
                return Styling.createPolyStyle(typeName, Color.BLACK, new Color(0, 0, 255, 127));
            }
            case 6: {
                return Styling.createPolyStyle(typeName, Color.BLACK, new Color(127, 127, 127, 127));
            }
            case 7: {
                return Styling.createPointStyle(typeName);
            }
        }
        return Styling.createLineStyle(typeName, Color.BLUE);
    }

    public static Style createLineStyle(String typeName) {
        return Styling.createLineStyle(typeName, Color.blue);
    }

    public static Style createLineStyle(String typeName, Color color) {
        StyleBuilder sb = new StyleBuilder();
        Style linestyle = sb.createStyle();
        LineSymbolizer line = sb.createLineSymbolizer(color);
        linestyle.addFeatureTypeStyle(sb.createFeatureTypeStyle((Symbolizer)line));
        FeatureTypeStyle fts = linestyle.getFeatureTypeStyles()[0];
        fts.setName(Messages.Styling_name);
        fts.setFeatureTypeName("Feature");
        fts.setSemanticTypeIdentifiers(new String[]{"generic:geometry", "simple"});
        return linestyle;
    }

    public static Style createPolyStyle(String typeName) {
        return Styling.createPolyStyle(typeName, Color.BLACK, Color.GREEN);
    }

    public static Style createPolyStyle(String typeName, Color line, Color fill) {
        StyleBuilder sb = new StyleBuilder();
        Style polystyle = sb.createStyle();
        PolygonSymbolizer poly = sb.createPolygonSymbolizer(fill, line, 1.0);
        polystyle.addFeatureTypeStyle(sb.createFeatureTypeStyle((Symbolizer)poly));
        polystyle.getFeatureTypeStyles()[0].setFeatureTypeName("Feature");
        return polystyle;
    }

    public static Style createPointStyle(String typeName) {
        StyleBuilder sb = new StyleBuilder();
        Style pointstyle = sb.createStyle();
        PointSymbolizer point = sb.createPointSymbolizer(sb.createGraphic());
        pointstyle.addFeatureTypeStyle(sb.createFeatureTypeStyle((Symbolizer)point));
        pointstyle.getFeatureTypeStyles()[0].setFeatureTypeName("Feature");
        return pointstyle;
    }

    public static Style createRasterStyle(String typeName) {
        StyleBuilder sb = new StyleBuilder();
        Style rasterstyle = sb.createStyle();
        RasterSymbolizer raster = sb.createRasterSymbolizer();
        rasterstyle.addFeatureTypeStyle(sb.createFeatureTypeStyle((Symbolizer)raster));
        rasterstyle.getFeatureTypeStyles()[0].setFeatureTypeName("Feature");
        return rasterstyle;
    }

    public static Collection getStyleNames(Layer currentLayer) {
        if (currentLayer.isType(WebMapServer.class)) {
            LinkedList<String> l = new LinkedList<String>();
            try {
                for (StyleImpl style : ((org.geotools.data.ows.Layer)currentLayer.getResource(org.geotools.data.ows.Layer.class, null)).getStyles()) {
                    l.add(style.getName());
                }
            }
            catch (IOException e) {
                ProjectPlugin.log(null, e);
            }
            l.add(Messages.Styling_default);
            return l;
        }
        return STYLES.keySet();
    }
}

