/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.internal.render.impl;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.measure.converter.UnitConverter;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import net.refractions.udig.core.Pair;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.IMap;
import net.refractions.udig.project.internal.Layer;
import net.refractions.udig.project.internal.ProjectPlugin;
import net.refractions.udig.project.internal.render.ViewportModel;
import net.refractions.udig.project.render.IRenderManager;
import net.refractions.udig.project.render.displayAdapter.IMapDisplay;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.GeodeticCalculator;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;

public final class ScaleUtils {
    static final double ACCURACY = 1.0E-8;
    private static final int MAX_ITERATIONS = 10;
    private static Envelope WORLD = new Envelope(-180.0, 180.0, -90.0, 90.0);
    public static final double DEFAULT_PIXEL_SIZE_METER = 2.8E-4;
    public static final double METERS_PER_DEGREE = 111319.49079327358;
    public static final double DEGREES_PER_METER = 3.5464065926847464E-4;
    public static final double FEET_TO_METERS = 0.3048;

    private ScaleUtils() {
    }

    public static double calculateResolutionFromScale(ReferencedEnvelope bounds, double scale, int tileWidth) {
        if (ScaleUtils.isLatLong(bounds.getCoordinateReferenceSystem())) {
            return 9.929938459517289E-8 * (scale * (double)tileWidth * 3.5464065926847464E-4);
        }
        return 2.8E-4 * scale;
    }

    public static Unit<?> getUnit(CoordinateReferenceSystem crs) {
        return crs.getCoordinateSystem().getAxis(0).getUnit();
    }

    public static double fromMeterToCrs(double value, CoordinateReferenceSystem crs) {
        Unit<?> unit = ScaleUtils.getUnit(crs);
        UnitConverter converter = SI.METER.getConverterTo(unit);
        return converter.convert(value);
    }

    public static double fromCrsToMeter(double value, CoordinateReferenceSystem crs) {
        Unit<?> unit = ScaleUtils.getUnit(crs);
        UnitConverter converter = unit.getConverterTo(SI.METER);
        return converter.convert(value);
    }

    public static boolean isLatLong(CoordinateReferenceSystem crs) {
        Unit<?> unit = ScaleUtils.getUnit(crs);
        Unit<?> degrees = ScaleUtils.getUnit((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        boolean isLatLong = CRS.equalsIgnoreMetadata(unit, degrees);
        return isLatLong;
    }

    public static ReferencedEnvelope calculateBoundsFromScale(double newScaleDenominator, Dimension displaySize, int dpi, ReferencedEnvelope currentBounds) {
        double MIN_SCALE = 1.0E-100;
        if (newScaleDenominator <= MIN_SCALE || Double.isInfinite(newScaleDenominator) || Double.isNaN(newScaleDenominator)) {
            return currentBounds;
        }
        return ScaleUtils.calculateBoundsFromScaleInternal(newScaleDenominator, displaySize, dpi, currentBounds, 0);
    }

    private static ReferencedEnvelope calculateBoundsFromScaleInternal(double newScaleDenominator, Dimension displaySize, int dpi, ReferencedEnvelope currentBounds, int iterations) {
        double oldScaleDenom = ScaleUtils.calculateScaleDenominator(currentBounds, displaySize, dpi);
        if (oldScaleDenom <= 0.0 || Double.isInfinite(oldScaleDenom) || Double.isNaN(oldScaleDenom)) {
            return currentBounds;
        }
        double ratio = newScaleDenominator / oldScaleDenom;
        double newWidth = currentBounds.getWidth() * ratio;
        ReferencedEnvelope newExtent = ScaleUtils.calculateBounds(newWidth, displaySize, currentBounds);
        double calculatedScale = ScaleUtils.calculateScaleDenominator(newExtent, displaySize, dpi);
        if (Math.abs(calculatedScale - newScaleDenominator) > 1.0E-8 && iterations < 10 && calculatedScale > 0.0) {
            return ScaleUtils.calculateBoundsFromScaleInternal(newScaleDenominator, displaySize, dpi, newExtent, iterations + 1);
        }
        return newExtent;
    }

    private static ReferencedEnvelope calculateBounds(double width, Dimension displaySize, ReferencedEnvelope originalExtent) {
        Coordinate center = originalExtent.centre();
        double height = width * (double)displaySize.height / (double)displaySize.width;
        CoordinateReferenceSystem crs = originalExtent.getCoordinateReferenceSystem();
        double minx = center.x - width / 2.0;
        double maxx = center.x + width / 2.0;
        double miny = center.y - height / 2.0;
        double maxy = center.y + height / 2.0;
        return new ReferencedEnvelope(minx, maxx, miny, maxy, crs);
    }

    private static double distancePerPixel(Dimension displaySize, ReferencedEnvelope currentBounds) {
        ReferencedEnvelope referencePixel = ScaleUtils.toValidPixelBoundsClosestToCenter(displaySize, currentBounds);
        try {
            ReferencedEnvelope referencePixelLatLong = referencePixel.transform((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, true);
            double minX = referencePixelLatLong.getMinX();
            double maxX = referencePixelLatLong.getMaxX();
            double scale = 1.0;
            if (referencePixelLatLong.getWidth() > 360.0) {
                scale = referencePixelLatLong.getWidth() / 18.0;
                minX = 0.0;
                maxX = 180.0;
            }
            GeodeticCalculator calc = new GeodeticCalculator();
            double centerY = ScaleUtils.centeredYWithinWorld(referencePixelLatLong);
            calc.setStartingGeographicPoint(minX, centerY);
            calc.setDestinationGeographicPoint(maxX, centerY);
            return calc.getOrthodromicDistance() * scale;
        }
        catch (FactoryException e) {
            ProjectPlugin.log("error transforming: " + referencePixel + " to latlong", e);
            return -1.0;
        }
        catch (TransformException e) {
            ProjectPlugin.log("error transforming: " + referencePixel + " to latlong", e);
            return -1.0;
        }
        catch (AssertionError e) {
            ProjectPlugin.log("Bad parameters", (Throwable)((Object)e));
            return -1.0;
        }
    }

    private static double centeredYWithinWorld(ReferencedEnvelope extent) {
        Coordinate centre = extent.centre();
        if (WORLD.contains(centre)) {
            return centre.y;
        }
        return 0.0;
    }

    static ReferencedEnvelope toValidPixelBoundsClosestToCenter(Dimension displaySize, ReferencedEnvelope currentBounds) {
        Coordinate centre = currentBounds.centre();
        Point referencePixel = ScaleUtils.nearestPixel(centre.x, centre.y, currentBounds, displaySize);
        ReferencedEnvelope pixelBounds = ScaleUtils.pixelBounds(referencePixel.x, referencePixel.y, currentBounds, displaySize);
        return ScaleUtils.shiftToWorld(pixelBounds);
    }

    static ReferencedEnvelope shiftToWorld(ReferencedEnvelope pixelBounds) {
        DefaultGeographicCRS wgs84 = DefaultGeographicCRS.WGS84;
        try {
            ReferencedEnvelope latLong = pixelBounds.transform((CoordinateReferenceSystem)wgs84, true);
            if (WORLD.contains((Envelope)latLong)) {
                return pixelBounds;
            }
            double deltax = 0.0;
            double deltay = 0.0;
            if (latLong.getWidth() < WORLD.getWidth()) {
                if (latLong.getMinX() < WORLD.getMinX()) {
                    deltax = WORLD.getMinX() - latLong.getMinX();
                }
                if (latLong.getMaxX() > WORLD.getMaxX()) {
                    deltax = WORLD.getMaxX() - latLong.getMaxX();
                }
            }
            if (latLong.getHeight() < WORLD.getHeight()) {
                if (latLong.getMinY() < WORLD.getMinY()) {
                    deltay = WORLD.getMinY() - latLong.getMinY();
                }
                if (latLong.getMaxY() > WORLD.getMaxY()) {
                    deltay = WORLD.getMaxX() - latLong.getMaxY();
                }
            }
            latLong.translate(deltax, deltay);
            return latLong.transform(pixelBounds.getCoordinateReferenceSystem(), true);
        }
        catch (TransformException e) {
            ProjectPlugin.log("", e);
        }
        catch (FactoryException e) {
            ProjectPlugin.log("", e);
        }
        return pixelBounds;
    }

    static Point nearestPixel(double x, double y, ReferencedEnvelope extent, Dimension displaySize) {
        if (WORLD.contains(x, y)) {
            return ScaleUtils.worldToPixel(new Coordinate(x, y), extent, displaySize);
        }
        double newX = x < WORLD.getMinX() ? WORLD.getMinX() : (x > WORLD.getMaxX() ? WORLD.getMaxX() : x);
        double newY = y < WORLD.getMinY() ? WORLD.getMinY() : (y > WORLD.getMaxY() ? WORLD.getMaxY() : y);
        return ScaleUtils.worldToPixel(new Coordinate(newX, newY), extent, displaySize);
    }

    public static ReferencedEnvelope pixelBounds(int x, int y, ReferencedEnvelope currentBounds, Dimension displaySize) {
        double minX = x;
        double maxX = (double)x + 1.0;
        double minY = y;
        double maxY = (double)y + 1.0;
        Coordinate ul = ScaleUtils.pixelToWorld(minX, minY, currentBounds, displaySize);
        Coordinate lr = ScaleUtils.pixelToWorld(maxX, maxY, currentBounds, displaySize);
        if (ul == null || lr == null) {
            return new ReferencedEnvelope(new Envelope(), currentBounds.getCoordinateReferenceSystem());
        }
        return new ReferencedEnvelope(ul.x, lr.x, ul.y, lr.y, currentBounds.getCoordinateReferenceSystem());
    }

    public static double calculateScaleDenominator(ReferencedEnvelope bounds, Dimension displaySize, int dpi) {
        if (bounds.getWidth() == 0.0 || bounds.getHeight() == 0.0) {
            return -1.0;
        }
        CoordinateReferenceSystem crs = bounds.getCoordinateReferenceSystem();
        int width = displaySize.width;
        int height = displaySize.height;
        boolean isLatLong = ScaleUtils.isLatLong(crs);
        if (isLatLong) {
            double distancePerPixel = ScaleUtils.distancePerPixel(displaySize, bounds);
            if (distancePerPixel < 0.0) {
                return -1.0;
            }
            double pixelSize = 1.0 / (double)dpi * 25.4 / 1000.0;
            double scaleDenominator = distancePerPixel / pixelSize;
            return scaleDenominator;
        }
        double refWidthMeters = ScaleUtils.fromCrsToMeter(bounds.getWidth(), crs);
        double displayMeterDistancePixels = refWidthMeters * (double)dpi / 2.54 * 100.0;
        double widthScaleDenominator = displayMeterDistancePixels / (double)width;
        double refHeightMeters = ScaleUtils.fromCrsToMeter(bounds.getHeight(), crs);
        double displayMeterHeightPixels = refHeightMeters * (double)dpi / 2.54 * 100.0;
        double heightScaleDenominator = displayMeterHeightPixels / (double)height;
        return Math.sqrt(heightScaleDenominator * heightScaleDenominator + widthScaleDenominator * widthScaleDenominator);
    }

    public static Envelope centerPixelBounds(IMapDisplay display, ReferencedEnvelope bounds) {
        Coordinate ul = ScaleUtils.pixelToWorld((int)((double)(display.getWidth() / 2) - 0.5), Math.floor((double)display.getHeight() / 2.0 - 0.5), bounds, display.getDisplaySize());
        Coordinate lr = ScaleUtils.pixelToWorld((int)((double)(display.getWidth() / 2) + 0.5), Math.floor((double)display.getHeight() / 2.0 + 0.5), bounds, display.getDisplaySize());
        return new Envelope(ul.x, lr.x, ul.y, lr.y);
    }

    public static boolean withinValidWorld(ReferencedEnvelope bounds) {
        Envelope world = new Envelope(-181.0, 181.0, -91.0, 91.0);
        return world.contains(bounds.centre());
    }

    public static Coordinate pixelToWorld(double x, double y, ReferencedEnvelope extent, Dimension displaySize) {
        AffineTransform at = ScaleUtils.worldToScreenTransform((Envelope)extent, displaySize);
        try {
            Point2D result = at.inverseTransform(new Point2D.Double(x, y), new Point2D.Double());
            Coordinate c = new Coordinate(result.getX(), result.getY());
            return c;
        }
        catch (Exception e) {
            ProjectPlugin.log("Error transforming point:" + x + "," + y + " to a coordinate", e);
            return null;
        }
    }

    public static AffineTransform worldToScreenTransform(Envelope mapExtent, Dimension screenSize) {
        double scaleX = screenSize.getWidth() / mapExtent.getWidth();
        double scaleY = screenSize.getHeight() / mapExtent.getHeight();
        double tx = -mapExtent.getMinX() * scaleX;
        double ty = mapExtent.getMinY() * scaleY + screenSize.getHeight();
        AffineTransform at = new AffineTransform(scaleX, 0.0, 0.0, -scaleY, tx, ty);
        return at;
    }

    public static Point worldToPixel(Coordinate coord, ReferencedEnvelope bounds, Dimension displaySize) {
        Point2D.Double w = new Point2D.Double(coord.x, coord.y);
        AffineTransform at = ScaleUtils.worldToScreenTransform((Envelope)bounds, displaySize);
        Point2D p = at.transform(w, new Point2D.Double());
        return new Point((int)Math.round(p.getX()), (int)Math.round(p.getY()));
    }

    public static ReferencedEnvelope fitToMinAndMax(ReferencedEnvelope bbox, ILayer layer) {
        ReferencedEnvelope bounds = ScaleUtils.restrictMinimum(bbox, layer);
        bounds = ScaleUtils.restrictMaximum(bounds, layer.getMap(), layer);
        return bounds;
    }

    private static ReferencedEnvelope restrictMaximum(ReferencedEnvelope bounds, IMap map, ILayer layer) {
        double maxFromLayer = ((Layer)layer).getMaxScaleDenominator();
        ReferencedEnvelope result = bounds;
        ReferencedEnvelope maxBounds = ScaleUtils.calculateBoundsFromScale(bounds, maxFromLayer, layer);
        if (bounds.contains((Envelope)maxBounds)) {
            result = maxBounds;
        }
        return result;
    }

    private static ReferencedEnvelope restrictMinimum(ReferencedEnvelope bounds, ILayer layer) {
        double minFromLayer = ((Layer)layer).getMinScaleDenominator();
        Integer minimumScale = layer.getMap().getBlackboard().getInteger("net.refractions.udig.project.MINIMUM_ZOOM_SCALE");
        if (minimumScale == null) {
            minimumScale = ProjectPlugin.getPlugin().getPluginPreferences().getInt("P_MINIMUM_ZOOM_SCALE");
        }
        ReferencedEnvelope result = bounds;
        if (minimumScale != null && minFromLayer < (double)minimumScale.intValue()) {
            ReferencedEnvelope minimumBounds = ScaleUtils.calculateBoundsFromScale(bounds, minimumScale.intValue(), layer);
            if (minimumBounds.contains((Envelope)bounds)) {
                result = minimumBounds;
            }
        } else {
            ReferencedEnvelope minimumBounds = ScaleUtils.calculateBoundsFromScale(bounds, minFromLayer, layer);
            if (minimumBounds.contains((Envelope)bounds)) {
                result = minimumBounds;
            }
        }
        return result;
    }

    private static ReferencedEnvelope calculateBoundsFromScale(ReferencedEnvelope requestedBounds, double scaleDenominator, ILayer layer) {
        IRenderManager renderManager = layer.getMap().getRenderManager();
        if (renderManager == null) {
            return requestedBounds;
        }
        IMapDisplay mapDisplay = renderManager.getMapDisplay();
        return ScaleUtils.calculateBoundsFromScale(scaleDenominator, mapDisplay.getDisplaySize(), mapDisplay.getDPI(), requestedBounds);
    }

    public static AffineTransform createScaleTransformWithFixedPoint(double zoom, Coordinate fixedPoint) {
        AffineTransform t = new AffineTransform();
        t.translate(fixedPoint.x, fixedPoint.y);
        t.scale(1.0 / zoom, 1.0 / zoom);
        t.translate(-fixedPoint.x, -fixedPoint.y);
        return t;
    }

    public static Envelope transformEnvelope(ReferencedEnvelope srcEnvelope, AffineTransform transformer) {
        Point2D.Double lowLeft = new Point2D.Double(srcEnvelope.getMinX(), srcEnvelope.getMinY());
        Point2D transformedLowLeft = new Point2D.Double();
        transformedLowLeft = transformer.transform(lowLeft, transformedLowLeft);
        Point2D.Double upRight = new Point2D.Double(srcEnvelope.getMaxX(), srcEnvelope.getMaxY());
        Point2D transformedUpRight = new Point2D.Double();
        transformedUpRight = transformer.transform(upRight, transformedUpRight);
        return new Envelope(transformedLowLeft.getX(), transformedUpRight.getX(), transformedLowLeft.getY(), transformedUpRight.getY());
    }

    public static double calculateZoomLevel(CalculateZoomLevelParameter params) {
        SortedSet<Double> preferredScaleDenominators = params.model.getPreferredScaleDenominators();
        if (!params.alwayUsePreferredZoomLevels && !preferredScaleDenominators.isEmpty() && preferredScaleDenominators != params.model.getDefaultPreferredScaleDenominators()) {
            Pair<Double, ReferencedEnvelope> previousScale = ScaleUtils.calculateScaleFromZoom(params.previousZoom, params.model.getBounds(), params);
            ZoomCalculation targetZoomInfo = new ZoomCalculation(previousScale, params);
            double varianceFromPrevious = Math.abs(targetZoomInfo.closestMatch - (Double)previousScale.getLeft()) / (Double)previousScale.getLeft();
            double chosen = params.alwaysChangeZoom && varianceFromPrevious < 0.1 ? (params.zoomChange < 1.0 ? (targetZoomInfo.nextGreater == null ? targetZoomInfo.closestMatch : targetZoomInfo.nextGreater) : (targetZoomInfo.nextSmaller == null ? targetZoomInfo.closestMatch : targetZoomInfo.nextSmaller)) : targetZoomInfo.closestMatch;
            return params.model.getScaleDenominator() / chosen;
        }
        return Math.abs(params.previousZoom * params.zoomChange);
    }

    private static Pair<Double, ReferencedEnvelope> calculateScaleFromZoom(double zoom, ReferencedEnvelope baseEnv, CalculateZoomLevelParameter params) {
        AffineTransform transformer = ScaleUtils.createScaleTransformWithFixedPoint(zoom, params.fixedPoint);
        ReferencedEnvelope transformedEnvelope = new ReferencedEnvelope(ScaleUtils.transformEnvelope(baseEnv, transformer), baseEnv.getCoordinateReferenceSystem());
        Double scale = ScaleUtils.calculateScaleDenominator(transformedEnvelope, params.display.getDisplaySize(), params.display.getDPI());
        Double closest = ScaleUtils.calculateClosestScale(params.model.getPreferredScaleDenominators(), scale, params.requiredCloseness);
        if (Math.abs(closest - scale) / scale < 0.01) {
            scale = closest;
        }
        return Pair.create((Object)scale, (Object)transformedEnvelope);
    }

    public static Double calculateClosestScale(SortedSet<Double> scaleDenominators, double scale, double requiredCloseness) {
        SortedSet<Double> tail = scaleDenominators.tailSet(scale);
        SortedSet<Double> head = scaleDenominators.headSet(scale);
        Double distantZoom = ScaleUtils.first(tail, Double.MAX_VALUE);
        Double closeZoom = ScaleUtils.last(head, Double.MIN_VALUE);
        if (Math.abs(distantZoom - Double.MAX_VALUE) < 1.0E-4) {
            return closeZoom;
        }
        if (Math.abs(closeZoom - Double.MIN_VALUE) < 1.0E-4) {
            return distantZoom;
        }
        if (distantZoom - scale < (distantZoom - closeZoom) * requiredCloseness) {
            return distantZoom;
        }
        return closeZoom;
    }

    private static Double first(SortedSet<Double> set, Double defaultVal) {
        if (set.isEmpty()) {
            return defaultVal;
        }
        return set.first();
    }

    private static Double last(SortedSet<Double> set, Double defaultVal) {
        if (set.isEmpty()) {
            return defaultVal;
        }
        return set.last();
    }

    public static double zoomClosenessPreference() {
        return ProjectPlugin.getPlugin().getPreferenceStore().getDouble("P_ZOOM_REQUIRED_CLOSENESS");
    }

    public static class CalculateZoomLevelParameter {
        public final ViewportModel model;
        public final IMapDisplay display;
        public final double previousZoom;
        public final double zoomChange;
        public final double requiredCloseness;
        public final Coordinate fixedPoint;
        public final boolean alwayUsePreferredZoomLevels;
        public final boolean alwaysChangeZoom;

        public CalculateZoomLevelParameter(ViewportModel model, IMapDisplay display, double previousZoom, double zoomChange, Coordinate fixedPoint, boolean alwayUsePreferredZoomLevels, boolean alwaysChangeZoom, double requiredCloseness) {
            this.model = model;
            this.display = display;
            this.previousZoom = previousZoom;
            this.zoomChange = zoomChange;
            this.fixedPoint = fixedPoint;
            this.alwayUsePreferredZoomLevels = alwayUsePreferredZoomLevels;
            this.alwaysChangeZoom = alwaysChangeZoom;
            this.requiredCloseness = requiredCloseness;
        }
    }

    private static class ZoomCalculation {
        Double nextSmaller;
        double closestMatch;
        Double nextGreater;
        double scale;

        public ZoomCalculation(Pair<Double, ReferencedEnvelope> previous, CalculateZoomLevelParameter params) {
            this.scale = (Double)ScaleUtils.calculateScaleFromZoom(params.zoomChange, (ReferencedEnvelope)previous.getRight(), params).getLeft();
            TreeSet<Double> preferredScaleDenominators = new TreeSet<Double>(params.model.getPreferredScaleDenominators());
            boolean zoomingIn = params.zoomChange < 1.0;
            SortedSet<Double> tailSet = preferredScaleDenominators.tailSet(this.scale);
            SortedSet<Double> headSet = preferredScaleDenominators.headSet(this.scale);
            if (preferredScaleDenominators.contains(this.scale)) {
                this.closestMatch = this.scale;
                tailSet.remove(this.scale);
                headSet.remove(this.scale);
                this.nextGreater = ScaleUtils.first(tailSet, null);
                this.nextSmaller = ScaleUtils.last(headSet, null);
            } else if (zoomingIn) {
                this.closestMatch = tailSet.isEmpty() ? this.scale : tailSet.first();
                tailSet.remove(this.closestMatch);
                this.nextGreater = ScaleUtils.first(tailSet, null);
                this.nextSmaller = ScaleUtils.last(headSet, null);
            } else {
                this.closestMatch = headSet.isEmpty() ? this.scale : headSet.last();
                headSet.remove(this.closestMatch);
                this.nextSmaller = ScaleUtils.last(headSet, null);
                this.nextGreater = ScaleUtils.first(tailSet, null);
            }
        }

        public String toString() {
            return String.valueOf(this.scale) + " [" + this.nextSmaller + ", *" + this.closestMatch + "*, " + this.nextGreater + "]";
        }
    }
}

