/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.internal.render.impl;

import java.awt.Graphics2D;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import net.refractions.udig.core.internal.ExtensionPointProcessor;
import net.refractions.udig.core.internal.ExtensionPointUtil;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.internal.ContextModel;
import net.refractions.udig.project.internal.Layer;
import net.refractions.udig.project.internal.ProjectPlugin;
import net.refractions.udig.project.internal.render.CompositeRenderContext;
import net.refractions.udig.project.internal.render.RenderContext;
import net.refractions.udig.project.internal.render.RenderManager;
import net.refractions.udig.project.internal.render.Renderer;
import net.refractions.udig.project.internal.render.RendererCreator;
import net.refractions.udig.project.internal.render.SelectionLayer;
import net.refractions.udig.project.internal.render.impl.InternalRenderMetricsFactory;
import net.refractions.udig.project.internal.render.impl.PlaceHolder;
import net.refractions.udig.project.internal.render.impl.RenderMetricsSorter;
import net.refractions.udig.project.internal.render.impl.RendererExtensionProcessor;
import net.refractions.udig.project.internal.render.impl.RendererImpl;
import net.refractions.udig.project.render.AbstractRenderMetrics;
import net.refractions.udig.project.render.IRenderContext;
import net.refractions.udig.project.render.IRenderMetricsFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.notify.Notification;
import org.geotools.data.FeatureSource;
import org.geotools.util.Range;

public class RendererCreatorImpl
implements RendererCreator {
    protected volatile RenderContext context = null;
    protected final SortedSet<Layer> layers = Collections.synchronizedSortedSet(new TreeSet());
    private volatile Map<Layer, RenderContext> configuration;
    Map<Layer, List<InternalRenderMetricsFactory.InternalRenderMetrics>> layerToMetricsFactoryMap = new HashMap<Layer, List<InternalRenderMetricsFactory.InternalRenderMetrics>>();
    Collection<RenderContext> contexts = Collections.synchronizedSet(new TreeSet());

    @Override
    public RenderContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(RenderContext newContext) {
        this.context = newContext;
    }

    @Override
    public SortedSet<Layer> getLayers() {
        return this.layers;
    }

    @Override
    public Map<String, String> getAvailableRenderersInfo(Layer layer) {
        HashMap<String, String> renderers = new HashMap<String, String>();
        List<InternalRenderMetricsFactory.InternalRenderMetrics> availableRenderers = this.layerToMetricsFactoryMap.get(layer);
        for (InternalRenderMetricsFactory.InternalRenderMetrics irm : availableRenderers) {
            renderers.put(irm.getName(), irm.getDescription());
        }
        return renderers;
    }

    @Override
    public Collection<AbstractRenderMetrics> getAvailableRendererMetrics(Layer layer) {
        ArrayList<AbstractRenderMetrics> metrics = new ArrayList<AbstractRenderMetrics>();
        List<InternalRenderMetricsFactory.InternalRenderMetrics> availableRenderers = this.layerToMetricsFactoryMap.get(layer);
        if (availableRenderers == null) {
            this.createConfiguration();
            availableRenderers = this.layerToMetricsFactoryMap.get(layer);
            if (availableRenderers == null) {
                return Collections.emptyList();
            }
        }
        for (InternalRenderMetricsFactory.InternalRenderMetrics internalRenderMetrics : availableRenderers) {
            IRenderContext renderContext = internalRenderMetrics.getRenderContext();
            IRenderMetricsFactory renderMetricsFactory = internalRenderMetrics.getRenderMetricsFactory();
            AbstractRenderMetrics createMetrics = renderMetricsFactory.createMetrics(renderContext);
            metrics.add(createMetrics);
        }
        return metrics;
    }

    @Override
    public Renderer getRenderer(RenderContext context) {
        List<InternalRenderMetricsFactory.InternalRenderMetrics> list;
        List<InternalRenderMetricsFactory.InternalRenderMetrics> o = this.layerToMetricsFactoryMap.get(context.getLayer());
        if (o == null) {
            this.createConfiguration();
        }
        if ((list = this.layerToMetricsFactoryMap.get(context.getLayerInternal())).isEmpty()) {
            return this.getPlaceHolder(context);
        }
        InternalRenderMetricsFactory.InternalRenderMetrics internalRenderMetrics = null;
        Iterator<InternalRenderMetricsFactory.InternalRenderMetrics> iter = list.iterator();
        while (iter.hasNext() && internalRenderMetrics == null) {
            internalRenderMetrics = iter.next();
            try {
                boolean canRender = internalRenderMetrics.getRenderMetricsFactory().canRender(context);
                if (!canRender) continue;
                Renderer createRenderer = internalRenderMetrics.createRenderer();
                createRenderer.setContext(context);
                return createRenderer;
            }
            catch (Throwable throwable) {
                internalRenderMetrics = null;
            }
        }
        return this.getPlaceHolder(context);
    }

    private PlaceHolder getPlaceHolder(RenderContext context) {
        PlaceHolder placeHolder = new PlaceHolder();
        placeHolder.setContext(context);
        return placeHolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void createConfiguration() {
        boolean configurationPassed = false;
        while (!configurationPassed) {
            this.initRenderMetrics();
            HashSet<Layer> configured = new HashSet<Layer>();
            ArrayList<Layer> layers = new ArrayList<Layer>();
            SortedSet<Layer> sortedSet = this.layers;
            synchronized (sortedSet) {
                layers.addAll(this.layers);
            }
            HashMap<Layer, RenderContext> configuration = new HashMap<Layer, RenderContext>();
            int i = 0;
            while (i < layers.size()) {
                Layer layer = (Layer)layers.get(i);
                if (!configured.contains(layer)) {
                    AbstractRenderMetrics metrics;
                    List<InternalRenderMetricsFactory.InternalRenderMetrics> layerfactories = this.layerToMetricsFactoryMap.get(layer);
                    Collections.sort(layerfactories, new RenderMetricsSorter(layers));
                    if (!layerfactories.isEmpty() && (metrics = (AbstractRenderMetrics)layerfactories.get(0)) != null) {
                        RenderContext renderContext = (RenderContext)metrics.getRenderContext();
                        if (renderContext instanceof CompositeRenderContext) {
                            this.constructCompositeContext(configured, layers, configuration, i, metrics, (CompositeRenderContext)renderContext);
                        }
                        configuration.put(layer, renderContext);
                    }
                }
                ++i;
            }
            SortedSet<Layer> sortedSet2 = this.layers;
            synchronized (sortedSet2) {
                Iterator iter1 = layers.iterator();
                Iterator iter2 = this.layers.iterator();
                boolean failed = false;
                while (iter1.hasNext()) {
                    if (!iter2.hasNext()) {
                        failed = true;
                        break;
                    }
                    if (((Layer)iter1.next()).equals(iter2.next())) continue;
                    failed = true;
                    break;
                }
                if (!failed) {
                    this.configuration = Collections.synchronizedMap(configuration);
                    configurationPassed = true;
                }
            }
        }
    }

    private void constructCompositeContext(Set<Layer> configured, List<Layer> layers, Map<Layer, RenderContext> configuration, int i, AbstractRenderMetrics metrics, CompositeRenderContext renderContext) {
        renderContext.addContexts(Collections.singleton(renderContext));
        configured.add(renderContext.getLayerInternal());
        configuration.put(renderContext.getLayerInternal(), renderContext);
        int j = i + 1;
        while (j < layers.size()) {
            try {
                Layer layer = layers.get(j);
                if (configured.contains(layer) || !metrics.canAddLayer(layer)) break;
                this.addChildContextToComposite(configured, configuration, renderContext, layer);
            }
            catch (Exception exception) {
                break;
            }
            ++j;
        }
    }

    private void addChildContextToComposite(Set<Layer> configured, Map<Layer, RenderContext> configuration, CompositeRenderContext renderContext, Layer layer) {
        List<InternalRenderMetricsFactory.InternalRenderMetrics> layerfactories2 = this.layerToMetricsFactoryMap.get(layer);
        AbstractRenderMetrics metrics2 = layerfactories2.get(0);
        Set<RenderContext> child = Collections.singleton((RenderContext)metrics2.getRenderContext());
        renderContext.addContexts(child);
        configured.add(layer);
        configuration.put(layer, renderContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initRenderMetrics() {
        SortedSet<Layer> sortedSet = this.layers;
        synchronized (sortedSet) {
            for (Layer layer : this.getLayers()) {
                if (this.layerToMetricsFactoryMap.containsKey(layer)) continue;
                this.initFactories(layer);
            }
        }
    }

    @Override
    public RenderContext getRenderContext(Layer layer) {
        if (this.configuration == null) {
            this.createConfiguration();
        }
        return this.configuration.get(layer);
    }

    @Override
    public void changed(Notification event) {
        if ((event.getNotifier() instanceof ContextModel || event.getNotifier() instanceof RenderManager) && event.getFeatureID(ContextModel.class) == 0) {
            this.handleMapCompositionEvent(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleMapCompositionEvent(Notification event) {
        switch (event.getEventType()) {
            case 3: {
                Layer layer = (Layer)event.getNewValue();
                ArrayList<Layer> layers = new ArrayList<Layer>();
                layers.add(layer);
                if (layer.hasResource(FeatureSource.class)) {
                    layers.add(new SelectionLayer(layer));
                }
                SortedSet<Layer> sortedSet = this.layers;
                synchronized (sortedSet) {
                    this.layers.addAll(layers);
                    break;
                }
            }
            case 5: {
                Object layer2;
                ArrayList<Object> layers = new ArrayList<Object>();
                for (Object layer2 : (Collection)event.getNewValue()) {
                    layers.add(layer2);
                    if (!layer2.hasResource(FeatureSource.class) || this.findSelectionLayer((ILayer)layer2) != null) continue;
                    layers.add(new SelectionLayer((Layer)layer2));
                }
                layer2 = this.layers;
                synchronized (layer2) {
                    this.layers.addAll(layers);
                    break;
                }
            }
            case 4: {
                SortedSet<Layer> layers = this.layers;
                synchronized (layers) {
                    Layer removedLayer = (Layer)event.getOldValue();
                    Iterator iter = this.layers.iterator();
                    while (iter.hasNext()) {
                        SelectionLayer sl;
                        Layer l = (Layer)iter.next();
                        if (removedLayer == l) {
                            iter.remove();
                            continue;
                        }
                        if (!(l instanceof SelectionLayer) || removedLayer != (sl = (SelectionLayer)l).getWrappedLayer()) continue;
                        iter.remove();
                    }
                    break;
                }
            }
            case 6: {
                SortedSet<Layer> layers = this.layers;
                synchronized (layers) {
                    Collection removedLayers = (Collection)event.getOldValue();
                    Iterator iter = this.layers.iterator();
                    while (iter.hasNext()) {
                        SelectionLayer sl;
                        Layer l = (Layer)iter.next();
                        if (removedLayers.contains(l)) {
                            iter.remove();
                            continue;
                        }
                        if (!(l instanceof SelectionLayer) || !removedLayers.contains((sl = (SelectionLayer)l).getWrappedLayer())) continue;
                        iter.remove();
                    }
                    break;
                }
            }
            case 7: {
                Layer newV = (Layer)event.getNewValue();
                SortedSet<Layer> removedLayers = this.layers;
                synchronized (removedLayers) {
                    SelectionLayer selectionLayer = null;
                    Iterator iter = this.layers.iterator();
                    while (iter.hasNext()) {
                        SelectionLayer sl;
                        Layer l = (Layer)iter.next();
                        if (newV == l) {
                            iter.remove();
                            continue;
                        }
                        if (!(l instanceof SelectionLayer) || newV != (sl = (SelectionLayer)l).getWrappedLayer()) continue;
                        iter.remove();
                        selectionLayer = sl;
                    }
                    this.layers.add(newV);
                    if (selectionLayer != null) {
                        this.layers.add(selectionLayer);
                    }
                    break;
                }
            }
            case 1: {
                Layer oldV = (Layer)event.getOldValue();
                Layer newV = (Layer)event.getNewValue();
                SelectionLayer selectionLayer = null;
                if (newV.hasResource(FeatureSource.class)) {
                    selectionLayer = new SelectionLayer(newV);
                }
                SortedSet<Layer> sortedSet = this.layers;
                synchronized (sortedSet) {
                    Iterator iter = this.layers.iterator();
                    while (iter.hasNext()) {
                        SelectionLayer sl;
                        Layer l = (Layer)iter.next();
                        if (oldV == l) {
                            iter.remove();
                            continue;
                        }
                        if (!(l instanceof SelectionLayer) || oldV != (sl = (SelectionLayer)l).getWrappedLayer()) continue;
                        iter.remove();
                    }
                    this.layers.add(newV);
                    if (selectionLayer != null) {
                        this.layers.add(selectionLayer);
                    }
                    break;
                }
            }
        }
        this.configuration = null;
    }

    @Override
    public SelectionLayer findSelectionLayer(ILayer targetLayer) {
        try {
            if (targetLayer.getResource(FeatureSource.class, null) == null) {
                return null;
            }
        }
        catch (IOException iOException) {
            return null;
        }
        for (Layer layer : this.getLayers()) {
            if (!(layer instanceof SelectionLayer) || ((SelectionLayer)layer).getWrappedLayer() != targetLayer) continue;
            return (SelectionLayer)layer;
        }
        return null;
    }

    private void initFactories(Layer layer) {
        RendererExtensionProcessor p = new RendererExtensionProcessor(layer, this.getContext().getMapInternal(), this.getContext().getRenderManagerInternal());
        ExtensionPointUtil.process((Plugin)ProjectPlugin.getPlugin(), (String)"net.refractions.udig.project.renderer", (ExtensionPointProcessor)p);
        this.layerToMetricsFactoryMap.put(layer, p.rFactories);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<RenderContext> getConfiguration() {
        if (this.configuration == null) {
            this.createConfiguration();
        }
        LinkedList<RenderContext> uniqueValues = new LinkedList<RenderContext>();
        Object object = this.configuration;
        synchronized (object) {
            Collection<RenderContext> values = this.configuration.values();
            for (RenderContext renderCtx : values) {
                boolean found = false;
                for (RenderContext ctx : uniqueValues) {
                    if (renderCtx != ctx) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                uniqueValues.add(renderCtx);
            }
        }
        object = this.contexts;
        synchronized (object) {
            this.contexts.clear();
            for (RenderContext context : uniqueValues) {
                this.contexts.add(context);
            }
        }
        return new ArrayList<RenderContext>(this.contexts);
    }

    @Override
    public void reset() {
        this.configuration = null;
        this.contexts.clear();
        this.getConfiguration();
    }

    static class DumbRenderer
    extends RendererImpl {
        DumbRenderer() {
        }

        @Override
        public void render(Graphics2D destination, IProgressMonitor monitor) {
        }

        public void stopRendering() {
        }

        @Override
        public void dispose() {
        }

        @Override
        public void render(IProgressMonitor monitor) {
        }
    }

    static class DumbRendererMetrics
    extends AbstractRenderMetrics {
        private RenderContext context;

        public DumbRendererMetrics(Layer layer, IRenderContext context) {
            super(context, null, new ArrayList<String>());
            this.context = (RenderContext)context;
        }

        @Override
        public Renderer createRenderer() {
            return new DumbRenderer();
        }

        @Override
        public RenderContext getRenderContext() {
            return this.context;
        }

        public void setRenderContext(IRenderContext context) {
        }

        @Override
        public IRenderMetricsFactory getRenderMetricsFactory() {
            return null;
        }

        @Override
        public boolean canAddLayer(ILayer layer) {
            return false;
        }

        @Override
        public boolean canStyle(String SyleID, Object value) {
            return false;
        }

        public boolean isOptimized() {
            return false;
        }

        @Override
        public Set<Range<Double>> getValidScaleRanges() {
            return new HashSet<Range<Double>>();
        }
    }
}

