/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.internal.render.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.refractions.udig.core.internal.ExtensionPointProcessor;
import net.refractions.udig.project.internal.render.impl.InternalRenderMetricsFactory;
import net.refractions.udig.project.render.AbstractRenderMetrics;
import net.refractions.udig.project.render.IRenderContext;
import net.refractions.udig.project.render.IRenderMetricsFactory;
import net.refractions.udig.project.render.IRenderer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;

public class RenderMetricsFactoryExtensionPointProcessor
implements ExtensionPointProcessor {
    private List<IRenderMetricsFactory> rFactories = new ArrayList<IRenderMetricsFactory>();

    public void process(IExtension extension, IConfigurationElement element) {
        try {
            IRenderMetricsFactory createExecutableExtension = (IRenderMetricsFactory)element.createExecutableExtension("class");
            InternalRenderMetricsFactory metricsFactory = new InternalRenderMetricsFactory(createExecutableExtension, element);
            this.rFactories.add(new IdRenderMetricsFactory(metricsFactory, String.valueOf(element.getNamespaceIdentifier()) + "." + element.getAttribute("id")));
        }
        catch (CoreException e) {
            throw (RuntimeException)new RuntimeException().initCause(e);
        }
    }

    public List<IRenderMetricsFactory> getRFactories() {
        return this.rFactories;
    }

    public static class IdRenderMetricsFactory
    implements IRenderMetricsFactory {
        private IRenderMetricsFactory renderMetricsFactory = null;
        private String id = null;

        public IdRenderMetricsFactory(IRenderMetricsFactory factory, String id) {
            this.id = id;
            this.renderMetricsFactory = factory;
        }

        @Override
        public boolean canRender(IRenderContext context) throws IOException {
            return this.renderMetricsFactory.canRender(context);
        }

        @Override
        public AbstractRenderMetrics createMetrics(IRenderContext context) {
            return this.renderMetricsFactory.createMetrics(context);
        }

        @Override
        public Class<? extends IRenderer> getRendererType() {
            return this.renderMetricsFactory.getRendererType();
        }

        public String getId() {
            return this.id;
        }
    }
}

