/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.internal.render.impl;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.SortedSet;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.core.internal.ExtensionPointList;
import net.refractions.udig.project.internal.ProjectFactory;
import net.refractions.udig.project.internal.ProjectPackage;
import net.refractions.udig.project.internal.ProjectPlugin;
import net.refractions.udig.project.internal.render.MultiLayerRenderer;
import net.refractions.udig.project.internal.render.RenderExecutor;
import net.refractions.udig.project.internal.render.RenderFactory;
import net.refractions.udig.project.internal.render.RenderManager;
import net.refractions.udig.project.internal.render.RenderPackage;
import net.refractions.udig.project.internal.render.Renderer;
import net.refractions.udig.project.internal.render.RendererDecorator;
import net.refractions.udig.project.internal.render.ViewportModel;
import net.refractions.udig.project.internal.render.impl.CompositeRendererImpl;
import net.refractions.udig.project.internal.render.impl.RenderContextImpl;
import net.refractions.udig.project.internal.render.impl.RenderExecutorImpl;
import net.refractions.udig.project.internal.render.impl.RenderManagerImpl;
import net.refractions.udig.project.internal.render.impl.TiledCompositeRendererImpl;
import net.refractions.udig.project.internal.render.impl.ViewportModelImpl;
import net.refractions.udig.project.render.RenderException;
import net.refractions.udig.project.render.displayAdapter.IMapDisplay;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.geotools.data.Query;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.joda.time.DateTime;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.osgi.framework.Bundle;

public class RenderFactoryImpl
extends EFactoryImpl
implements RenderFactory {
    public static RenderFactory init() {
        try {
            RenderFactory theRenderFactory = (RenderFactory)EPackage.Registry.INSTANCE.getEFactory("http:///net/refractions/udig/project/internal/render.ecore");
            if (theRenderFactory != null) {
                return theRenderFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new RenderFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 6: {
                return this.createRenderExecutor();
            }
            case 7: {
                return this.createRenderManager();
            }
            case 8: {
                return this.createViewportModel();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    @Override
    public RenderExecutor createRenderExecutor() {
        return new RenderExecutorImpl();
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 13: {
                return this.createCoordinateReferenceSystemFromString(eDataType, initialValue);
            }
            case 14: {
                return this.createEnvelopeFromString(eDataType, initialValue);
            }
            case 15: {
                return this.createIGeoResourceFromString(eDataType, initialValue);
            }
            case 16: {
                return this.createBufferedImageFromString(eDataType, initialValue);
            }
            case 17: {
                return this.createRectangleFromString(eDataType, initialValue);
            }
            case 18: {
                return this.createQueryFromString(eDataType, initialValue);
            }
            case 19: {
                return this.createGraphics2DFromString(eDataType, initialValue);
            }
            case 20: {
                return this.createListFromString(eDataType, initialValue);
            }
            case 21: {
                return this.createCoordinateFromString(eDataType, initialValue);
            }
            case 22: {
                return this.createPointFromString(eDataType, initialValue);
            }
            case 23: {
                return this.createAffineTransformFromString(eDataType, initialValue);
            }
            case 24: {
                return this.createMapDisplayFromString(eDataType, initialValue);
            }
            case 25: {
                return this.createIProgressMonitorFromString(eDataType, initialValue);
            }
            case 26: {
                return this.createRenderExceptionFromString(eDataType, initialValue);
            }
            case 27: {
                return this.createSortedSetFromString(eDataType, initialValue);
            }
            case 28: {
                return this.createReferencedEnvelopeFromString(eDataType, initialValue);
            }
            case 29: {
                return this.createDateTimeFromString(eDataType, initialValue);
            }
            case 30: {
                return this.createIllegalArgumentExceptionFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 13: {
                return this.convertCoordinateReferenceSystemToString(eDataType, instanceValue);
            }
            case 14: {
                return this.convertEnvelopeToString(eDataType, instanceValue);
            }
            case 15: {
                return this.convertIGeoResourceToString(eDataType, instanceValue);
            }
            case 16: {
                return this.convertBufferedImageToString(eDataType, instanceValue);
            }
            case 17: {
                return this.convertRectangleToString(eDataType, instanceValue);
            }
            case 18: {
                return this.convertQueryToString(eDataType, instanceValue);
            }
            case 19: {
                return this.convertGraphics2DToString(eDataType, instanceValue);
            }
            case 20: {
                return this.convertListToString(eDataType, instanceValue);
            }
            case 21: {
                return this.convertCoordinateToString(eDataType, instanceValue);
            }
            case 22: {
                return this.convertPointToString(eDataType, instanceValue);
            }
            case 23: {
                return this.convertAffineTransformToString(eDataType, instanceValue);
            }
            case 24: {
                return this.convertMapDisplayToString(eDataType, instanceValue);
            }
            case 25: {
                return this.convertIProgressMonitorToString(eDataType, instanceValue);
            }
            case 26: {
                return this.convertRenderExceptionToString(eDataType, instanceValue);
            }
            case 27: {
                return this.convertSortedSetToString(eDataType, instanceValue);
            }
            case 28: {
                return this.convertReferencedEnvelopeToString(eDataType, instanceValue);
            }
            case 29: {
                return this.convertDateTimeToString(eDataType, instanceValue);
            }
            case 30: {
                return this.convertIllegalArgumentExceptionToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    @Override
    public RenderManager createRenderManager() {
        RenderManagerImpl renderManager = new RenderManagerImpl();
        return renderManager;
    }

    @Override
    public RenderManager createRenderManagerViewer() {
        RenderManagerImpl renderManager = new RenderManagerImpl();
        renderManager.setViewer(true);
        return renderManager;
    }

    @Override
    public ViewportModel createViewportModel() {
        ViewportModelImpl viewportModel = new ViewportModelImpl();
        return viewportModel;
    }

    @Override
    public ViewportModel createViewportModelViewer() {
        ViewportModelImpl viewportModel = new ViewportModelImpl();
        viewportModel.setViewer(true);
        return viewportModel;
    }

    @Override
    public RenderExecutor createRenderExecutor(Renderer renderer) {
        RenderExecutor executor = this.locateMatch(renderer);
        if (executor == null) {
            executor = this.locateClosestFit(renderer);
        }
        executor.setRenderer(renderer);
        return executor;
    }

    private RenderExecutor locateClosestFit(Renderer r) {
        Renderer ofInterest = r;
        if (r instanceof RendererDecorator) {
            ofInterest = ((RendererDecorator)((Object)r)).getRenderer();
        }
        final Renderer renderer = ofInterest;
        ArrayList<IConfigurationElement> list = new ArrayList<IConfigurationElement>();
        for (IConfigurationElement elem : ExtensionPointList.getExtensionPointList((String)"net.refractions.udig.project.renderExecutor")) {
            try {
                Bundle bundle = Platform.getBundle((String)elem.getNamespaceIdentifier());
                Class rendererClass = bundle.loadClass(elem.getAttribute("rendererClass"));
                if (!rendererClass.isAssignableFrom(renderer.getClass())) continue;
                list.add(elem);
            }
            catch (Exception e) {
                ProjectPlugin.log(null, e);
            }
        }
        if (!list.isEmpty()) {
            Collections.sort(list, new Comparator<IConfigurationElement>(){

                @Override
                public int compare(IConfigurationElement o1, IConfigurationElement o2) {
                    int dist2;
                    int dist1;
                    block3: {
                        try {
                            Bundle bundle = Platform.getBundle((String)o1.getNamespaceIdentifier());
                            Class clazz1 = bundle.loadClass(o1.getAttribute("rendererClass"));
                            bundle = Platform.getBundle((String)o2.getNamespaceIdentifier());
                            Class clazz2 = bundle.loadClass(o2.getAttribute("rendererClass"));
                            dist1 = this.getDistance(renderer.getClass(), clazz1);
                            dist2 = this.getDistance(renderer.getClass(), clazz2);
                            if (dist1 != dist2) break block3;
                            return 0;
                        }
                        catch (Exception e) {
                            ProjectPlugin.log(null, e);
                            return 0;
                        }
                    }
                    return dist1 < dist2 ? -1 : 1;
                }

                private int getDistance(Class<?> rendererClass, Class<?> target) {
                    if (!target.isAssignableFrom(rendererClass)) {
                        return -1;
                    }
                    if (target == rendererClass) {
                        return 0;
                    }
                    Class<?>[] classArray = rendererClass.getInterfaces();
                    int n = classArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Class<?> iClass = classArray[n2];
                        if (iClass == target) {
                            return 1;
                        }
                        int distance = this.getDistance(iClass, target);
                        if (distance != -1) {
                            return 1 + distance;
                        }
                        ++n2;
                    }
                    return 1 + this.getDistance(rendererClass.getSuperclass(), target);
                }
            });
            try {
                return (RenderExecutor)((IConfigurationElement)list.get(0)).createExecutableExtension("executorClass");
            }
            catch (CoreException e) {
                ProjectPlugin.log(null, e);
            }
        }
        return this.createRenderExecutor();
    }

    private RenderExecutor locateMatch(Renderer renderer) {
        Renderer ofInterest = renderer;
        if (renderer instanceof RendererDecorator) {
            ofInterest = ((RendererDecorator)((Object)renderer)).getRenderer();
        }
        ArrayList<IConfigurationElement> list = new ArrayList<IConfigurationElement>();
        for (IConfigurationElement elem : ExtensionPointList.getExtensionPointList((String)"net.refractions.udig.project.renderExecutor")) {
            if (!elem.getAttribute("rendererClass").equals(ofInterest.getClass().getName())) continue;
            list.add(elem);
        }
        if (!list.isEmpty()) {
            try {
                return (RenderExecutor)((IConfigurationElement)list.get(0)).createExecutableExtension("executorClass");
            }
            catch (CoreException e) {
                ProjectPlugin.log(null, e);
            }
        }
        return null;
    }

    public RenderContextImpl createRenderContext(boolean selection) {
        RenderContextImpl renderContext = new RenderContextImpl(selection);
        return renderContext;
    }

    public Rectangle createRectangleFromString(EDataType eDataType, String initialValue) {
        return (Rectangle)super.createFromString(eDataType, initialValue);
    }

    public String convertRectangleToString(EDataType eDataType, Object instanceValue) {
        return super.convertToString(eDataType, instanceValue);
    }

    public AffineTransform createAffineTransformFromString(EDataType eDataType, String initialValue) {
        return (AffineTransform)super.createFromString(eDataType, initialValue);
    }

    public String convertAffineTransformToString(EDataType eDataType, Object instanceValue) {
        return super.convertToString(eDataType, instanceValue);
    }

    public Point createPointFromString(EDataType eDataType, String initialValue) {
        return (Point)super.createFromString(eDataType, initialValue);
    }

    public String convertPointToString(EDataType eDataType, Object instanceValue) {
        return super.convertToString(eDataType, instanceValue);
    }

    public IMapDisplay createMapDisplayFromString(EDataType eDataType, String initialValue) {
        return (IMapDisplay)super.createFromString(eDataType, initialValue);
    }

    public String convertMapDisplayToString(EDataType eDataType, Object instanceValue) {
        return super.convertToString(eDataType, instanceValue);
    }

    public IProgressMonitor createIProgressMonitorFromString(EDataType eDataType, String initialValue) {
        return (IProgressMonitor)super.createFromString(eDataType, initialValue);
    }

    public String convertIProgressMonitorToString(EDataType eDataType, Object instanceValue) {
        return super.convertToString(eDataType, instanceValue);
    }

    public RenderException createRenderExceptionFromString(EDataType eDataType, String initialValue) {
        return (RenderException)super.createFromString(eDataType, initialValue);
    }

    public String convertRenderExceptionToString(EDataType eDataType, Object instanceValue) {
        return super.convertToString(eDataType, instanceValue);
    }

    public SortedSet<?> createSortedSetFromString(EDataType eDataType, String initialValue) {
        return (SortedSet)super.createFromString(initialValue);
    }

    public String convertSortedSetToString(EDataType eDataType, Object instanceValue) {
        return super.convertToString(instanceValue);
    }

    public Graphics2D createGraphics2DFromString(EDataType eDataType, String initialValue) {
        return (Graphics2D)super.createFromString(eDataType, initialValue);
    }

    public String convertGraphics2DToString(EDataType eDataType, Object instanceValue) {
        return super.convertToString(eDataType, instanceValue);
    }

    public Coordinate createCoordinateFromString(EDataType eDataType, String initialValue) {
        return (Coordinate)super.createFromString(eDataType, initialValue);
    }

    public String convertCoordinateToString(EDataType eDataType, Object instanceValue) {
        return super.convertToString(eDataType, instanceValue);
    }

    public CoordinateReferenceSystem createCoordinateReferenceSystemFromString(EDataType eDataType, String initialValue) {
        return (CoordinateReferenceSystem)ProjectFactory.eINSTANCE.createFromString(ProjectPackage.eINSTANCE.getCoordinateReferenceSystem(), initialValue);
    }

    public String convertCoordinateReferenceSystemToString(EDataType eDataType, Object instanceValue) {
        return ProjectFactory.eINSTANCE.convertToString(ProjectPackage.eINSTANCE.getCoordinateReferenceSystem(), instanceValue);
    }

    public Envelope createEnvelopeFromString(EDataType eDataType, String initialValue) {
        return (Envelope)ProjectFactory.eINSTANCE.createFromString(ProjectPackage.eINSTANCE.getEnvelope(), initialValue);
    }

    public String convertEnvelopeToString(EDataType eDataType, Object instanceValue) {
        return ProjectFactory.eINSTANCE.convertToString(ProjectPackage.eINSTANCE.getEnvelope(), instanceValue);
    }

    public ReferencedEnvelope createReferencedEnvelopeFromString(EDataType eDataType, String initialValue) {
        return (ReferencedEnvelope)ProjectFactory.eINSTANCE.createFromString(ProjectPackage.eINSTANCE.getReferencedEnvelope(), initialValue);
    }

    public String convertReferencedEnvelopeToString(EDataType eDataType, Object instanceValue) {
        return ProjectFactory.eINSTANCE.convertToString(ProjectPackage.eINSTANCE.getReferencedEnvelope(), instanceValue);
    }

    public DateTime createDateTimeFromString(EDataType eDataType, String initialValue) {
        return (DateTime)super.createFromString(eDataType, initialValue);
    }

    public String convertDateTimeToString(EDataType eDataType, Object instanceValue) {
        return super.convertToString(eDataType, instanceValue);
    }

    public IllegalArgumentException createIllegalArgumentExceptionFromString(EDataType eDataType, String initialValue) {
        return (IllegalArgumentException)super.createFromString(eDataType, initialValue);
    }

    public String convertIllegalArgumentExceptionToString(EDataType eDataType, Object instanceValue) {
        return super.convertToString(eDataType, instanceValue);
    }

    public BufferedImage createBufferedImageFromString(EDataType eDataType, String initialValue) {
        return (BufferedImage)super.createFromString(eDataType, initialValue);
    }

    public String convertBufferedImageToString(EDataType eDataType, Object instanceValue) {
        return super.convertToString(eDataType, instanceValue);
    }

    public Query createQueryFromString(EDataType eDataType, String initialValue) {
        return (Query)super.createFromString(eDataType, initialValue);
    }

    public String convertQueryToString(EDataType eDataType, Object instanceValue) {
        return super.convertToString(eDataType, instanceValue);
    }

    public List createListFromString(EDataType eDataType, String initialValue) {
        return (List)super.createFromString(eDataType, initialValue);
    }

    public String convertListToString(EDataType eDataType, Object instanceValue) {
        return super.convertToString(eDataType, instanceValue);
    }

    public IGeoResource createIGeoResourceFromString(EDataType eDataType, String initialValue) {
        return (IGeoResource)super.createFromString(eDataType, initialValue);
    }

    public String convertIGeoResourceToString(EDataType eDataType, Object instanceValue) {
        return super.convertToString(eDataType, instanceValue);
    }

    @Override
    public TiledCompositeRendererImpl createTiledCompositeRenderer() {
        return new TiledCompositeRendererImpl();
    }

    @Override
    public RenderPackage getRenderPackage() {
        return (RenderPackage)this.getEPackage();
    }

    @Deprecated
    public static RenderPackage getPackage() {
        return RenderPackage.eINSTANCE;
    }

    @Override
    public MultiLayerRenderer createCompositeRenderer() {
        return new CompositeRendererImpl();
    }
}

