/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.internal.render.impl;

import java.util.List;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.internal.Layer;
import net.refractions.udig.project.internal.render.CompositeRenderContext;
import net.refractions.udig.project.internal.render.ExecutorVisitor;
import net.refractions.udig.project.internal.render.MultiLayerRenderer;
import net.refractions.udig.project.internal.render.RenderContext;
import net.refractions.udig.project.internal.render.RenderExecutor;
import net.refractions.udig.project.internal.render.Renderer;
import net.refractions.udig.project.internal.render.impl.CompositeContextListener;
import net.refractions.udig.project.internal.render.impl.RenderExecutorImpl;
import net.refractions.udig.project.internal.render.impl.RenderJob;
import net.refractions.udig.project.render.IRenderContext;
import org.eclipse.emf.common.notify.Notification;

public class RenderExecutorMultiLayer
extends RenderExecutorImpl {
    String jobName;
    ContextListener listener = new ContextListener();

    public RenderExecutorMultiLayer() {
        this.renderJob = new RenderJob(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String getRenderJobName() {
        if (this.jobName == null) {
            RenderExecutorMultiLayer renderExecutorMultiLayer = this;
            synchronized (renderExecutorMultiLayer) {
                if (this.jobName == null) {
                    StringBuffer buffer = new StringBuffer("[");
                    CompositeRenderContext context = this.getContext();
                    for (IRenderContext rc : context.getContexts()) {
                        buffer.append(rc.getLayer().getName());
                        buffer.append(",");
                    }
                    buffer.replace(buffer.length() - 1, buffer.length(), "]");
                    this.jobName = buffer.toString();
                }
            }
        }
        return this.jobName;
    }

    @Override
    public void setRenderer(Renderer newRenderer) {
        if (this.getContext() != null) {
            for (IRenderContext context : this.getContext().getContexts()) {
                this.removeLayerListener(context);
            }
        }
        if (this.getContext() != null) {
            this.getContext().removeListener(this.listener);
        }
        this.setRendererInternal(newRenderer);
        if (this.getContext() != null) {
            this.getContext().addListener(this.listener);
        }
        for (IRenderContext context : ((CompositeRenderContext)newRenderer.getContext()).getContexts()) {
            this.addLayerListener(context);
        }
    }

    protected void setRendererInternal(Renderer newRenderer) {
        super.setRenderer(newRenderer);
    }

    @Override
    public CompositeRenderContext getContext() {
        return (CompositeRenderContext)super.getContext();
    }

    protected void resyncState(Renderer renderer) {
    }

    @Override
    protected RenderExecutorImpl.LayerListener getLayerListener() {
        return new MultiLayerRendererLayerListener(this);
    }

    @Override
    protected RenderExecutorImpl.RendererListener getRendererListener() {
        return new MultiLayerRendererListener(this);
    }

    @Override
    public void visit(ExecutorVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public String toString() {
        return super.toString();
    }

    @Override
    public void dispose() {
        for (Layer layer : this.getContext().getMapInternal().getLayersInternal()) {
            layer.eAdapters().remove((Object)this.listener);
        }
        super.dispose();
    }

    protected class ContextListener
    implements CompositeContextListener {
        protected ContextListener() {
        }

        @Override
        public void notifyChanged(CompositeRenderContext context, List<RenderContext> contexts, boolean added) {
            if (added) {
                for (RenderContext context2 : contexts) {
                    RenderExecutorMultiLayer.this.addLayerListener(context2);
                }
            } else {
                for (RenderContext context2 : contexts) {
                    RenderExecutorMultiLayer.this.removeLayerListener(context2);
                }
            }
        }
    }

    protected static final class MultiLayerRendererLayerListener
    extends RenderExecutorImpl.LayerListener {
        MultiLayerRendererLayerListener(RenderExecutorMultiLayer executor) {
            super(executor);
        }

        protected void styleBlackboardChanged(Notification msg) {
            if (this.executor.getRenderer() instanceof MultiLayerRenderer) {
                return;
            }
            this.executor.getContext().getRenderManager().refresh((ILayer)msg.getNotifier(), null);
        }

        @Override
        protected void layerNotVisible(Layer layer, Notification msg) {
            this.executor.getContext().getLabelPainter().disableLayer(this.executor.getContext().getLayer().getID().toString());
            CompositeRenderContext context = ((RenderExecutorMultiLayer)this.executor).getContext();
            if (context.isVisible() && context.getContexts().size() > 1) {
                this.executor.getContext().getRenderManager().refresh(layer, null);
            } else {
                super.layerNotVisible(layer, msg);
            }
        }

        @Override
        protected void layerVisible(Layer layer, Notification msg) {
            CompositeRenderContext context = ((RenderExecutorMultiLayer)this.executor).getContext();
            this.executor.getContext().getLabelPainter().disableLayer(this.executor.getContext().getLayer().getID().toString());
            if (context.getContexts().size() > 1) {
                this.executor.getContext().getRenderManager().refresh(layer, null);
            } else {
                super.layerVisible(layer, msg);
            }
        }
    }

    protected static class MultiLayerRendererListener
    extends RenderExecutorImpl.RendererListener {
        MultiLayerRendererListener(RenderExecutor executor) {
            super(executor);
        }

        @Override
        protected void stateChanged(Notification msg) {
            super.stateChanged(msg);
        }
    }
}

