/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.internal.render.impl;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.internal.Layer;
import net.refractions.udig.project.internal.Messages;
import net.refractions.udig.project.internal.ProjectPlugin;
import net.refractions.udig.project.internal.impl.SynchronizedEList;
import net.refractions.udig.project.internal.render.ExecutorVisitor;
import net.refractions.udig.project.internal.render.RenderContext;
import net.refractions.udig.project.internal.render.RenderExecutor;
import net.refractions.udig.project.internal.render.RenderManager;
import net.refractions.udig.project.internal.render.RenderPackage;
import net.refractions.udig.project.internal.render.Renderer;
import net.refractions.udig.project.internal.render.SelectionLayer;
import net.refractions.udig.project.internal.render.impl.RenderJob;
import net.refractions.udig.project.internal.render.impl.RendererImpl;
import net.refractions.udig.project.render.ILabelPainter;
import net.refractions.udig.project.render.IRenderContext;
import net.refractions.udig.project.render.RenderException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;

public class RenderExecutorImpl
extends RendererImpl
implements RenderExecutor {
    protected Renderer renderer;
    protected Adapter renderListener = this.getRendererListener();
    protected Adapter layerListener = this.getLayerListener();
    protected RenderJob renderJob = new RenderJob(this);
    protected volatile boolean dirty;

    protected static void clearImage(Envelope bounds2, RenderExecutor executor) {
        if (bounds2 != null && !bounds2.contains((Envelope)executor.getContext().getViewportModel().getBounds())) {
            Point min = executor.getContext().worldToPixel(new Coordinate(bounds2.getMinX(), bounds2.getMinY()));
            Point max = executor.getContext().worldToPixel(new Coordinate(bounds2.getMaxX(), bounds2.getMaxY()));
            int width = Math.abs(max.x - min.x);
            int height = Math.abs(max.y - min.y);
            Rectangle paintArea = new Rectangle(Math.min(min.x, max.x), Math.min(min.y, max.y), width, height);
            executor.getContext().clearImage(paintArea);
        } else {
            executor.getContext().clearImage();
        }
    }

    @Override
    protected EClass eStaticClass() {
        return RenderPackage.Literals.RENDER_EXECUTOR;
    }

    @Override
    public void dispose() {
        while (this.getRenderer().eAdapters().remove((Object)this.renderListener)) {
        }
        this.eAdapters().clear();
        this.removeLayerListener(this.getContext());
        this.stopRendering();
        this.getRenderer().dispose();
        try {
            ILayer renderingLayer = this.getContext().getLayer();
            if (renderingLayer != null) {
                ILabelPainter labelPainter = this.getContext().getLabelPainter();
                String layerId = renderingLayer.getID().toString();
                if (this.getContext().getLayer() instanceof SelectionLayer) {
                    layerId = String.valueOf(layerId) + "-Selection";
                }
                labelPainter.clear(layerId);
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        if (this.getRenderer().getState() != 8) {
            this.getRenderer().setState(8);
        }
    }

    @Override
    public void setState(int newState) {
        super.setState(newState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopRendering() {
        if (this.renderJob.cancel()) {
            return;
        }
        final AtomicBoolean done = new AtomicBoolean(this.renderJob.cancel());
        JobChangeAdapter listener = new JobChangeAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void done(IJobChangeEvent event) {
                done.set(true);
                AtomicBoolean atomicBoolean = done;
                synchronized (atomicBoolean) {
                    done.notify();
                }
            }
        };
        this.renderJob.addJobChangeListener((IJobChangeListener)listener);
        try {
            long start = System.currentTimeMillis();
            while (!done.get() && !this.renderJob.cancel() && start + 2000L < System.currentTimeMillis()) {
                AtomicBoolean atomicBoolean = done;
                synchronized (atomicBoolean) {
                    try {
                        done.wait(200L);
                    }
                    catch (InterruptedException e) {
                        throw (RuntimeException)new RuntimeException().initCause(e);
                    }
                }
            }
            if (!done.get() && !this.renderJob.cancel()) {
                ProjectPlugin.log("After 2 seconds unable to cancel " + this.getRenderer().getName() + " Renderer");
            }
        }
        finally {
            this.renderJob.removeJobChangeListener((IJobChangeListener)listener);
        }
    }

    @Override
    public void render(Graphics2D destination, IProgressMonitor monitor) throws RenderException {
        if (this.getState() == 8) {
            return;
        }
        this.getRenderer().render(destination, this.validateMonitor(monitor));
    }

    private IProgressMonitor validateMonitor(IProgressMonitor monitor) {
        if (monitor != null) {
            return monitor;
        }
        return new NullProgressMonitor();
    }

    @Override
    public RenderContext getContext() {
        if (this.getRenderer() == null) {
            return null;
        }
        return (RenderContext)this.getRenderer().getContext();
    }

    @Override
    public Renderer getRenderer() {
        return this.renderer;
    }

    protected String getRenderJobName() {
        return MessageFormat.format(Messages.RenderExecutorImpl_message, this.getName());
    }

    @Override
    public void setRenderer(Renderer newRenderer) {
        if (this.getRenderer() != null) {
            this.getRenderer().eAdapters().remove((Object)this.renderListener);
            this.removeLayerListener((RenderContext)this.getRenderer().getContext());
        }
        this.setRendererGen(newRenderer);
        if (newRenderer != null) {
            newRenderer.eAdapters().add((Object)this.renderListener);
            this.addLayerListener((RenderContext)newRenderer.getContext());
        }
    }

    protected void removeLayerListener(IRenderContext context) {
        if (context.getLayer() != null) {
            Layer layer = (Layer)context.getLayer();
            EList adapters = layer.eAdapters();
            if (adapters instanceof SynchronizedEList) {
                ((SynchronizedEList)adapters).lock();
            }
            try {
                ArrayList<Adapter> toRemove = new ArrayList<Adapter>();
                for (Adapter t : adapters) {
                    if (!(t instanceof LayerListener)) continue;
                    toRemove.add(t);
                }
                adapters.removeAll(toRemove);
            }
            finally {
                if (adapters instanceof SynchronizedEList) {
                    ((SynchronizedEList)adapters).unlock();
                }
            }
        }
    }

    protected void addLayerListener(IRenderContext context) {
        if (context.getLayer() != null && !(context.getLayer() instanceof SelectionLayer)) {
            this.removeLayerListener(context);
            ((Layer)context.getLayer()).eAdapters().add((Object)this.layerListener);
        }
    }

    public void setRendererGen(Renderer newRenderer) {
        Renderer oldRenderer = this.renderer;
        this.renderer = newRenderer;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, (Object)oldRenderer, (Object)this.renderer));
        }
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 3: {
                return this.getRenderer();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 3: {
                this.setRenderer((Renderer)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 3: {
                this.setRenderer(null);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 3: {
                return this.renderer != null;
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public void visit(ExecutorVisitor visitor) {
        visitor.visit(this);
    }

    protected LayerListener getLayerListener() {
        return new LayerListener(this);
    }

    protected RendererListener getRendererListener() {
        return new RendererListener(this);
    }

    @Override
    public synchronized void render() {
        if (this.getState() == 8 || !this.getRenderer().getContext().isVisible()) {
            this.dirty = true;
            this.getContext().getLayer().setStatus(0);
            if (this.getRenderer().getState() != 4) {
                this.getRenderer().setState(4);
            }
            return;
        }
        this.dirty = false;
        if (this.getRenderer().getState() != 32) {
            this.getRenderer().setState(32);
        }
        this.renderJob.addRequest(this.getRenderBounds());
    }

    @Override
    public void render(IProgressMonitor monitor) {
        this.render();
    }

    @Override
    public String toString() {
        String selection = "";
        if (this.getContext().getLayer() instanceof SelectionLayer) {
            selection = "Selection ";
        }
        return String.valueOf(this.getContext().getMap().getName()) + ":" + selection + (this.getRenderer() != null ? this.getRenderer().getName() : "null");
    }

    public static class LayerListener
    extends AdapterImpl {
        protected RenderExecutorImpl executor;

        LayerListener(RenderExecutorImpl executor) {
            this.executor = executor;
        }

        public void notifyChanged(Notification msg) {
            Layer layer = (Layer)msg.getNotifier();
            switch (msg.getFeatureID(Layer.class)) {
                case 2: {
                    break;
                }
                case 8: {
                    if (this.executor.getContext().getLayer() instanceof SelectionLayer) {
                        return;
                    }
                    if (msg.getNewBooleanValue()) {
                        this.layerVisible(layer, msg);
                        break;
                    }
                    this.layerNotVisible(layer, msg);
                    break;
                }
            }
        }

        protected void layerNotVisible(Layer layer, Notification msg) {
            RenderContext context2 = this.executor.getContext();
            context2.getLabelPainter().disableLayer(context2.getLayer().getID().toString());
            if (this.executor.getState() == 2) {
                this.executor.stopRendering();
                context2.setStatus(0);
                context2.setStatusMessage("");
                this.executor.setState(1);
            } else {
                RenderManager renderManager = (RenderManager)layer.getMapInternal().getRenderManager();
                if (renderManager != null) {
                    renderManager.refreshImage();
                }
            }
        }

        protected void layerVisible(Layer layer, Notification msg) {
            RenderContext context2 = this.executor.getContext();
            context2.getLabelPainter().enableLayer(context2.getLayer().getID().toString());
            if (this.executor.getState() == 2) {
                return;
            }
            if (this.executor.getState() != 4 || this.executor.dirty) {
                RenderManager renderManager = (RenderManager)layer.getMapInternal().getRenderManager();
                renderManager.refresh(layer, null);
            } else {
                RenderManager renderManager = (RenderManager)layer.getMapInternal().getRenderManager();
                if (renderManager != null) {
                    renderManager.refreshImage();
                }
            }
        }
    }

    protected static class RendererListener
    extends AdapterImpl {
        protected RenderExecutor executor;

        RendererListener(RenderExecutor executor) {
            this.executor = executor;
        }

        public void notifyChanged(Notification msg) {
            if (msg.getNotifier() instanceof Renderer && msg.getFeatureID(Renderer.class) == 0) {
                if (msg.getNewIntValue() == 16) {
                    this.executor.setRenderBounds(this.executor.getRenderer().getRenderBounds());
                }
                this.stateChanged(msg);
            }
        }

        protected void stateChanged(Notification msg) {
            this.executor.setState(msg.getNewIntValue());
            if (msg.getNewIntValue() == 16) {
                try {
                    this.executor.render();
                }
                catch (RenderException e) {
                    throw (RuntimeException)new RuntimeException().initCause(e);
                }
            }
        }
    }
}

