/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.internal.render.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArraySet;
import net.refractions.udig.project.internal.Layer;
import net.refractions.udig.project.internal.render.CompositeRenderContext;
import net.refractions.udig.project.internal.render.RenderContext;
import net.refractions.udig.project.internal.render.impl.CompositeContextListener;
import net.refractions.udig.project.internal.render.impl.RenderContextImpl;
import net.refractions.udig.project.render.ICompositeRenderContext;
import net.refractions.udig.project.render.IRenderContext;

public class CompositeRenderContextImpl
extends RenderContextImpl
implements CompositeRenderContext {
    protected final Collection<RenderContext> contextsInternal = Collections.synchronizedSortedSet(new TreeSet());
    private final Set<CompositeContextListener> listeners = new CopyOnWriteArraySet<CompositeContextListener>();

    public CompositeRenderContextImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompositeRenderContextImpl(CompositeRenderContextImpl impl) {
        super(impl);
        assert (CompositeRenderContextImpl.assertNoSelfReference(this, this, impl.contextsInternal));
        Collection<RenderContext> collection = impl.contextsInternal;
        synchronized (collection) {
            for (RenderContext context : impl.contextsInternal) {
                if (context == impl) {
                    this.contextsInternal.add(this);
                    continue;
                }
                this.contextsInternal.add(context.copy());
            }
        }
    }

    @Override
    public boolean isVisible() {
        if (this.getLayer() != null && this.getLayer().isVisible()) {
            return true;
        }
        for (IRenderContext context : this.getContexts()) {
            if (context == this || !context.isVisible()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Layer> getLayersInternal() {
        ArrayList<Layer> list = new ArrayList<Layer>();
        Collection<RenderContext> collection = this.contextsInternal;
        synchronized (collection) {
            for (RenderContext context : this.contextsInternal) {
                list.add(context.getLayerInternal());
            }
        }
        return Collections.unmodifiableList(list);
    }

    public List getLayers() {
        return this.getLayersInternal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getContexts() {
        Collection<RenderContext> collection = this.contextsInternal;
        synchronized (collection) {
            return Collections.unmodifiableList(new ArrayList<RenderContext>(this.contextsInternal));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        if (this.contextsInternal.isEmpty()) {
            return super.toString();
        }
        StringBuffer buffer = new StringBuffer("{CompositeContext: ");
        Collection<RenderContext> collection = this.contextsInternal;
        synchronized (collection) {
            for (RenderContext context : this.contextsInternal) {
                if (context == this) {
                    buffer.append("\n -" + super.toString());
                    continue;
                }
                buffer.append("\n -" + context.toString());
            }
            buffer.append("\n}");
            return buffer.length() == 0 ? super.toString() : buffer.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setStatus(int status) {
        if (this.getContexts().size() == 0) {
            super.setStatus(status);
            return;
        }
        Collection<RenderContext> collection = this.contextsInternal;
        synchronized (collection) {
            for (RenderContext context : this.contextsInternal) {
                if (context != this) {
                    context.setStatus(status);
                    continue;
                }
                super.setStatus(status);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setStatusMessage(String message) {
        if (this.getContexts().size() == 0) {
            super.setStatusMessage(message);
            return;
        }
        Collection<RenderContext> collection = this.contextsInternal;
        synchronized (collection) {
            for (RenderContext context : this.contextsInternal) {
                if (context != this) {
                    context.setStatusMessage(message);
                    continue;
                }
                super.setStatusMessage(message);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        super.dispose();
        Collection<RenderContext> collection = this.contextsInternal;
        synchronized (collection) {
            for (RenderContext context : this.contextsInternal) {
                if (context == this) continue;
                ((RenderContextImpl)context).dispose();
            }
        }
    }

    @Override
    public void addListener(CompositeContextListener contextListener) {
        this.listeners.add(contextListener);
    }

    @Override
    public void removeListener(CompositeContextListener contextListener) {
        this.listeners.remove(contextListener);
    }

    private void notifyListeners(List<RenderContext> contexts, boolean added) {
        for (CompositeContextListener l : this.listeners) {
            l.notifyChanged(this, contexts, added);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        ArrayList<RenderContext> contexts;
        Collection<RenderContext> collection = this.contextsInternal;
        synchronized (collection) {
            contexts = new ArrayList<RenderContext>(this.contextsInternal);
        }
        this.contextsInternal.clear();
        if (!contexts.isEmpty()) {
            this.notifyListeners(contexts, false);
        }
    }

    @Override
    public void addContexts(Collection<? extends RenderContext> contexts) {
        if (contexts.isEmpty()) {
            return;
        }
        assert (CompositeRenderContextImpl.assertNoSelfReference(this, this, contexts));
        this.contextsInternal.addAll(contexts);
        this.notifyListeners(new ArrayList<RenderContext>(contexts), true);
    }

    public static boolean assertNoSelfReference(IRenderContext parent, IRenderContext reference, Collection<? extends IRenderContext> contexts) {
        for (IRenderContext iRenderContext : contexts) {
            if (iRenderContext == parent) continue;
            if (iRenderContext == reference) {
                return false;
            }
            if (!(iRenderContext instanceof ICompositeRenderContext)) continue;
            ICompositeRenderContext comp = (ICompositeRenderContext)iRenderContext;
            List<IRenderContext> children = comp.getContexts();
            for (IRenderContext context2 : children) {
                if (context2 == null) {
                    return false;
                }
                if (!(context2 instanceof ICompositeRenderContext) || CompositeRenderContextImpl.assertNoSelfReference(context2, reference, ((ICompositeRenderContext)context2).getContexts())) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void removeContexts(Collection<? extends RenderContext> contexts) {
        if (contexts.isEmpty()) {
            return;
        }
        this.contextsInternal.removeAll(contexts);
        this.notifyListeners(new ArrayList<RenderContext>(contexts), false);
    }

    @Override
    public CompositeRenderContextImpl copy() {
        return new CompositeRenderContextImpl(this);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        for (RenderContext context : this.contextsInternal) {
            result = context == this ? 31 * result + super.hashCode() : 31 * result + context.hashCode();
        }
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof CompositeRenderContextImpl)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CompositeRenderContextImpl other = (CompositeRenderContextImpl)obj;
        return !(this.contextsInternal == null ? other.contextsInternal != null : !this.contextsEqual(other));
    }

    @Override
    public int compareTo(RenderContext o) {
        if (o == this) {
            return 0;
        }
        int result = super.compareTo(o);
        if (result == 0) {
            if (o instanceof ICompositeRenderContext) {
                ICompositeRenderContext comp = (ICompositeRenderContext)((Object)o);
                if (this.contextsEqual(comp)) {
                    return 0;
                }
                return -1;
            }
            return -1;
        }
        return result;
    }

    private boolean contextsEqual(ICompositeRenderContext o) {
        if (o.getContexts().size() != this.contextsInternal.size()) {
            return false;
        }
        Iterator iter1 = this.getContexts().iterator();
        Iterator<IRenderContext> iter2 = o.getContexts().iterator();
        while (iter1.hasNext()) {
            IRenderContext o1 = (IRenderContext)iter1.next();
            IRenderContext o2 = iter2.next();
            if (o1 == this) {
                if (o2 == o) continue;
                return false;
            }
            if (o1.equals(o2)) continue;
            return false;
        }
        return true;
    }
}

