/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.internal.render;

import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.internal.Layer;
import net.refractions.udig.project.internal.LayerDecorator;
import net.refractions.udig.project.internal.Map;
import net.refractions.udig.project.internal.ProjectFactory;
import net.refractions.udig.project.internal.StyleBlackboard;
import net.refractions.udig.project.internal.impl.LayerImpl;
import net.refractions.udig.project.internal.render.SelectionStyleContent;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.geotools.styling.Style;
import org.opengis.filter.Filter;

public class SelectionLayer
extends LayerDecorator {
    private StyleBlackboard styleBlackboard = ProjectFactory.eINSTANCE.createStyleBlackboard();
    private String message;

    public SelectionLayer(Layer layer) {
        super(layer);
    }

    @Override
    public boolean isVisible() {
        return this.layer.isVisible() && !Filter.EXCLUDE.equals(this.getFilter());
    }

    @Override
    public StyleBlackboard getStyleBlackboard() {
        if (this.styleBlackboard == null) {
            this.styleBlackboard = ProjectFactory.eINSTANCE.createStyleBlackboard();
        }
        this.styleBlackboard.clear();
        Style style = null;
        if (this.layer.getStyleBlackboard() != null) {
            style = (Style)this.layer.getStyleBlackboard().get("net.refractions.udig.project.selectionStyle");
        }
        if (style == null) {
            style = SelectionStyleContent.createDefaultStyle(this.layer);
            style.getFeatureTypeStyles()[0].setFeatureTypeName("Feature");
        }
        if (style == null) {
            return this.styleBlackboard;
        }
        this.styleBlackboard.put("net.refractions.udig.project.selectionStyle", style);
        return this.styleBlackboard;
    }

    @Override
    public void setStyleBlackboard(StyleBlackboard value) {
        this.styleBlackboard = value;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, (Object)value, (Object)value));
        }
    }

    @Override
    public int getZorder() {
        Map mapInternal = this.getMapInternal();
        if (mapInternal == null) {
            return Integer.MAX_VALUE;
        }
        return super.getZorder() + mapInternal.getLayersInternal().size();
    }

    @Override
    public int compareTo(ILayer layer2) {
        return LayerImpl.doComparison(this, layer2);
    }

    @Override
    public void setStatus(int status) {
        if (status == 1) {
            return;
        }
        this.layer.setStatus(status);
    }

    @Override
    public void setStatusMessage(String message) {
        this.message = message;
    }

    @Override
    public String getStatusMessage() {
        return this.message;
    }
}

