/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.internal.interceptor;

import java.util.HashMap;
import java.util.Map;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.IResourceCachingInterceptor;
import org.geotools.styling.Style;
import org.opengis.coverage.grid.GridCoverage;

public class ResourceCacheInterceptor
implements IResourceCachingInterceptor {
    public static final String ID = "net.refractions.udig.project.caching";
    private Map<Class, Object> resources = new HashMap<Class, Object>();

    private <T> void registerClasses(Class<T> clazz, Object obj) {
        if (obj instanceof Style || obj instanceof GridCoverage) {
            return;
        }
        if (clazz.getSuperclass() != null && clazz.getSuperclass() != Object.class) {
            this.registerClasses(clazz.getSuperclass(), obj);
        }
        int i = 0;
        while (i < clazz.getInterfaces().length) {
            this.registerClasses(clazz.getInterfaces()[i], obj);
            ++i;
        }
        this.resources.put(clazz, obj);
    }

    @Override
    public <T> T get(ILayer layer, Class<T> requestedType) {
        return (T)this.resources.get(requestedType);
    }

    @Override
    public <T> boolean isCached(ILayer layer, IGeoResource resource, Class<T> requestedType) {
        return this.resources.containsKey(requestedType);
    }

    @Override
    public <T> void put(ILayer layer, T resource, Class<T> requestedType) {
        if (resource != null) {
            this.registerClasses(resource.getClass(), resource);
        }
    }
}

