/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.internal.interceptor;

import net.refractions.udig.project.interceptor.FeatureInterceptor;
import org.opengis.feature.Feature;
import org.opengis.feature.Property;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.PropertyDescriptor;

public class DefaultValueFeatureInterceptor
implements FeatureInterceptor {
    @Override
    public void run(Feature feature) {
        if (feature instanceof SimpleFeature) {
            SimpleFeatureType type = (SimpleFeatureType)feature.getType();
            SimpleFeature simpleFeature = (SimpleFeature)feature;
            int i = 0;
            while (i < type.getAttributeCount()) {
                if (simpleFeature.getAttribute(i) == null) {
                    Object value = this.toDefaultValue((PropertyDescriptor)type.getDescriptor(i));
                    simpleFeature.setAttribute(i, value);
                }
                ++i;
            }
        } else {
            for (Property property : feature.getProperties()) {
                Object defaultValue = this.toDefaultValue(property.getDescriptor());
                property.setValue(defaultValue);
            }
        }
    }

    private Object toDefaultValue(PropertyDescriptor descriptor) {
        AttributeDescriptor attributeDescriptor;
        Object value = null;
        if (descriptor instanceof AttributeDescriptor && (value = (attributeDescriptor = (AttributeDescriptor)descriptor).getDefaultValue()) != null) {
            return value;
        }
        Class type = descriptor.getType().getBinding();
        if (Boolean.class.isAssignableFrom(type) || Boolean.TYPE.isAssignableFrom(type)) {
            return Boolean.FALSE;
        }
        if (String.class.isAssignableFrom(type)) {
            return "";
        }
        if (Integer.class.isAssignableFrom(type)) {
            return 0;
        }
        if (Double.class.isAssignableFrom(type)) {
            return 0.0;
        }
        if (Float.class.isAssignableFrom(type)) {
            return Float.valueOf(0.0f);
        }
        return null;
    }
}

