/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.internal.impl;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.io.WKTWriter;
import java.awt.RenderingHints;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.Interaction;
import net.refractions.udig.project.LayerEvent;
import net.refractions.udig.project.internal.EditManager;
import net.refractions.udig.project.internal.Messages;
import net.refractions.udig.project.internal.ProjectPlugin;
import net.refractions.udig.project.internal.impl.LayerImpl;
import net.refractions.udig.project.internal.impl.UDIGStore;
import org.geotools.data.DataStore;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureEvent;
import org.geotools.data.FeatureListener;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureStore;
import org.geotools.data.Query;
import org.geotools.data.QueryCapabilities;
import org.geotools.data.ResourceInfo;
import org.geotools.data.Transaction;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureStore;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.Id;
import org.opengis.filter.identity.FeatureId;

public class UDIGSimpleFeatureStore
implements SimpleFeatureStore,
UDIGStore {
    SimpleFeatureStore wrapped;
    ILayer layer;

    public UDIGSimpleFeatureStore(SimpleFeatureStore featureStore, ILayer layer) {
        this.wrapped = featureStore;
        this.layer = layer;
    }

    public UDIGSimpleFeatureStore(FeatureStore<?, ?> featureStore, ILayer layer) {
        this.wrapped = DataUtilities.simple(featureStore);
        this.layer = layer;
    }

    public Name getName() {
        return this.wrapped.getName();
    }

    public ResourceInfo getInfo() {
        return this.wrapped.getInfo();
    }

    public void removeFeatures(Filter filter) throws IOException {
        this.setTransactionInternal();
        this.wrapped.removeFeatures(filter);
        this.fireLayerEditEvent(FeatureEvent.Type.REMOVED, null, filter);
    }

    @Deprecated
    public void modifyFeatures(AttributeDescriptor[] descriptors, Object[] values, Filter filter) throws IOException {
        this.setTransactionInternal();
        this.wrapped.modifyFeatures(descriptors, values, filter);
        this.fireLayerEditEvent(FeatureEvent.Type.CHANGED, null, filter);
    }

    public void modifyFeatures(Name[] names, Object[] values, Filter filter) throws IOException {
        this.setTransactionInternal();
        this.wrapped.modifyFeatures(names, values, filter);
        this.fireLayerEditEvent(FeatureEvent.Type.CHANGED, null, filter);
    }

    public void modifyFeatures(Name name, Object value, Filter filter) throws IOException {
        this.setTransactionInternal();
        this.wrapped.modifyFeatures(name, value, filter);
        this.fireLayerEditEvent(FeatureEvent.Type.CHANGED, null, filter);
    }

    public void modifyFeatures(String name, Object value, Filter filter) throws IOException {
        this.setTransactionInternal();
        this.wrapped.modifyFeatures(name, value, filter);
        this.fireLayerEditEvent(FeatureEvent.Type.CHANGED, null, filter);
    }

    public void modifyFeatures(String[] names, Object[] values, Filter filter) throws IOException {
        this.setTransactionInternal();
        this.wrapped.modifyFeatures(names, values, filter);
        this.fireLayerEditEvent(FeatureEvent.Type.CHANGED, null, filter);
    }

    @Deprecated
    public void modifyFeatures(AttributeDescriptor attribute, Object value, Filter selectFilter) throws IOException {
        Geometry geom;
        this.setTransactionInternal();
        if (value instanceof Geometry && !(geom = (Geometry)value).isValid()) {
            WKTWriter writer = new WKTWriter();
            String wkt = writer.write(geom);
            String where = selectFilter.toString();
            if (selectFilter instanceof Id) {
                Id id = (Id)selectFilter;
                where = id.getIDs().toString();
            }
            String msg = "Modify fetures (WHERE " + where + ") failed with invalid geometry:" + wkt;
            ProjectPlugin.log(msg);
            throw new IOException(msg);
        }
        this.wrapped.modifyFeatures(attribute, value, selectFilter);
        this.fireLayerEditEvent(FeatureEvent.Type.CHANGED, null, selectFilter);
    }

    public void fireLayerEditEvent(FeatureEvent.Type type, ReferencedEnvelope bounds, Filter filter) {
        if (type == null) {
            type = FeatureEvent.Type.CHANGED;
        }
        FeatureEvent featureEvent = new FeatureEvent((Object)this, type, bounds, filter);
        ((LayerImpl)this.layer).fireLayerChange(new LayerEvent(this.layer, LayerEvent.EventType.EDIT_EVENT, null, featureEvent));
        this.layer.refresh((Envelope)bounds);
    }

    public void setFeatures(FeatureReader<SimpleFeatureType, SimpleFeature> features) throws IOException {
        this.setTransactionInternal();
        this.wrapped.setFeatures(features);
        this.fireLayerEditEvent(FeatureEvent.Type.CHANGED, null, (Filter)Filter.INCLUDE);
    }

    public void setTransaction(Transaction transaction) {
        throw new IllegalArgumentException(String.valueOf(Messages.UDIGFeatureStore_0) + Messages.UDIGFeatureStore_1);
    }

    @Override
    public void editComplete() {
        this.wrapped.setTransaction(Transaction.AUTO_COMMIT);
    }

    private void setTransactionInternal() {
        if (!this.layer.getInteraction(Interaction.EDIT)) {
            String message = "Attempted to open a transaction on a non-editable layer (Aborted)";
            IllegalStateException illegalStateException = new IllegalStateException(message);
            ProjectPlugin.log(message, illegalStateException);
            throw illegalStateException;
        }
        EditManager editManager = (EditManager)this.layer.getMap().getEditManager();
        Transaction transaction = editManager.getTransaction();
        if (this.wrapped.getTransaction() == Transaction.AUTO_COMMIT) {
            this.wrapped.setTransaction(transaction);
        } else if (this.wrapped.getTransaction() != transaction) {
            String msg = "Layer transaction already set " + this.wrapped.getTransaction();
            IllegalStateException illegalStateException = new IllegalStateException(msg);
            ProjectPlugin.log(msg, illegalStateException);
            throw illegalStateException;
        }
    }

    @Override
    public void startTransaction() {
        if (this.wrapped.getTransaction() == Transaction.AUTO_COMMIT) {
            Transaction transaction = ((EditManager)this.layer.getMap().getEditManager()).getTransaction();
            this.wrapped.setTransaction(transaction);
        }
    }

    public Transaction getTransaction() {
        return this.wrapped.getTransaction();
    }

    public DataStore getDataStore() {
        return (DataStore)this.wrapped.getDataStore();
    }

    public void addFeatureListener(FeatureListener listener) {
        this.wrapped.addFeatureListener(listener);
    }

    public void removeFeatureListener(FeatureListener listener) {
        this.wrapped.removeFeatureListener(listener);
    }

    public SimpleFeatureCollection getFeatures(Query query) throws IOException {
        return this.wrapped.getFeatures(query);
    }

    public SimpleFeatureCollection getFeatures(Filter filter) throws IOException {
        return this.wrapped.getFeatures(filter);
    }

    public SimpleFeatureCollection getFeatures() throws IOException {
        return this.wrapped.getFeatures();
    }

    public SimpleFeatureType getSchema() {
        return (SimpleFeatureType)this.wrapped.getSchema();
    }

    public ReferencedEnvelope getBounds() throws IOException {
        return this.wrapped.getBounds();
    }

    public ReferencedEnvelope getBounds(Query query) throws IOException {
        return this.wrapped.getBounds(query);
    }

    public int getCount(Query query) throws IOException {
        return this.wrapped.getCount(query);
    }

    public List<FeatureId> addFeatures(FeatureCollection<SimpleFeatureType, SimpleFeature> features) throws IOException {
        this.setTransactionInternal();
        List ids = this.wrapped.addFeatures(features);
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2();
        ff.id(new HashSet(ids));
        this.fireLayerEditEvent(FeatureEvent.Type.CHANGED, null, (Filter)Filter.INCLUDE);
        return ids;
    }

    @Override
    public boolean sameSource(Object source) {
        return source == this.wrapped || source == this;
    }

    public SimpleFeatureStore wrapped() {
        return this.wrapped;
    }

    public Set<RenderingHints.Key> getSupportedHints() {
        return this.wrapped.getSupportedHints();
    }

    public QueryCapabilities getQueryCapabilities() {
        return this.wrapped.getQueryCapabilities();
    }
}

