/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.internal.impl;

import com.vividsolutions.jts.geom.Envelope;
import java.awt.Color;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.locks.Lock;
import net.refractions.udig.project.IBlackboard;
import net.refractions.udig.project.IEditManager;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.ILegendItem;
import net.refractions.udig.project.IMapCompositionListener;
import net.refractions.udig.project.IMapListener;
import net.refractions.udig.project.IProject;
import net.refractions.udig.project.command.CommandListener;
import net.refractions.udig.project.command.CommandManager;
import net.refractions.udig.project.command.CommandStack;
import net.refractions.udig.project.command.EditCommand;
import net.refractions.udig.project.command.MapCommand;
import net.refractions.udig.project.command.NavCommand;
import net.refractions.udig.project.command.NavCommandStack;
import net.refractions.udig.project.internal.Blackboard;
import net.refractions.udig.project.internal.ContextModel;
import net.refractions.udig.project.internal.ContextModelListenerAdapter;
import net.refractions.udig.project.internal.EditManager;
import net.refractions.udig.project.internal.Layer;
import net.refractions.udig.project.internal.LayerFactory;
import net.refractions.udig.project.internal.Map;
import net.refractions.udig.project.internal.Messages;
import net.refractions.udig.project.internal.Project;
import net.refractions.udig.project.internal.ProjectFactory;
import net.refractions.udig.project.internal.ProjectPackage;
import net.refractions.udig.project.internal.ProjectPlugin;
import net.refractions.udig.project.internal.commands.DefaultErrorHandler;
import net.refractions.udig.project.internal.impl.ContextModelImpl;
import net.refractions.udig.project.internal.impl.EMFCompositionEventToMapCompositionEventListener;
import net.refractions.udig.project.internal.impl.EMFEventListenerToMapEvents;
import net.refractions.udig.project.internal.impl.LayersList2;
import net.refractions.udig.project.internal.render.RenderFactory;
import net.refractions.udig.project.internal.render.RenderManager;
import net.refractions.udig.project.internal.render.ViewportModel;
import net.refractions.udig.project.render.IRenderManager;
import net.refractions.udig.project.render.IViewportModel;
import net.refractions.udig.ui.PlatformGIS;
import net.refractions.udig.ui.ProgressManager;
import net.refractions.udig.ui.UDIGDisplaySafeLock;
import net.refractions.udig.ui.palette.ColourScheme;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.model.WorkbenchAdapter;
import org.geotools.brewer.color.BrewerPalette;
import org.geotools.data.FeatureSource;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.filter.visitor.DuplicatingFilterVisitor;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.And;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.Not;
import org.opengis.filter.Or;
import org.opengis.filter.spatial.SpatialOperator;
import org.opengis.geometry.Geometry;
import org.opengis.geometry.coordinate.Polygon;
import org.opengis.metadata.extent.BoundingPolygon;
import org.opengis.metadata.extent.Extent;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.metadata.extent.GeographicExtent;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;

public class MapImpl
extends EObjectImpl
implements Map {
    protected static final String NAME_EDEFAULT = "";
    protected volatile String name = "";
    protected volatile Project projectInternal = null;
    protected volatile ContextModel contextModel = null;
    protected static final String ABSTRACT_EDEFAULT = "";
    protected volatile String abstract_ = "";
    protected static final NavCommandStack NAV_COMMAND_STACK_EDEFAULT = null;
    protected static final CommandStack COMMAND_STACK_EDEFAULT = null;
    protected volatile LayerFactory layerFactory = null;
    protected volatile ViewportModel viewportModelInternal = null;
    protected final BrewerPalette COLOR_PALETTE_EDEFAULT = null;
    protected volatile BrewerPalette colorPalette = PlatformGIS.getColorBrewer().getPalette(ProjectPlugin.getPlugin().getPreferenceStore().getString("defaultPalette"));
    protected volatile EditManager editManagerInternal = null;
    protected volatile RenderManager renderManagerInternal = null;
    protected static final ColourScheme COLOUR_SCHEME_EDEFAULT = null;
    private static final List<Layer> EMPTY_LIST = Collections.emptyList();
    protected volatile ColourScheme colourScheme = ColourScheme.getDefault((BrewerPalette)this.getColorPalette());
    protected volatile Blackboard blackBoardInternal = null;
    protected EList<ILegendItem> legend;
    private volatile CommandManager commandManager;
    private volatile CommandManager navCommandManager;
    private final Lock lock = new UDIGDisplaySafeLock();
    final ContextModelListenerAdapter contextModelListener = new EMFCompositionEventToMapCompositionEventListener(this);
    Adapter adapter = new AdapterImpl(){

        public void notifyChanged(Notification msg) {
            switch (msg.getFeatureID(RenderManager.class)) {
                case 3: {
                    if (msg.getEventType() != 3 || MapImpl.this.getViewportModel() == msg.getNewValue()) break;
                    MapImpl.this.setViewportModelInternal((ViewportModel)msg.getNewValue());
                }
            }
            switch (msg.getFeatureID(ViewportModel.class)) {
                case 8: {
                    if (msg.getEventType() != 3 || MapImpl.this.getRenderManager() == msg.getNewValue()) break;
                    MapImpl.this.setRenderManagerInternal((RenderManager)msg.getNewValue());
                }
            }
        }
    };
    CopyOnWriteArraySet<IMapListener> mapListeners = new CopyOnWriteArraySet();
    CopyOnWriteArraySet<IMapCompositionListener> compositionListeners = new CopyOnWriteArraySet();

    public MapImpl() {
        this.addMapListenerAdapter();
        this.setContextModel(new ContextModelImpl());
    }

    private void addMapListenerAdapter() {
        this.eAdapters().add((Object)new EMFEventListenerToMapEvents(this));
    }

    protected EClass eStaticClass() {
        return ProjectPackage.Literals.MAP;
    }

    @Override
    public Project getProjectInternal() {
        Project genResult = this.getProjectInternalGen();
        if (genResult == null) {
            EObject parent = this.eContainer();
            while (parent != null) {
                if (parent instanceof Project) {
                    return (Project)parent;
                }
                parent = parent.eContainer();
            }
        }
        return genResult;
    }

    public Project getProjectInternalGen() {
        if (this.projectInternal != null && this.projectInternal.eIsProxy()) {
            InternalEObject oldProjectInternal = (InternalEObject)this.projectInternal;
            this.projectInternal = (Project)this.eResolveProxy(oldProjectInternal);
            if (this.projectInternal != oldProjectInternal && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 1, (Object)oldProjectInternal, (Object)this.projectInternal));
            }
        }
        return this.projectInternal;
    }

    public Project basicGetProjectInternal() {
        return this.projectInternal;
    }

    public NotificationChain basicSetProjectInternal(Project newProjectInternal, NotificationChain msgs) {
        Project oldProjectInternal = this.projectInternal;
        this.projectInternal = newProjectInternal;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 1, (Object)oldProjectInternal, (Object)newProjectInternal);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public void setProjectInternal(Project newProjectInternal) {
        if (newProjectInternal != this.projectInternal) {
            NotificationChain msgs = null;
            if (this.projectInternal != null) {
                msgs = ((InternalEObject)this.projectInternal).eInverseRemove((InternalEObject)this, 1, Project.class, msgs);
            }
            if (newProjectInternal != null) {
                msgs = ((InternalEObject)newProjectInternal).eInverseAdd((InternalEObject)this, 1, Project.class, msgs);
            }
            if ((msgs = this.basicSetProjectInternal(newProjectInternal, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)newProjectInternal, (Object)newProjectInternal));
        }
    }

    @Override
    public ContextModel getContextModel() {
        if (this.contextModel == null) {
            this.lock.lock();
            try {
                if (this.contextModel == null) {
                    this.setContextModel(ProjectFactory.eINSTANCE.createContextModel());
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.contextModel;
    }

    public NotificationChain basicSetContextModel(ContextModel newContextModel, NotificationChain msgs) {
        ContextModel oldContextModel = this.contextModel;
        this.contextModel = newContextModel;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 2, (Object)oldContextModel, (Object)newContextModel);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public void setContextModel(ContextModel newContextModel) {
        if (this.contextModel != null) {
            this.contextModel.eAdapters().remove((Object)this.contextModelListener);
        }
        if (newContextModel != null) {
            newContextModel.eAdapters().add((Object)this.contextModelListener);
        }
        this.setContextModelGen(newContextModel);
    }

    public void setContextModelGen(ContextModel newContextModel) {
        if (newContextModel != this.contextModel) {
            NotificationChain msgs = null;
            if (this.contextModel != null) {
                msgs = ((InternalEObject)this.contextModel).eInverseRemove((InternalEObject)this, 1, ContextModel.class, msgs);
            }
            if (newContextModel != null) {
                msgs = ((InternalEObject)newContextModel).eInverseAdd((InternalEObject)this, 1, ContextModel.class, msgs);
            }
            if ((msgs = this.basicSetContextModel(newContextModel, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, (Object)newContextModel, (Object)newContextModel));
        }
    }

    @Override
    public ViewportModel getViewportModelInternal() {
        if (this.viewportModelInternal == null) {
            this.setViewportModelInternalGen(RenderFactory.eINSTANCE.createViewportModel());
        }
        return this.viewportModelInternal;
    }

    public NotificationChain basicSetViewportModelInternal(ViewportModel newViewportModelInternal, NotificationChain msgs) {
        ViewportModel oldViewportModelInternal = this.viewportModelInternal;
        this.viewportModelInternal = newViewportModelInternal;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 7, (Object)oldViewportModelInternal, (Object)newViewportModelInternal);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public void setViewportModelInternal(ViewportModel newViewportModelInternal) {
        this.setViewportModelInternalGen(newViewportModelInternal);
        if (this.getRenderManager() != null) {
            this.getRenderManagerInternal().setViewportModelInternal(newViewportModelInternal);
        }
        newViewportModelInternal.eAdapters().add((Object)this.adapter);
    }

    public void setViewportModelInternalGen(ViewportModel newViewportModelInternal) {
        if (newViewportModelInternal != this.viewportModelInternal) {
            NotificationChain msgs = null;
            if (this.viewportModelInternal != null) {
                msgs = ((InternalEObject)this.viewportModelInternal).eInverseRemove((InternalEObject)this, 7, ViewportModel.class, msgs);
            }
            if (newViewportModelInternal != null) {
                msgs = ((InternalEObject)newViewportModelInternal).eInverseAdd((InternalEObject)this, 7, ViewportModel.class, msgs);
            }
            if ((msgs = this.basicSetViewportModelInternal(newViewportModelInternal, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 7, (Object)newViewportModelInternal, (Object)newViewportModelInternal));
        }
    }

    @Override
    public BrewerPalette getColorPalette() {
        if (this.colorPalette == null) {
            String defaultPalette = ProjectPlugin.getPlugin().getPreferenceStore().getString("defaultPalette");
            if (defaultPalette == null || !PlatformGIS.getColorBrewer().hasPalette(defaultPalette)) {
                defaultPalette = "Dark2";
            }
            this.colorPalette = PlatformGIS.getColorBrewer().getPalette(defaultPalette);
        }
        return this.colorPalette;
    }

    @Override
    public void setColorPalette(BrewerPalette newColorPalette) {
        BrewerPalette oldColorPalette = this.colorPalette;
        this.colorPalette = newColorPalette;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 8, (Object)oldColorPalette, (Object)this.colorPalette));
        }
    }

    @Override
    public String getAbstract() {
        return this.abstract_;
    }

    @Override
    public void setAbstract(String newAbstract) {
        String oldAbstract = this.abstract_;
        this.abstract_ = newAbstract;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, (Object)oldAbstract, (Object)this.abstract_));
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String newName) {
        String oldName = this.name;
        this.name = newName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, (Object)oldName, (Object)this.name));
        }
    }

    @Override
    public URI getID() {
        if (this.eResource() == null) {
            return URI.createFileURI((String)this.getName());
        }
        return this.eResource().getURI();
    }

    @Override
    public ReferencedEnvelope getBounds(IProgressMonitor monitor) {
        if (this.getLayersInternal() != null) {
            ReferencedEnvelope bounds = new ReferencedEnvelope(this.getViewportModel().getCRS());
            bounds.setToNull();
            ArrayList<Layer> layers = new ArrayList<Layer>(this.getLayersInternal());
            for (Layer layer : layers) {
                ReferencedEnvelope bbox = layer.getBounds(ProgressManager.instance().get(new Object[0]), this.getViewportModel().getCRS());
                if (bbox.isNull()) continue;
                if (bounds.isNull()) {
                    bounds.init((Envelope)bbox);
                    continue;
                }
                bounds.expandToInclude((Envelope)bbox);
            }
            if (this.getLayersInternal() != EMPTY_LIST && bounds.isNull()) {
                return this.getDefaultBounds();
            }
            return bounds;
        }
        return this.getDefaultBounds();
    }

    private ReferencedEnvelope getDefaultBounds() {
        Extent extent;
        ReferencedEnvelope env;
        if (this.getViewportModel().getCRS().getDomainOfValidity() != null && (env = MapImpl.toReferencedEnvelope(extent = this.getViewportModel().getCRS().getDomainOfValidity(), this.getViewportModel().getCRS())) != null) {
            ProjectPlugin.log("MapImpl#getDefaultBounds(): Returning valid area of " + env.getCoordinateReferenceSystem().getName().toString());
            return env;
        }
        ProjectPlugin.log("MapImpl#getDefaultBounds(): Returning Default bounds (entire world)");
        return new ReferencedEnvelope(new Envelope(-180.0, 180.0, -90.0, 90.0), (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
    }

    public static ReferencedEnvelope toReferencedEnvelope(Extent extent, CoordinateReferenceSystem crs) {
        if (extent == null) {
            return null;
        }
        Collection elems = extent.getGeographicElements();
        for (GeographicExtent extent2 : elems) {
            BoundingPolygon boundingpoly;
            Collection polygons;
            Iterator iterator;
            ReferencedEnvelope env = null;
            if (extent2 instanceof GeographicBoundingBox) {
                GeographicBoundingBox box = (GeographicBoundingBox)extent2;
                env = new ReferencedEnvelope(box.getWestBoundLongitude(), box.getEastBoundLongitude(), box.getSouthBoundLatitude(), box.getNorthBoundLatitude(), (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
            } else if (extent2 instanceof BoundingPolygon && (iterator = (polygons = (boundingpoly = (BoundingPolygon)extent2).getPolygons()).iterator()).hasNext()) {
                Geometry geometry = (Geometry)iterator.next();
                Polygon poly = (Polygon)geometry;
                org.opengis.geometry.Envelope envelope = poly.getBoundary().getEnvelope();
                env = new ReferencedEnvelope(envelope.getMinimum(0), envelope.getMaximum(0), envelope.getMinimum(1), envelope.getMaximum(1), envelope.getLowerCorner().getCoordinateReferenceSystem());
            }
            if (env == null) continue;
            try {
                env = env.transform(crs, true);
            }
            catch (TransformException e) {
                ProjectPlugin.log("error transforming " + env + " to " + crs.getName().toString(), e);
            }
            catch (FactoryException e) {
                ProjectPlugin.log("error transforming " + env + " to " + crs.getName().toString(), e);
            }
            return env;
        }
        return null;
    }

    @Override
    public double getAspectRatio(IProgressMonitor monitor) {
        ReferencedEnvelope bounds = this.getBounds(monitor);
        return bounds.getWidth() / bounds.getHeight();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NavCommandStack getNavCommandStack() {
        Class<CommandManager> clazz = CommandManager.class;
        synchronized (CommandManager.class) {
            if (this.navCommandManager == null) {
                this.navCommandManager = new CommandManager(Messages.MapImpl_NavigationCommandStack, new DefaultErrorHandler(), new MapCommandListener());
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.navCommandManager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CommandStack getCommandStack() {
        Class<CommandManager> clazz = CommandManager.class;
        synchronized (CommandManager.class) {
            if (this.commandManager == null) {
                this.commandManager = new CommandManager(Messages.MapImpl_CommandStack, new DefaultErrorHandler(), new MapCommandListener());
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.commandManager;
        }
    }

    @Override
    public LayerFactory getLayerFactory() {
        if (this.layerFactory == null) {
            this.setLayerFactory(ProjectFactory.eINSTANCE.createLayerFactory());
        }
        return this.layerFactory;
    }

    public NotificationChain basicSetLayerFactory(LayerFactory newLayerFactory, NotificationChain msgs) {
        LayerFactory oldLayerFactory = this.layerFactory;
        this.layerFactory = newLayerFactory;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 6, (Object)oldLayerFactory, (Object)newLayerFactory);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public void setLayerFactory(LayerFactory newLayerFactory) {
        if (newLayerFactory != this.layerFactory) {
            NotificationChain msgs = null;
            if (this.layerFactory != null) {
                msgs = ((InternalEObject)this.layerFactory).eInverseRemove((InternalEObject)this, 0, LayerFactory.class, msgs);
            }
            if (newLayerFactory != null) {
                msgs = ((InternalEObject)newLayerFactory).eInverseAdd((InternalEObject)this, 0, LayerFactory.class, msgs);
            }
            if ((msgs = this.basicSetLayerFactory(newLayerFactory, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 6, (Object)newLayerFactory, (Object)newLayerFactory));
        }
    }

    private void sendCommand(MapCommand command, boolean async) {
        this.sendCommandInternal(command, async);
    }

    public void sendCommandInternal(MapCommand command, boolean async) {
        this.getCommandStack();
        command.setMap(this);
        this.commandManager.execute(command, async);
    }

    private void sendCommand(EditCommand command, boolean async) {
        this.sendCommandInternal(command, async);
    }

    private void sendCommand(NavCommand command, boolean async) {
        this.getNavCommandStack();
        command.setMap(this);
        command.setViewportModel(this.getViewportModelInternal());
        this.navCommandManager.execute(command, async);
    }

    private void notifyCommandStackChange() {
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 5, null, (Object)this.commandManager));
        }
    }

    private void notifyNavCommandStackChange() {
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 4, null, (Object)this.commandManager));
        }
    }

    public void notifyNavCommandDone() {
        this.notifyNavCommandStackChange();
    }

    public void notifyCommandDone() {
        this.notifyCommandStackChange();
    }

    void notifyBatchNotification(int featureID, int eventType) {
        if (this.eNotificationRequired()) {
            BatchNotification notifications = new BatchNotification(this, eventType, 15);
            for (Layer layer : this.getContextModel().getLayers()) {
                EStructuralFeature feature = layer.eClass().getEStructuralFeature(featureID);
                ENotificationImpl notification = new ENotificationImpl((InternalEObject)layer, eventType, featureID, null, layer.eGet(feature));
                notifications.add((Notification)notification);
            }
            this.eNotify((Notification)notifications);
        }
    }

    @Override
    public void redo() {
        if (this.commandManager == null || !this.commandManager.hasForwardHistory()) {
            return;
        }
        this.commandManager.redo(true);
        this.notifyCommandStackChange();
    }

    @Override
    public void undo() {
        if (this.commandManager == null || !this.commandManager.hasBackHistory()) {
            return;
        }
        this.commandManager.undo(true);
        this.notifyCommandStackChange();
    }

    @Override
    public void backwardHistory() {
        if (this.navCommandManager == null || !this.navCommandManager.hasBackHistory()) {
            return;
        }
        this.navCommandManager.undo(true);
    }

    @Override
    public void forwardHistory() {
        if (this.navCommandManager == null || !this.navCommandManager.hasForwardHistory()) {
            return;
        }
        this.navCommandManager.redo(true);
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 1: {
                if (this.projectInternal != null) {
                    msgs = ((InternalEObject)this.projectInternal).eInverseRemove((InternalEObject)this, 1, Project.class, msgs);
                }
                return this.basicSetProjectInternal((Project)otherEnd, msgs);
            }
            case 2: {
                if (this.contextModel != null) {
                    msgs = ((InternalEObject)this.contextModel).eInverseRemove((InternalEObject)this, -3, null, msgs);
                }
                return this.basicSetContextModel((ContextModel)otherEnd, msgs);
            }
            case 6: {
                if (this.layerFactory != null) {
                    msgs = ((InternalEObject)this.layerFactory).eInverseRemove((InternalEObject)this, -7, null, msgs);
                }
                return this.basicSetLayerFactory((LayerFactory)otherEnd, msgs);
            }
            case 7: {
                if (this.viewportModelInternal != null) {
                    msgs = ((InternalEObject)this.viewportModelInternal).eInverseRemove((InternalEObject)this, -8, null, msgs);
                }
                return this.basicSetViewportModelInternal((ViewportModel)otherEnd, msgs);
            }
            case 9: {
                if (this.editManagerInternal != null) {
                    msgs = ((InternalEObject)this.editManagerInternal).eInverseRemove((InternalEObject)this, -10, null, msgs);
                }
                return this.basicSetEditManagerInternal((EditManager)otherEnd, msgs);
            }
            case 10: {
                if (this.renderManagerInternal != null) {
                    msgs = ((InternalEObject)this.renderManagerInternal).eInverseRemove((InternalEObject)this, 2, RenderManager.class, msgs);
                }
                return this.basicSetRenderManagerInternal((RenderManager)otherEnd, msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 1: {
                return this.basicSetProjectInternal(null, msgs);
            }
            case 2: {
                return this.basicSetContextModel(null, msgs);
            }
            case 6: {
                return this.basicSetLayerFactory(null, msgs);
            }
            case 7: {
                return this.basicSetViewportModelInternal(null, msgs);
            }
            case 9: {
                return this.basicSetEditManagerInternal(null, msgs);
            }
            case 10: {
                return this.basicSetRenderManagerInternal(null, msgs);
            }
            case 12: {
                return this.basicSetBlackBoardInternal(null, msgs);
            }
            case 13: {
                return ((InternalEList)this.getLegend()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getName();
            }
            case 1: {
                if (resolve) {
                    return this.getProjectInternal();
                }
                return this.basicGetProjectInternal();
            }
            case 2: {
                return this.getContextModel();
            }
            case 3: {
                return this.getAbstract();
            }
            case 4: {
                return this.getNavCommandStack();
            }
            case 5: {
                return this.getCommandStack();
            }
            case 6: {
                return this.getLayerFactory();
            }
            case 7: {
                return this.getViewportModelInternal();
            }
            case 8: {
                return this.getColorPalette();
            }
            case 9: {
                return this.getEditManagerInternal();
            }
            case 10: {
                if (resolve) {
                    return this.getRenderManagerInternal();
                }
                return this.basicGetRenderManagerInternal();
            }
            case 11: {
                return this.getColourScheme();
            }
            case 12: {
                return this.getBlackBoardInternal();
            }
            case 13: {
                return this.getLegend();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setName((String)newValue);
                return;
            }
            case 1: {
                this.setProjectInternal((Project)newValue);
                return;
            }
            case 2: {
                this.setContextModel((ContextModel)newValue);
                return;
            }
            case 3: {
                this.setAbstract((String)newValue);
                return;
            }
            case 6: {
                this.setLayerFactory((LayerFactory)newValue);
                return;
            }
            case 7: {
                this.setViewportModelInternal((ViewportModel)newValue);
                return;
            }
            case 8: {
                this.setColorPalette((BrewerPalette)newValue);
                return;
            }
            case 9: {
                this.setEditManagerInternal((EditManager)newValue);
                return;
            }
            case 10: {
                this.setRenderManagerInternal((RenderManager)newValue);
                return;
            }
            case 11: {
                this.setColourScheme((ColourScheme)newValue);
                return;
            }
            case 12: {
                this.setBlackBoardInternal((Blackboard)newValue);
                return;
            }
            case 13: {
                this.getLegend().clear();
                this.getLegend().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.setName("");
                return;
            }
            case 1: {
                this.setProjectInternal(null);
                return;
            }
            case 2: {
                this.setContextModel(null);
                return;
            }
            case 3: {
                this.setAbstract("");
                return;
            }
            case 6: {
                this.setLayerFactory(null);
                return;
            }
            case 7: {
                this.setViewportModelInternal(null);
                return;
            }
            case 8: {
                this.setColorPalette(this.COLOR_PALETTE_EDEFAULT);
                return;
            }
            case 9: {
                this.setEditManagerInternal(null);
                return;
            }
            case 10: {
                this.setRenderManagerInternal(null);
                return;
            }
            case 11: {
                this.setColourScheme(COLOUR_SCHEME_EDEFAULT);
                return;
            }
            case 12: {
                this.setBlackBoardInternal(null);
                return;
            }
            case 13: {
                this.getLegend().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return "" == null ? this.name != null : !"".equals(this.name);
            }
            case 1: {
                return this.projectInternal != null;
            }
            case 2: {
                return this.contextModel != null;
            }
            case 3: {
                return "" == null ? this.abstract_ != null : !"".equals(this.abstract_);
            }
            case 4: {
                return NAV_COMMAND_STACK_EDEFAULT == null ? this.getNavCommandStack() != null : !NAV_COMMAND_STACK_EDEFAULT.equals(this.getNavCommandStack());
            }
            case 5: {
                return COMMAND_STACK_EDEFAULT == null ? this.getCommandStack() != null : !COMMAND_STACK_EDEFAULT.equals(this.getCommandStack());
            }
            case 6: {
                return this.layerFactory != null;
            }
            case 7: {
                return this.viewportModelInternal != null;
            }
            case 8: {
                return this.COLOR_PALETTE_EDEFAULT == null ? this.colorPalette != null : !this.COLOR_PALETTE_EDEFAULT.equals(this.colorPalette);
            }
            case 9: {
                return this.editManagerInternal != null;
            }
            case 10: {
                return this.renderManagerInternal != null;
            }
            case 11: {
                return COLOUR_SCHEME_EDEFAULT == null ? this.colourScheme != null : !COLOUR_SCHEME_EDEFAULT.equals((Object)this.colourScheme);
            }
            case 12: {
                return this.blackBoardInternal != null;
            }
            case 13: {
                return this.legend != null && !this.legend.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public EditManager getEditManagerInternal() {
        if (this.editManagerInternal == null) {
            this.setEditManagerInternal(ProjectFactory.eINSTANCE.createEditManager());
        }
        return this.editManagerInternal;
    }

    public NotificationChain basicSetEditManagerInternal(EditManager newEditManagerInternal, NotificationChain msgs) {
        EditManager oldEditManagerInternal = this.editManagerInternal;
        this.editManagerInternal = newEditManagerInternal;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 9, (Object)oldEditManagerInternal, (Object)newEditManagerInternal);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public void setEditManagerInternal(EditManager newEditManagerInternal) {
        if (newEditManagerInternal != this.editManagerInternal) {
            NotificationChain msgs = null;
            if (this.editManagerInternal != null) {
                msgs = ((InternalEObject)this.editManagerInternal).eInverseRemove((InternalEObject)this, 1, EditManager.class, msgs);
            }
            if (newEditManagerInternal != null) {
                msgs = ((InternalEObject)newEditManagerInternal).eInverseAdd((InternalEObject)this, 1, EditManager.class, msgs);
            }
            if ((msgs = this.basicSetEditManagerInternal(newEditManagerInternal, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 9, (Object)newEditManagerInternal, (Object)newEditManagerInternal));
        }
    }

    @Override
    public RenderManager getRenderManagerInternal() {
        if (this.renderManagerInternal != null && this.renderManagerInternal.eIsProxy()) {
            InternalEObject oldRenderManagerInternal = (InternalEObject)this.renderManagerInternal;
            this.renderManagerInternal = (RenderManager)this.eResolveProxy(oldRenderManagerInternal);
            if (this.renderManagerInternal != oldRenderManagerInternal && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 10, (Object)oldRenderManagerInternal, (Object)this.renderManagerInternal));
            }
        }
        return this.renderManagerInternal;
    }

    public RenderManager basicGetRenderManagerInternal() {
        return this.renderManagerInternal;
    }

    public NotificationChain basicSetRenderManagerInternal(RenderManager newRenderManagerInternal, NotificationChain msgs) {
        RenderManager oldRenderManagerInternal = this.renderManagerInternal;
        this.renderManagerInternal = newRenderManagerInternal;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 10, (Object)oldRenderManagerInternal, (Object)newRenderManagerInternal);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    public void setRenderManagerInternalGen(RenderManager newRenderManagerInternal) {
        if (newRenderManagerInternal != this.renderManagerInternal) {
            NotificationChain msgs = null;
            if (this.renderManagerInternal != null) {
                msgs = ((InternalEObject)this.renderManagerInternal).eInverseRemove((InternalEObject)this, 2, RenderManager.class, msgs);
            }
            if (newRenderManagerInternal != null) {
                msgs = ((InternalEObject)newRenderManagerInternal).eInverseAdd((InternalEObject)this, 2, RenderManager.class, msgs);
            }
            if ((msgs = this.basicSetRenderManagerInternal(newRenderManagerInternal, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 10, (Object)newRenderManagerInternal, (Object)newRenderManagerInternal));
        }
    }

    @Override
    public void setRenderManagerInternal(RenderManager newRenderManager) {
        this.setRenderManagerInternalGen(newRenderManager);
        if (newRenderManager != null) {
            newRenderManager.eAdapters().add((Object)this.adapter);
        }
        if (this.getViewportModel() != null) {
            this.getViewportModelInternal().setRenderManagerInternal(newRenderManager);
        }
    }

    @Override
    public ColourScheme getColourScheme() {
        return this.colourScheme;
    }

    @Override
    public void setColourScheme(ColourScheme newColourScheme) {
        ColourScheme oldColourScheme = this.colourScheme;
        this.colourScheme = newColourScheme;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 11, (Object)oldColourScheme, (Object)this.colourScheme));
        }
    }

    @Override
    public IBlackboard getBlackboard() {
        return this.getBlackBoardInternal();
    }

    @Override
    public Blackboard getBlackBoardInternal() {
        return this.blackBoardInternal;
    }

    public NotificationChain basicSetBlackBoardInternal(Blackboard newBlackBoardInternal, NotificationChain msgs) {
        Blackboard oldBlackBoardInternal = this.blackBoardInternal;
        this.blackBoardInternal = newBlackBoardInternal;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 12, (Object)oldBlackBoardInternal, (Object)newBlackBoardInternal);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public void setBlackBoardInternal(Blackboard newBlackBoardInternal) {
        if (newBlackBoardInternal != this.blackBoardInternal) {
            NotificationChain msgs = null;
            if (this.blackBoardInternal != null) {
                msgs = ((InternalEObject)this.blackBoardInternal).eInverseRemove((InternalEObject)this, -13, null, msgs);
            }
            if (newBlackBoardInternal != null) {
                msgs = ((InternalEObject)newBlackBoardInternal).eInverseAdd((InternalEObject)this, -13, null, msgs);
            }
            if ((msgs = this.basicSetBlackBoardInternal(newBlackBoardInternal, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 12, (Object)newBlackBoardInternal, (Object)newBlackBoardInternal));
        }
    }

    @Override
    public List<ILegendItem> getLegend() {
        if (this.legend == null) {
            this.legend = new EObjectContainmentEList(ILegendItem.class, (InternalEObject)this, 13);
        }
        return this.legend;
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (name: ");
        result.append(this.name);
        result.append(", abstract: ");
        result.append(this.abstract_);
        result.append(", colorPalette: ");
        result.append(this.colorPalette);
        result.append(", colourScheme: ");
        result.append(this.colourScheme);
        result.append(')');
        return result.toString();
    }

    public Object getAdapter(Class adapter) {
        for (Object o : this.eAdapters()) {
            if (!adapter.isAssignableFrom(o.getClass())) continue;
            return o;
        }
        if (adapter.isAssignableFrom(IWorkbenchAdapter.class)) {
            return new WorkbenchAdapter(){

                public String getLabel(Object object) {
                    return MapImpl.this.getName();
                }
            };
        }
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    @Override
    public IProject getProject() {
        return this.getProjectInternal();
    }

    @Override
    public IViewportModel getViewportModel() {
        return this.getViewportModelInternal();
    }

    @Override
    public IEditManager getEditManager() {
        return this.getEditManagerInternal();
    }

    @Override
    public IRenderManager getRenderManager() {
        return this.getRenderManagerInternal();
    }

    public List getMapLayers() {
        return Collections.unmodifiableList(this.getLayersInternal());
    }

    @Override
    public List<Layer> getLayersInternal() {
        if (this.getContextModel() == null) {
            return EMPTY_LIST;
        }
        return this.getContextModel().getLayers();
    }

    @Override
    public void sendCommandSync(MapCommand command) {
        if (command instanceof NavCommand) {
            this.sendCommand((NavCommand)command, false);
        } else if (command instanceof EditCommand) {
            this.sendCommand((EditCommand)command, false);
        } else {
            this.sendCommand(command, false);
        }
    }

    @Override
    public void sendCommandASync(MapCommand command) {
        if (command instanceof NavCommand) {
            this.sendCommand((NavCommand)command, true);
        } else if (command instanceof EditCommand) {
            this.sendCommand((EditCommand)command, true);
        } else {
            this.sendCommand(command, true);
        }
    }

    @Override
    public void executeSyncWithoutUndo(final MapCommand command) {
        command.setMap(this);
        if (Display.getCurrent() != null) {
            ProgressMonitorDialog dialog = new ProgressMonitorDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
            dialog.setOpenOnRun(true);
            try {
                dialog.run(false, false, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        try {
                            command.run(monitor);
                        }
                        catch (Exception e) {
                            ProjectPlugin.log("Error executing command: " + command.getName(), e);
                        }
                    }
                });
            }
            catch (InvocationTargetException e) {
                ProjectPlugin.log("Error executing command: " + command.getName(), e);
            }
            catch (InterruptedException e) {
                ProjectPlugin.log("Error executing command: " + command.getName(), e);
            }
        } else {
            try {
                command.run((IProgressMonitor)new NullProgressMonitor());
            }
            catch (Exception e) {
                ProjectPlugin.log("Error executing command: " + command.getName(), e);
            }
        }
    }

    @Override
    public void executeASyncWithoutUndo(final MapCommand command) {
        PlatformGIS.run((IRunnableWithProgress)new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    command.run(monitor);
                }
                catch (Exception e) {
                    ProjectPlugin.log("Error executing command: " + command.getName(), e);
                }
            }
        });
    }

    @Override
    public String getFileExtension() {
        return "umap";
    }

    @Override
    public void addMapListener(IMapListener listener) {
        this.mapListeners.add(listener);
    }

    @Override
    public void removeMapListener(IMapListener listener) {
        this.mapListeners.remove(listener);
    }

    @Override
    public void addMapCompositionListener(IMapCompositionListener listener) {
        this.compositionListeners.add(listener);
    }

    @Override
    public void removeMapCompositionListener(IMapCompositionListener listener) {
        this.compositionListeners.remove(listener);
    }

    @Override
    public List<Color> getMapDefaultColours() {
        List<Layer> layers = this.getLayersInternal();
        ArrayList<Color> colours = new ArrayList<Color>();
        for (Layer layer : layers) {
            Color thisColour = layer.getDefaultColor();
            if (thisColour == null) continue;
            colours.add(thisColour);
        }
        return colours;
    }

    @Override
    public void addDeepAdapter(Adapter adapter) {
        ((LayersList2)((Object)this.getLayersInternal())).addDeepAdapter(adapter);
    }

    @Override
    public void removeDeepAdapter(Adapter adapter) {
        ((LayersList2)((Object)this.getLayersInternal())).removeDeepAdapter(adapter);
    }

    @Override
    public void lowerLayer(Layer layer) {
        int index = this.getLayersInternal().indexOf(layer);
        if (index == 0) {
            return;
        }
        ((LayersList2)((Object)this.getLayersInternal())).move(index--, index);
    }

    @Override
    public void raiseLayer(Layer layer) {
        int index = this.getLayersInternal().indexOf(layer);
        if (index > this.getLayersInternal().size() - 2) {
            return;
        }
        ((LayersList2)((Object)this.getLayersInternal())).move(index++, index);
    }

    @Override
    public void sendToFrontLayer(Layer layer) {
        int index = this.getLayersInternal().indexOf(layer);
        ((LayersList2)((Object)this.getLayersInternal())).move(this.getLayersInternal().size() - 1, index);
    }

    @Override
    public void sendToBackLayer(Layer layer) {
        int index = this.getLayersInternal().indexOf(layer);
        ((LayersList2)((Object)this.getLayersInternal())).move(0, index);
    }

    @Override
    public void sendToIndexLayer(Layer layer, int index) {
        int currentIndex = this.getLayersInternal().indexOf(layer);
        ((LayersList2)((Object)this.getLayersInternal())).move(index, currentIndex);
    }

    private SpatialOperator localize(SimpleFeatureType schema, SpatialOperator filter) {
        DuplicatingFilterVisitor copier = new DuplicatingFilterVisitor();
        return (SpatialOperator)filter.accept((FilterVisitor)copier, null);
    }

    private Filter target(Layer layer, Filter filter) {
        if (!layer.isSelectable()) {
            return Filter.INCLUDE;
        }
        try {
            FeatureSource featureSource = (FeatureSource)layer.getResource(FeatureSource.class, null);
            if (featureSource == null) {
                return Filter.INCLUDE;
            }
            SimpleFeatureType schema = layer.getSchema();
            Object copy = filter instanceof SpatialOperator ? this.localize(schema, (SpatialOperator)filter) : filter;
            if (copy == null) {
                return Filter.INCLUDE;
            }
            return copy;
        }
        catch (IOException e) {
            ProjectPlugin.log(null, e);
            return Filter.INCLUDE;
        }
    }

    @Override
    public void select(Envelope boundingBox) {
        Layer selected = this.getEditManagerInternal().getSelectedLayer();
        for (Layer layer : this.getLayersInternal()) {
            if (layer == selected) {
                Filter newFilter = layer.createBBoxFilter(boundingBox, null);
                if (newFilter == null) continue;
                layer.setFilter(newFilter);
                continue;
            }
            layer.setFilter((Filter)Filter.EXCLUDE);
        }
        this.notifyBatchNotification(1, 1);
    }

    @Override
    public void select(Envelope boundingBox, boolean add) {
        Layer selected = this.getEditManagerInternal().getSelectedLayer();
        for (Layer layer : this.getLayersInternal()) {
            if (layer == selected) {
                Filter oldFilter = layer.getFilter();
                Filter newFilter = null;
                newFilter = layer.createBBoxFilter(boundingBox, null);
                layer.createBBoxFilter(boundingBox, null);
                if (newFilter == null) continue;
                if (oldFilter == null || oldFilter == Filter.EXCLUDE || oldFilter.equals(Filter.EXCLUDE)) {
                    layer.setFilter(newFilter);
                    continue;
                }
                FilterFactory fac = CommonFactoryFinder.getFilterFactory((Hints)GeoTools.getDefaultHints());
                if (!add) {
                    Not notFilter = fac.not(newFilter);
                    And logicFilter = fac.and((Filter)notFilter, oldFilter);
                    layer.setFilter((Filter)logicFilter);
                    continue;
                }
                Or orFilter = fac.or(newFilter, oldFilter);
                layer.setFilter((Filter)orFilter);
                continue;
            }
            layer.setFilter((Filter)Filter.EXCLUDE);
        }
    }

    @Override
    public void select(Filter filter) {
        Layer selected = this.getEditManagerInternal().getSelectedLayer();
        for (Layer layer : this.getLayersInternal()) {
            if (layer == selected) {
                layer.setFilter(this.target(layer, filter));
                continue;
            }
            layer.setFilter((Filter)Filter.EXCLUDE);
        }
    }

    @Override
    public void select(Filter filter, boolean and) {
        Layer selected = this.getEditManagerInternal().getSelectedLayer();
        for (Layer layer : this.getLayersInternal()) {
            if (layer == selected) {
                And logicFilter;
                Filter oldFilter = layer.getFilter();
                if (oldFilter == null || oldFilter == Filter.EXCLUDE || oldFilter.equals(Filter.EXCLUDE)) {
                    layer.setFilter(this.target(layer, filter));
                    continue;
                }
                FilterFactory createFilterFactory = CommonFactoryFinder.getFilterFactory((Hints)GeoTools.getDefaultHints());
                if (!and) {
                    logicFilter = createFilterFactory.and(oldFilter, this.target(layer, filter));
                    layer.setFilter((Filter)logicFilter);
                    continue;
                }
                logicFilter = createFilterFactory.or(oldFilter, this.target(layer, filter));
                layer.setFilter((Filter)logicFilter);
                continue;
            }
            layer.setFilter((Filter)Filter.EXCLUDE);
        }
    }

    @Override
    public void select(Filter filter, ILayer layerObj) {
        Layer layer = (Layer)layerObj;
        if (this.getLayersInternal().contains(layer)) {
            for (Layer layer2 : this.getLayersInternal()) {
                if (layer == layer2) {
                    layer2.setFilter(this.target(layer, filter));
                    continue;
                }
                layer2.setFilter((Filter)Filter.EXCLUDE);
            }
        }
    }

    public List getElements(Class type) {
        ArrayList<Layer> lists = new ArrayList<Layer>();
        for (Layer obj : this.getLayersInternal()) {
            if (!type.isAssignableFrom(obj.getClass())) continue;
            lists.add(obj);
        }
        return lists;
    }

    public List getElements() {
        return this.getLayersInternal();
    }

    private static class BatchNotification
    extends ENotificationImpl
    implements Iterable<Notification> {
        List<Notification> notifications = new ArrayList<Notification>();

        public BatchNotification(MapImpl notifier, int eventType, int featureid) {
            super((InternalEObject)notifier, eventType, featureid, null, null);
        }

        public boolean add(Notification newNotification) {
            if (this.notifications.contains(newNotification)) {
                return false;
            }
            this.notifications.add(newNotification);
            Collections.sort(this.notifications, new Comparator<Notification>(){

                @Override
                public int compare(Notification o1, Notification o2) {
                    Layer layer1 = (Layer)o1.getNotifier();
                    Layer layer2 = (Layer)o2.getNotifier();
                    return layer1.compareTo(layer2);
                }
            });
            return true;
        }

        @Override
        public Iterator<Notification> iterator() {
            return this.notifications.iterator();
        }
    }

    public class MapCommandListener
    implements CommandListener {
        public static final int COMMAND = 0;
        public static final int NAV_COMMAND = 1;

        @Override
        public void commandExecuted(int commandType) {
            switch (commandType) {
                case 0: {
                    MapImpl.this.notifyCommandDone();
                    break;
                }
                case 1: {
                    MapImpl.this.notifyNavCommandDone();
                }
            }
        }
    }
}

