/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.internal.impl;

import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.refractions.udig.catalog.ID;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.catalog.IGeoResourceInfo;
import net.refractions.udig.catalog.IResolve;
import net.refractions.udig.catalog.IService;
import net.refractions.udig.core.internal.ExtensionPointList;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.IResourceCachingInterceptor;
import net.refractions.udig.project.IResourceInterceptor;
import net.refractions.udig.project.internal.ProjectPlugin;
import net.refractions.udig.project.internal.impl.LayerImpl;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;

public class LayerResource
extends IGeoResource {
    private final LayerImpl layer;
    IGeoResource geoResource;
    private volatile InterceptorsBag interceptors;
    private Sorter preSorter;
    private Sorter postSorter;

    public boolean equals(Object obj) {
        if (obj instanceof LayerResource) {
            LayerResource other = (LayerResource)((Object)obj);
            return this.geoResource.equals((Object)other.geoResource);
        }
        return false;
    }

    public int hashCode() {
        return this.geoResource.hashCode();
    }

    public LayerResource(LayerImpl impl, IGeoResource resource) {
        this.service = null;
        this.layer = impl;
        this.geoResource = resource;
    }

    public <T> boolean canResolve(Class<T> adaptee) {
        if (ILayer.class.isAssignableFrom(adaptee)) {
            return true;
        }
        return this.geoResource.canResolve(adaptee);
    }

    public URL getIdentifier() {
        return this.geoResource.getIdentifier();
    }

    public ID getID() {
        return this.geoResource.getID();
    }

    public Throwable getMessage() {
        return this.geoResource.getMessage();
    }

    public IResolve.Status getStatus() {
        return this.geoResource.getStatus();
    }

    public String getTitle() {
        return this.geoResource.getTitle();
    }

    public Map<String, Serializable> getPersistentProperties() {
        return this.geoResource.getPersistentProperties();
    }

    public List<IResolve> members(IProgressMonitor monitor) {
        return this.geoResource.members(monitor);
    }

    public synchronized <T> T resolve(Class<T> adaptee, IProgressMonitor monitor) throws IOException {
        if (ILayer.class.isAssignableFrom(adaptee)) {
            return adaptee.cast(this.layer);
        }
        if (IGeoResource.class == adaptee) {
            return adaptee.cast((Object)this);
        }
        if (this.geoResource.getClass().isAssignableFrom(adaptee)) {
            return adaptee.cast(this.geoResource);
        }
        T resource = this.processResourceCachingStrategy(monitor, adaptee);
        if (resource == null) {
            return null;
        }
        resource = this.processPostResourceInterceptors(resource, adaptee);
        return resource;
    }

    public IResolve parent(IProgressMonitor monitor) throws IOException {
        return this.geoResource.parent(monitor);
    }

    private <T> T processPreResourceInterceptors(T resource, Class<T> requestedType) {
        List<SafeResourceInterceptor<T>> pre = this.getPreInterceptors(resource);
        return this.runInterceptors(requestedType, resource, pre);
    }

    private <T> T runInterceptors(Class<T> requestedType, T origionalResource, List<SafeResourceInterceptor<T>> pre) {
        T resource = origionalResource;
        for (SafeResourceInterceptor<T> interceptor : pre) {
            if (resource == null) {
                return null;
            }
            if (!this.isAssignable(resource, interceptor.targetType)) continue;
            resource = interceptor.run(this.layer, resource, requestedType);
        }
        return resource;
    }

    private <T> List<SafeResourceInterceptor<T>> getPreInterceptors(T resource) {
        this.loadInterceptors();
        Set<Map.Entry<IConfigurationElement, SafeResourceInterceptor<?>>> entires = this.interceptors.pre.entrySet();
        List<SafeResourceInterceptor<T>> result = this.findValidInterceptors(resource, entires);
        if (this.preSorter != null) {
            Collections.sort(result, this.preSorter);
        }
        return result;
    }

    private <T> List<SafeResourceInterceptor<T>> findValidInterceptors(T resource, Set<Map.Entry<IConfigurationElement, SafeResourceInterceptor<?>>> entires) {
        ArrayList<SafeResourceInterceptor<T>> result = new ArrayList<SafeResourceInterceptor<T>>();
        for (Map.Entry<IConfigurationElement, SafeResourceInterceptor<?>> entry : entires) {
            String attribute = entry.getKey().getAttribute("target");
            if (attribute == null) {
                result.add(entry.getValue());
                continue;
            }
            boolean assignableFrom = this.isAssignable(resource, attribute);
            if (!assignableFrom) continue;
            result.add(entry.getValue());
        }
        return result;
    }

    private <T> boolean isAssignable(T resource, String attribute) {
        boolean assignableFrom;
        if (attribute == null) {
            return true;
        }
        try {
            Class<?> class1 = resource.getClass();
            ClassLoader classLoader = class1.getClassLoader();
            if (classLoader == null) {
                classLoader = Thread.currentThread().getContextClassLoader();
            }
            Class<?> loadClass = classLoader.loadClass(attribute);
            assignableFrom = loadClass.isAssignableFrom(class1);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
        return assignableFrom;
    }

    private <T> T processResourceCachingStrategy(IProgressMonitor monitor, Class<T> requestedType) throws IOException {
        IResourceCachingInterceptor cachingStrategy = this.getCachingInterceptors();
        if (cachingStrategy == null) {
            Object rawResource = this.geoResource.resolve(requestedType, monitor);
            if (rawResource == null) {
                return null;
            }
            Object resource = this.processPreResourceInterceptors(rawResource, requestedType);
            return (T)resource;
        }
        if (cachingStrategy.isCached(this.layer, this.geoResource, requestedType)) {
            T resource = cachingStrategy.get(this.layer, requestedType);
            return resource;
        }
        Object rawResource = IGeoResourceInfo.class.isAssignableFrom(requestedType) ? requestedType.cast(this.geoResource.getInfo(monitor)) : this.geoResource.resolve(requestedType, monitor);
        if (rawResource == null) {
            return null;
        }
        Object resource = this.processPreResourceInterceptors(rawResource, requestedType);
        cachingStrategy.put(this.layer, resource, requestedType);
        return (T)resource;
    }

    private IResourceCachingInterceptor getCachingInterceptors() {
        this.loadInterceptors();
        String string = ProjectPlugin.getPlugin().getPreferenceStore().getString("P_LAYER_RESOURCE_CACHING_STRATEGY");
        return this.interceptors.caching.get(string);
    }

    private <T> T processPostResourceInterceptors(T originalResource, Class<T> requestedType) {
        List<SafeResourceInterceptor<T>> interceptors = this.getPostInterceptors(originalResource);
        T resource = this.runInterceptors(requestedType, originalResource, interceptors);
        return resource;
    }

    private <T> List<SafeResourceInterceptor<T>> getPostInterceptors(T resource) {
        this.loadInterceptors();
        List<SafeResourceInterceptor<T>> findValidInterceptors = this.findValidInterceptors(resource, this.interceptors.post.entrySet());
        if (this.postSorter != null) {
            Collections.sort(findValidInterceptors, this.postSorter);
        }
        return findValidInterceptors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadInterceptors() {
        if (this.interceptors == null) {
            LayerResource layerResource = this;
            synchronized (layerResource) {
                if (this.interceptors == null) {
                    HashMap pre = new HashMap();
                    HashMap<String, IResourceCachingInterceptor> caching = new HashMap<String, IResourceCachingInterceptor>();
                    HashMap post = new HashMap();
                    List list = ExtensionPointList.getExtensionPointList((String)"net.refractions.udig.project.resourceInterceptor");
                    for (IConfigurationElement element : list) {
                        try {
                            if (element.getName().equals("cachingStrategy")) {
                                IResourceCachingInterceptor strategy = (IResourceCachingInterceptor)element.createExecutableExtension("class");
                                caching.put(String.valueOf(element.getNamespaceIdentifier()) + "." + element.getAttribute("id"), strategy);
                                continue;
                            }
                            IResourceInterceptor tmp = (IResourceInterceptor)element.createExecutableExtension("class");
                            SafeResourceInterceptor interceptor = new SafeResourceInterceptor(tmp, element.getAttribute("target"));
                            String order = element.getAttribute("order");
                            if ("PRE".equals(order)) {
                                pre.put(element, interceptor);
                                continue;
                            }
                            if (!"POST".equals(order)) continue;
                            post.put(element, interceptor);
                        }
                        catch (CoreException e) {
                            ProjectPlugin.log("Failed to load resource interceptor:" + element.getNamespaceIdentifier() + "." + element.getAttribute("id"), e);
                        }
                    }
                    this.interceptors = new InterceptorsBag(pre, caching, post);
                }
            }
        }
    }

    protected IGeoResourceInfo createInfo(IProgressMonitor monitor) throws IOException {
        return this.resolve(IGeoResourceInfo.class, monitor);
    }

    public LayerImpl getLayer() {
        return this.layer;
    }

    public void testingOnly_sort(Comparator<IResourceInterceptor<? extends Object>> comparator, boolean sortPre) {
        if (sortPre) {
            this.preSorter = new Sorter(comparator);
        } else {
            this.postSorter = new Sorter(comparator);
        }
    }

    public IService service(IProgressMonitor monitor) throws IOException {
        return this.geoResource.service(monitor);
    }

    private static class InterceptorsBag {
        final Map<IConfigurationElement, SafeResourceInterceptor<?>> pre;
        final Map<String, IResourceCachingInterceptor> caching;
        final Map<IConfigurationElement, SafeResourceInterceptor<?>> post;

        public InterceptorsBag(Map<IConfigurationElement, SafeResourceInterceptor<?>> pre, Map<String, IResourceCachingInterceptor> caching, Map<IConfigurationElement, SafeResourceInterceptor<?>> post) {
            this.pre = pre;
            this.caching = caching;
            this.post = post;
        }
    }

    private static class SafeResourceInterceptor<T>
    implements IResourceInterceptor<T> {
        public String targetType;
        private IResourceInterceptor<T> interceptor;

        public SafeResourceInterceptor(IResourceInterceptor<T> interceptor, String targetType) {
            this.interceptor = interceptor;
            this.targetType = targetType;
        }

        @Override
        public T run(ILayer layer, T resource, Class<? super T> requestedType) {
            try {
                return this.interceptor.run(layer, (T)resource, requestedType);
            }
            catch (Throwable t) {
                ProjectPlugin.log("Exception when running interceptor: " + this.interceptor, t);
                return resource;
            }
        }

        public String toString() {
            return this.interceptor.toString();
        }
    }

    private static class Sorter
    implements Comparator<SafeResourceInterceptor<? extends Object>> {
        private Comparator<IResourceInterceptor<? extends Object>> wrapped;

        public Sorter(Comparator<IResourceInterceptor<? extends Object>> comparator) {
            this.wrapped = comparator;
        }

        @Override
        public int compare(SafeResourceInterceptor<? extends Object> o1, SafeResourceInterceptor<? extends Object> o2) {
            return this.wrapped.compare(((SafeResourceInterceptor)o1).interceptor, ((SafeResourceInterceptor)o2).interceptor);
        }
    }
}

