/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.internal.impl;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import net.refractions.udig.catalog.CatalogPlugin;
import net.refractions.udig.catalog.ICatalog;
import net.refractions.udig.catalog.ID;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.catalog.IGeoResourceInfo;
import net.refractions.udig.catalog.IResolve;
import net.refractions.udig.catalog.IResolveChangeEvent;
import net.refractions.udig.catalog.IResolveChangeListener;
import net.refractions.udig.catalog.IResolveDelta;
import net.refractions.udig.catalog.URLUtils;
import net.refractions.udig.catalog.util.SearchIDDeltaVisitor;
import net.refractions.udig.core.Pair;
import net.refractions.udig.core.internal.CorePlugin;
import net.refractions.udig.project.IBlackboard;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.ILayerListener;
import net.refractions.udig.project.IMap;
import net.refractions.udig.project.Interaction;
import net.refractions.udig.project.LayerEvent;
import net.refractions.udig.project.internal.CatalogRef;
import net.refractions.udig.project.internal.ContextModel;
import net.refractions.udig.project.internal.Layer;
import net.refractions.udig.project.internal.Map;
import net.refractions.udig.project.internal.Messages;
import net.refractions.udig.project.internal.ProjectFactory;
import net.refractions.udig.project.internal.ProjectPackage;
import net.refractions.udig.project.internal.ProjectPlugin;
import net.refractions.udig.project.internal.SimpleBlackboard;
import net.refractions.udig.project.internal.StyleBlackboard;
import net.refractions.udig.project.internal.impl.InteractionToEBooleanObjectMapEntryImpl;
import net.refractions.udig.project.internal.impl.LayerResource;
import net.refractions.udig.project.internal.impl.NullGeoResource;
import net.refractions.udig.project.internal.impl.SynchronizedEList;
import net.refractions.udig.project.internal.impl.UDIGStore;
import net.refractions.udig.project.internal.render.RenderManager;
import net.refractions.udig.project.internal.render.RendererCreator;
import net.refractions.udig.project.render.AbstractRenderMetrics;
import net.refractions.udig.ui.PlatformGIS;
import net.refractions.udig.ui.ProgressManager;
import net.refractions.udig.ui.UDIGDisplaySafeLock;
import net.refractions.udig.ui.palette.ColourScheme;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EDataTypeUniqueEList;
import org.eclipse.emf.ecore.util.EcoreEMap;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.model.WorkbenchAdapter;
import org.geotools.data.FeatureEvent;
import org.geotools.data.FeatureListener;
import org.geotools.data.FeatureSource;
import org.geotools.data.FeatureStore;
import org.geotools.data.Query;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultEngineeringCRS;
import org.geotools.referencing.operation.LinearTransform;
import org.geotools.referencing.operation.transform.IdentityTransform;
import org.geotools.util.Range;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.spatial.Intersects;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public class LayerImpl
extends EObjectImpl
implements Layer {
    protected static final Filter FILTER_EDEFAULT = Filter.EXCLUDE;
    protected volatile Filter filter = FILTER_EDEFAULT;
    protected volatile StyleBlackboard styleBlackboard = ProjectFactory.eINSTANCE.createStyleBlackboard();
    protected static final int ZORDER_EDEFAULT = 0;
    protected int zorder = 0;
    protected static final int STATUS_EDEFAULT = 0;
    Adapter contextModelAdapter = new AdapterImpl(){

        public void notifyChanged(Notification msg) {
            this.registerWithContainers(msg);
            this.raiseEvents(msg);
        }

        private void raiseEvents(Notification msg) {
            switch (msg.getFeatureID(Layer.class)) {
                case 1: {
                    LayerImpl.this.fireLayerChange(new LayerEvent(LayerImpl.this, LayerEvent.EventType.FILTER, msg.getOldValue(), msg.getNewValue()));
                    break;
                }
                case 5: {
                    LayerImpl.this.fireLayerChange(new LayerEvent(LayerImpl.this, LayerEvent.EventType.NAME, msg.getOldValue(), msg.getNewValue()));
                    break;
                }
                case 10: {
                    LayerImpl.this.fireLayerChange(new LayerEvent(LayerImpl.this, LayerEvent.EventType.RESOURCE, msg.getOldValue(), msg.getNewValue()));
                    break;
                }
                case 8: {
                    LayerImpl.this.fireLayerChange(new LayerEvent(LayerImpl.this, LayerEvent.EventType.VISIBILITY, msg.getOldValue(), msg.getNewValue()));
                    break;
                }
                case 3: {
                    LayerImpl.this.fireLayerChange(new LayerEvent(LayerImpl.this, LayerEvent.EventType.ZORDER, msg.getOldValue(), msg.getNewValue()));
                    break;
                }
                case 15: {
                    LayerImpl.this.fireLayerChange(new LayerEvent(LayerImpl.this, LayerEvent.EventType.EDIT_EVENT, msg.getOldValue(), msg.getNewValue()));
                    break;
                }
                case 2: {
                    LayerImpl.this.fireLayerChange(new LayerEvent(LayerImpl.this, LayerEvent.EventType.STYLE, msg.getOldValue(), msg.getNewValue()));
                    break;
                }
            }
        }

        private void registerWithContainers(Notification msg) {
            switch (msg.getEventType()) {
                case 1: {
                    if (msg.getFeatureID(Layer.class) == 0) {
                        if (msg.getOldValue() instanceof ContextModel) {
                            ((ContextModel)msg.getOldValue()).eAdapters().remove((Object)this);
                        }
                        if (msg.getNewValue() instanceof ContextModel) {
                            ((ContextModel)msg.getNewValue()).eAdapters().add((Object)this);
                        }
                    }
                    return;
                }
                case 7: {
                    if (msg.getFeatureID(Layer.class) == 0 && LayerImpl.this.eNotificationRequired()) {
                        LayerImpl.this.zorderNotify((Integer)msg.getOldValue(), ((Layer)msg.getNewValue()).getZorder());
                    }
                    return;
                }
            }
        }
    };
    FeatureListener featureListener = new FeatureListener(){

        public void changed(FeatureEvent featureEvent) {
            try {
                UDIGStore layerResource;
                FeatureSource featureSource = featureEvent.getFeatureSource();
                FeatureSource resource = LayerImpl.this.getResource(FeatureSource.class, (IProgressMonitor)new NullProgressMonitor());
                if (resource instanceof UDIGStore && featureSource != (layerResource = (UDIGStore)resource).wrapped()) {
                    featureSource.removeFeatureListener((FeatureListener)this);
                }
            }
            catch (IOException e) {
                ProjectPlugin.log("", e);
            }
            if (featureEvent.getBounds() != null) {
                if (featureEvent.getEventType() == 1 || featureEvent.getEventType() == 0) {
                    if (LayerImpl.this.bounds == null) {
                        ReferencedEnvelope bounds2 = LayerImpl.this.getInfo(LayerImpl.this.getGeoResource(), (IProgressMonitor)new NullProgressMonitor()).getBounds();
                        if (bounds2 == null) {
                            bounds2 = new ReferencedEnvelope(LayerImpl.this.getCRS());
                        }
                        if (bounds2.isNull() || !bounds2.contains((Envelope)featureEvent.getBounds())) {
                            LayerImpl.this.bounds = bounds2;
                        }
                    }
                    if (LayerImpl.this.bounds != null) {
                        LayerImpl.this.bounds.expandToInclude((Envelope)featureEvent.getBounds());
                    }
                }
                LayerImpl.this.getFeatureChanges().add(featureEvent);
            } else if (LayerImpl.this.getFeatureChanges().size() != 0) {
                LayerImpl.this.bounds = null;
                LayerImpl.this.getFeatureChanges().clear();
            }
        }
    };
    CopyOnWriteArraySet<ILayerListener> listeners = new CopyOnWriteArraySet();
    private volatile boolean warned = false;
    private final Lock geoResourceLock = new UDIGDisplaySafeLock();
    private final Lock geoResourceCacheLock = new UDIGDisplaySafeLock();
    private volatile AtomicBoolean unknownCRS;
    private volatile ISafeRunnable crsLoader;
    private Lock unknownCRSLock = new UDIGDisplaySafeLock();
    private static final String DIVIDER = "@type@";
    public static final EList<IGeoResource> NULL = new BasicEList(Collections.singletonList(new NullGeoResource()));
    private volatile int status;
    protected static final String NAME_EDEFAULT = null;
    protected volatile String name = NAME_EDEFAULT;
    protected static final CatalogRef CATALOG_REF_EDEFAULT = null;
    protected volatile CatalogRef catalogRef = new CatalogRef(this);
    protected static final URL ID_EDEFAULT = null;
    protected volatile URL iD = ID_EDEFAULT;
    protected static final boolean VISIBLE_EDEFAULT = true;
    protected volatile boolean visible = true;
    protected static final IGeoResource GEO_RESOURCE_EDEFAULT = null;
    protected volatile IGeoResource geoResource = GEO_RESOURCE_EDEFAULT;
    protected volatile EList<IGeoResource> geoResources = null;
    protected static final CoordinateReferenceSystem CRS_EDEFAULT = null;
    protected volatile CoordinateReferenceSystem cRS = CRS_EDEFAULT;
    protected final IBlackboard properties = new SimpleBlackboard();
    protected static final ColourScheme COLOUR_SCHEME_EDEFAULT = null;
    protected volatile ColourScheme colourScheme = COLOUR_SCHEME_EDEFAULT;
    protected static final Color DEFAULT_COLOR_EDEFAULT = null;
    protected volatile Color defaultColor = DEFAULT_COLOR_EDEFAULT;
    protected volatile EList featureChanges = null;
    protected static final double MIN_SCALE_DENOMINATOR_EDEFAULT = Double.NaN;
    protected volatile double minScaleDenominator = Double.NaN;
    protected static final double MAX_SCALE_DENOMINATOR_EDEFAULT = Double.NaN;
    protected volatile double maxScaleDenominator = Double.NaN;
    protected EMap<Interaction, Boolean> interactionMap;
    protected static final boolean SHOWN_EDEFAULT = false;
    protected boolean shown = false;
    protected static final ImageDescriptor ICON_EDEFAULT = null;
    protected ImageDescriptor icon = ICON_EDEFAULT;
    private volatile String statusMessage = Messages.LayerImpl_status;
    private volatile ReferencedEnvelope bounds;
    private volatile EList eAdapters;
    private AtomicBoolean gettingResources = new AtomicBoolean(false);

    protected LayerImpl() {
        this.eAdapters().add((Object)this.contextModelAdapter);
        CatalogPlugin.addListener((IResolveChangeListener)this);
    }

    protected void finalize() throws Throwable {
        CatalogPlugin.removeListener((IResolveChangeListener)this);
    }

    @Override
    public void addListener(ILayerListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(ILayerListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireLayerChange(LayerEvent event) {
        for (ILayerListener listener : this.listeners) {
            try {
                if (listener == null) continue;
                listener.refresh(event);
            }
            catch (Throwable t) {
                ProjectPlugin.log("", t);
            }
        }
    }

    protected void zorderNotify(int old, int current) {
        if (old == current) {
            return;
        }
        ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 3, old, current, old == current);
        this.eNotify((Notification)notification);
    }

    protected EClass eStaticClass() {
        return ProjectPackage.Literals.LAYER;
    }

    @Override
    public ContextModel getContextModel() {
        if (this.eContainerFeatureID() != 0) {
            return null;
        }
        return (ContextModel)this.eContainer();
    }

    public NotificationChain basicSetContextModel(ContextModel newContextModel, NotificationChain msgs) {
        msgs = this.eBasicSetContainer((InternalEObject)newContextModel, 0, msgs);
        return msgs;
    }

    @Override
    public void setContextModel(ContextModel newContextModel) {
        if (newContextModel != this.eInternalContainer() || this.eContainerFeatureID() != 0 && newContextModel != null) {
            if (EcoreUtil.isAncestor((EObject)this, (EObject)newContextModel)) {
                throw new IllegalArgumentException("Recursive containment not allowed for " + this.toString());
            }
            NotificationChain msgs = null;
            if (this.eInternalContainer() != null) {
                msgs = this.eBasicRemoveFromContainer(msgs);
            }
            if (newContextModel != null) {
                msgs = ((InternalEObject)newContextModel).eInverseAdd((InternalEObject)this, 0, ContextModel.class, msgs);
            }
            if ((msgs = this.basicSetContextModel(newContextModel, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, (Object)newContextModel, (Object)newContextModel));
        }
    }

    @Override
    public int getZorder() {
        if (this.getContextModel() == null) {
            return Integer.MAX_VALUE;
        }
        return this.getMap().getMapLayers().indexOf(this);
    }

    @Override
    public void setZorder(int newZorder) {
        if (this.getContextModel() == null || this.getMapInternal().getLayersInternal() == null) {
            return;
        }
        if (newZorder >= this.getMapInternal().getLayersInternal().size()) {
            ((EList)this.getMapInternal().getLayersInternal()).move(this.getMapInternal().getLayersInternal().size() - 1, this.getMapInternal().getLayersInternal().indexOf(this));
        } else {
            ((EList)this.getMapInternal().getLayersInternal()).move(newZorder, this.getMapInternal().getLayersInternal().indexOf(this));
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String newName) {
        String oldName = this.name;
        this.name = newName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 5, (Object)oldName, (Object)this.name));
        }
    }

    @Override
    public URL getID() {
        return this.iD;
    }

    @Override
    public void setID(URL newID) {
        URL oldID = this.iD;
        this.iD = newID;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 7, (Object)oldID, (Object)this.iD));
        }
    }

    public void setResourceID(ID id) {
        String url;
        String qualifier = id.getTypeQualifier();
        String spec = url = id.toURL().toString();
        if (qualifier != null) {
            spec = String.valueOf(spec) + DIVIDER + qualifier;
        }
        URL newid = CorePlugin.createSafeURL((String)spec);
        this.setID(newid);
    }

    public ID getResourceID() {
        ID id;
        if (this.getID() == null) {
            return null;
        }
        String rid = this.getID().toString();
        String[] parts = rid.split(DIVIDER);
        String qualifier = null;
        if (parts.length == 2) {
            qualifier = parts[1];
        }
        if (parts[0].startsWith("file")) {
            String[] fileParts = parts[0].split("#", 2);
            File file = URLUtils.urlToFile((URL)CorePlugin.createSafeURL((String)fileParts[0]));
            URL url = CorePlugin.createSafeURL((String)parts[0]);
            URI uri = CorePlugin.createSafeURI((String)parts[0]);
            id = new ID(String.valueOf(file.getPath()) + "#" + fileParts[1], url, file, uri, qualifier);
        } else {
            id = new ID(CorePlugin.createSafeURL((String)parts[0]));
        }
        return id;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void setVisible(boolean newVisible) {
        boolean oldVisible = this.visible;
        this.visible = newVisible;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 8, oldVisible, this.visible));
        }
    }

    @Override
    public List<IGeoResource> getGeoResources() {
        assert (this.assertNotInDisplayAccess());
        if (this.eIsProxy() || this.getMap() == null) {
            return this.geoResources == null ? NULL : this.geoResources;
        }
        if (this.geoResources != null || this.geoResources == NULL) {
            return this.geoResources;
        }
        this.geoResourceLock.lock();
        this.gettingResources.set(true);
        try {
            final ID id = this.getResourceID();
            if (id == null) {
                EList<IGeoResource> eList = NULL;
                return eList;
            }
            if (this.geoResources != null && this.geoResources != NULL) {
                EList<IGeoResource> eList = this.geoResources;
                return eList;
            }
            if (!this.catalogRef.isLoaded()) {
                this.catalogRef.load();
            }
            final ArrayList resourceList = new ArrayList();
            final ICatalog connections = CatalogPlugin.getDefault().getLocalCatalog();
            try {
                NullProgressMonitor monitor = new NullProgressMonitor();
                IRunnableWithProgress object = new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException {
                        try {
                            List resources = connections.find(id.toURL(), monitor);
                            for (IResolve resolve : resources) {
                                if (resolve.getStatus() == IResolve.Status.BROKEN || resolve.getStatus() == IResolve.Status.BROKEN || !(resolve instanceof IGeoResource)) continue;
                                LayerResource resource = new LayerResource(LayerImpl.this, (IGeoResource)resolve);
                                if (resolve.getID().equals((Object)id)) {
                                    resourceList.add(0, resource);
                                    continue;
                                }
                                resourceList.add(resource);
                            }
                        }
                        catch (Exception e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                };
                if (Display.getCurrent() != null) {
                    PlatformGIS.runBlockingOperation((IRunnableWithProgress)object, (IProgressMonitor)monitor);
                } else {
                    object.run((IProgressMonitor)monitor);
                }
            }
            catch (Exception e) {
                ProjectPlugin.log("Error getting layer resources", e);
            }
            if (resourceList.size() == 0) {
                if (!this.warned) {
                    ProjectPlugin.log("Layer: " + this.getName() + " could not find a GeoResource with id:" + this.getID());
                    this.warned = true;
                }
                this.setStatus(2);
                this.setStatusMessage(Messages.LayerImpl_connectionFailed);
                this.geoResources = NULL;
            } else {
                this.eSetDeliver(false);
                this.geoResources = new EDataTypeUniqueEList(IGeoResource.class, (InternalEObject)this, 10);
                this.geoResources.addAll(resourceList);
                this.eSetDeliver(true);
                if (this.status == 2 && this.statusMessage.equals(Messages.LayerImpl_connectionFailed)) {
                    this.setStatus(0);
                    this.setStatusMessage("");
                }
            }
        }
        finally {
            this.gettingResources.set(false);
            this.geoResourceLock.unlock();
        }
        return this.geoResources;
    }

    private boolean assertNotInDisplayAccess() {
        Display.getCurrent();
        return true;
    }

    @Override
    public <T> IGeoResource getGeoResource(Class<T> clazz) {
        List<IGeoResource> resources = this.getGeoResources();
        for (IGeoResource resource : resources) {
            if (!resource.canResolve(clazz)) continue;
            return resource;
        }
        return null;
    }

    @Override
    public IGeoResource getGeoResource() {
        block5: {
            if (this.geoResource == null) {
                this.geoResourceCacheLock.lock();
                try {
                    if (this.geoResource != null) break block5;
                    if (this.getGeoResources() != NULL && this.getGeoResources().size() > 0) {
                        this.geoResource = this.getGeoResources().get(0);
                        break block5;
                    }
                    IGeoResource iGeoResource = (IGeoResource)NULL.get(0);
                    return iGeoResource;
                }
                finally {
                    this.geoResourceCacheLock.unlock();
                }
            }
        }
        return this.geoResource;
    }

    @Override
    public void setGeoResource(IGeoResource newPreferredGeoResource) {
        IGeoResource oldPreferredGeoResource = this.geoResource;
        this.geoResource = newPreferredGeoResource;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 9, (Object)oldPreferredGeoResource, (Object)this.geoResource));
        }
    }

    @Override
    public <E> E getResource(Class<E> resourceType, IProgressMonitor monitor) throws IOException {
        IProgressMonitor monitor2 = monitor;
        if (monitor2 == null) {
            monitor2 = ProgressManager.instance().get(new Object[0]);
        }
        try {
            for (IGeoResource georesource : this.getGeoResources()) {
                if (!georesource.canResolve(resourceType)) continue;
                Object object = georesource.resolve(resourceType, monitor2);
                return (E)object;
            }
            return null;
        }
        finally {
            monitor2.done();
        }
    }

    @Override
    public CatalogRef getCatalogRef() {
        if (this.catalogRef.getLayer() != this) {
            this.catalogRef.setLayer(this);
        }
        return this.catalogRef;
    }

    @Override
    public void setCatalogRef(CatalogRef newCatalogRef) {
        newCatalogRef.setLayer(this);
        this.setCatalogRefGen(newCatalogRef);
    }

    public void setCatalogRefGen(CatalogRef newCatalogRef) {
        CatalogRef oldCatalogRef = this.catalogRef;
        this.catalogRef = newCatalogRef;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 6, (Object)oldCatalogRef, (Object)this.catalogRef));
        }
    }

    @Override
    public StyleBlackboard getStyleBlackboard() {
        return this.styleBlackboard;
    }

    public NotificationChain basicSetStyleBlackboard(StyleBlackboard newStyleBlackboard, NotificationChain msgs) {
        StyleBlackboard oldStyleBlackboard = this.styleBlackboard;
        this.styleBlackboard = newStyleBlackboard;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 2, (Object)oldStyleBlackboard, (Object)newStyleBlackboard);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public void setStyleBlackboard(StyleBlackboard newStyleBlackboard) {
        if (newStyleBlackboard != this.styleBlackboard) {
            NotificationChain msgs = null;
            if (this.styleBlackboard != null) {
                msgs = ((InternalEObject)this.styleBlackboard).eInverseRemove((InternalEObject)this, -3, null, msgs);
            }
            if (newStyleBlackboard != null) {
                msgs = ((InternalEObject)newStyleBlackboard).eInverseAdd((InternalEObject)this, -3, null, msgs);
            }
            if ((msgs = this.basicSetStyleBlackboard(newStyleBlackboard, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, (Object)newStyleBlackboard, (Object)newStyleBlackboard));
        }
    }

    @Override
    public Filter getFilter() {
        return this.filter;
    }

    @Override
    public void setFilter(Filter newFilter) {
        Filter oldFilter = this.filter;
        this.filter = newFilter;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)oldFilter, (Object)this.filter));
        }
    }

    @Override
    public int getStatus() {
        if (this.geoResources == NULL || this.status == 2) {
            return this.status;
        }
        if (this.isUnknownCRS()) {
            return 4;
        }
        return this.status;
    }

    private boolean isUnknownCRS() {
        this.unknownCRSLock.lock();
        try {
            if (this.unknownCRS == null) {
                if (this.crsLoader == null) {
                    this.crsLoader = new ISafeRunnable(){

                        public void handleException(Throwable exception) {
                            ProjectPlugin.log("", exception);
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() throws Exception {
                            if (LayerImpl.this.getCRS() == UNKNOWN_CRS) {
                                LayerImpl layerImpl = LayerImpl.this;
                                synchronized (layerImpl) {
                                    if (LayerImpl.this.unknownCRS == null) {
                                        LayerImpl.this.unknownCRS = new AtomicBoolean(true);
                                        LayerImpl.this.setStatus(4);
                                        LayerImpl.this.crsLoader = null;
                                    }
                                }
                            }
                        }
                    };
                    PlatformGIS.run((ISafeRunnable)this.crsLoader);
                }
                return false;
            }
            boolean bl = this.unknownCRS.get();
            return bl;
        }
        finally {
            this.unknownCRSLock.unlock();
        }
    }

    @Override
    public void setStatus(int newStatus) {
        int oldStatus = this.status;
        this.status = newStatus;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 4, oldStatus, this.status));
        }
    }

    @Override
    public <T> IGeoResource findGeoResource(Class<T> resourceType) {
        for (IGeoResource resource : this.getGeoResources()) {
            if (!resource.canResolve(resourceType)) continue;
            return resource;
        }
        return null;
    }

    @Override
    public <T> boolean isType(Class<T> resourceType) {
        return this.hasResource(resourceType);
    }

    @Override
    public <T> boolean hasResource(Class<T> resourceType) {
        for (IGeoResource resource : this.getGeoResources()) {
            if (!resource.canResolve(resourceType)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ImageDescriptor getIcon() {
        return this.icon;
    }

    public ImageDescriptor getGlyph() {
        return this.getIcon();
    }

    @Override
    public void setIcon(ImageDescriptor newIcon) {
        ImageDescriptor oldIcon = this.icon;
        this.icon = newIcon;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 20, (Object)oldIcon, (Object)this.icon));
        }
    }

    public void setGlyph(ImageDescriptor icon) {
        this.setIcon(icon);
    }

    @Override
    public boolean isSelectable() {
        return this.getInteraction(Interaction.SELECT);
    }

    @Override
    public void setSelectable(boolean newSelectable) {
        this.setInteraction(Interaction.SELECT, newSelectable);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer();
        result.append("Layer ( name: ");
        result.append(this.name);
        result.append(')');
        return result.toString();
    }

    @Override
    public Query getQuery(boolean selection) {
        try {
            if (selection) {
                return new Query(this.getSchema().getName().getLocalPart(), this.getFilter());
            }
            return Query.ALL;
        }
        catch (Exception exception) {
            if (selection) {
                Query q = new Query();
                q.setFilter((Filter)Filter.EXCLUDE);
                return q;
            }
            return Query.ALL;
        }
    }

    @Override
    public SimpleFeatureType getSchema() {
        try {
            FeatureSource data = this.getResource(FeatureSource.class, null);
            if (data != null) {
                return (SimpleFeatureType)data.getSchema();
            }
        }
        catch (IOException e) {
            ProjectPlugin.log(null, e);
        }
        return null;
    }

    @Override
    public int compareTo(ILayer arg0) {
        return LayerImpl.doComparison(this, arg0);
    }

    @Override
    public boolean getInteraction(Interaction interaction) {
        if (Interaction.VISIBLE.equals((Object)interaction)) {
            return this.isVisible();
        }
        Boolean applicable = this.getInteractionMap().get((Object)interaction);
        if (applicable == null) {
            applicable = this.getDefaultApplicable(interaction);
        }
        return applicable;
    }

    protected boolean getDefaultApplicable(Interaction interaction) {
        if (Interaction.INFO.equals((Object)interaction)) {
            return true;
        }
        if (Interaction.SELECT.equals((Object)interaction)) {
            return true;
        }
        if (Interaction.EDIT.equals((Object)interaction)) {
            IGeoResource found = this.getGeoResource(FeatureStore.class);
            return found != null;
        }
        return false;
    }

    @Override
    public void setInteraction(Interaction interaction, boolean applicable) {
        if (Interaction.VISIBLE.equals((Object)interaction)) {
            this.setVisible(applicable);
        } else {
            this.getInteractionMap().put(interaction, applicable);
        }
    }

    @Override
    public CoordinateReferenceSystem getCRS() {
        return this.getCRS(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCRS(CoordinateReferenceSystem newCRS) {
        this.setCRSGen(newCRS);
        boolean setStatus = false;
        LayerImpl layerImpl = this;
        synchronized (layerImpl) {
            if (this.unknownCRS == null) {
                this.unknownCRS = new AtomicBoolean(false);
            } else if (this.unknownCRS.get()) {
                this.unknownCRS.set(false);
                setStatus = true;
            }
        }
        if (setStatus) {
            this.setStatus(this.status);
        }
    }

    public void setCRSGen(CoordinateReferenceSystem newCRS) {
        CoordinateReferenceSystem oldCRS = this.cRS;
        this.cRS = newCRS;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 11, (Object)oldCRS, (Object)this.cRS));
        }
    }

    @Override
    public IBlackboard getProperties() {
        return this.properties;
    }

    @Override
    public IBlackboard getBlackboard() {
        return this.properties;
    }

    @Override
    public ColourScheme getColourScheme() {
        return this.colourScheme;
    }

    @Override
    public void setColourScheme(ColourScheme newColourScheme) {
        ColourScheme oldColourScheme = this.colourScheme;
        this.colourScheme = newColourScheme;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 13, (Object)oldColourScheme, (Object)this.colourScheme));
        }
    }

    @Override
    public Color getDefaultColor() {
        return this.defaultColor;
    }

    @Override
    public void setDefaultColor(Color newDefaultColor) {
        Color oldDefaultColor = this.defaultColor;
        this.defaultColor = newDefaultColor;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 14, (Object)oldDefaultColor, (Object)this.defaultColor));
        }
    }

    @Override
    public List<FeatureEvent> getFeatureChanges() {
        if (this.featureChanges == null) {
            this.featureChanges = new EDataTypeUniqueEList(FeatureEvent.class, (InternalEObject)this, 15){

                public void add(int index, Object object) {
                    if (this.size() > 10) {
                        this.clear();
                    }
                    super.add(index, object);
                }

                public boolean add(Object arg0) {
                    return super.add(arg0);
                }
            };
        }
        return this.featureChanges;
    }

    @Override
    public double getMinScaleDenominator() {
        if (Double.isNaN(this.minScaleDenominator) || this.minScaleDenominator <= 0.0) {
            return (Double)this.getMinMaxScaleDenominatorFromMetrics().getLeft();
        }
        return this.minScaleDenominator;
    }

    private Pair<Double, Double> getMinMaxScaleDenominatorFromMetrics() {
        double min = Double.MAX_VALUE;
        double max = Double.MIN_VALUE;
        boolean newMin = false;
        boolean newMax = false;
        Set<Range> ranges = this.getScaleRange();
        for (Range range : ranges) {
            if (min > (Double)range.getMinValue()) {
                min = (Double)range.getMinValue();
                newMin = true;
            }
            if (!(max < (Double)range.getMaxValue())) continue;
            max = (Double)range.getMaxValue();
            newMax = true;
        }
        if (!newMin) {
            min = Double.MIN_VALUE;
        }
        if (!newMax) {
            max = Double.MAX_VALUE;
        }
        return new Pair((Object)min, (Object)max);
    }

    @Override
    public void setMinScaleDenominator(double newMinScaleDenominator) {
        double oldMinScaleDenominator = this.minScaleDenominator;
        this.minScaleDenominator = newMinScaleDenominator;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 16, oldMinScaleDenominator, this.minScaleDenominator));
        }
    }

    @Override
    public double getMaxScaleDenominator() {
        if (Double.isNaN(this.maxScaleDenominator) || this.maxScaleDenominator <= 0.0) {
            return (Double)this.getMinMaxScaleDenominatorFromMetrics().getRight();
        }
        return this.maxScaleDenominator;
    }

    @Override
    public void setMaxScaleDenominator(double newMaxScaleDenominator) {
        double oldMaxScaleDenominator = this.maxScaleDenominator;
        this.maxScaleDenominator = newMaxScaleDenominator;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 17, oldMaxScaleDenominator, this.maxScaleDenominator));
        }
    }

    @Override
    public java.util.Map<Interaction, Boolean> getInteractionMap() {
        if (this.interactionMap == null) {
            this.interactionMap = new EcoreEMap(ProjectPackage.Literals.INTERACTION_TO_EBOOLEAN_OBJECT_MAP_ENTRY, InteractionToEBooleanObjectMapEntryImpl.class, (InternalEObject)this, 18);
        }
        return this.interactionMap.map();
    }

    @Override
    public boolean isShown() {
        return this.shown;
    }

    @Override
    public void setShown(boolean newShown) {
        boolean oldShown = this.shown;
        this.shown = newShown;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 19, oldShown, this.shown));
        }
    }

    public Object getAdapter(Class adapter) {
        IGeoResource resource;
        if (adapter == IGeoResource.class) {
            System.out.println("testing IGeoResource");
        }
        if (adapter.isAssignableFrom(IGeoResource.class)) {
            return this.getGeoResource();
        }
        if (IGeoResource.class.isAssignableFrom(adapter) && (resource = this.getGeoResource()) != null && adapter.isAssignableFrom(resource.getClass())) {
            return resource;
        }
        if (IMap.class.isAssignableFrom(adapter)) {
            return this.getMap();
        }
        EList adapters = this.eAdapters();
        if (adapters instanceof SynchronizedEList) {
            ((SynchronizedEList)adapters).lock();
        }
        try {
            for (Object o : adapters) {
                if (!adapter.isAssignableFrom(o.getClass())) continue;
                Object e = o;
                return e;
            }
        }
        finally {
            if (adapters instanceof SynchronizedEList) {
                ((SynchronizedEList)adapters).unlock();
            }
        }
        if (adapter.isAssignableFrom(IWorkbenchAdapter.class)) {
            return new WorkbenchAdapter(){

                public String getLabel(Object object) {
                    return LayerImpl.this.getName();
                }
            };
        }
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    @Override
    public CoordinateReferenceSystem getCRS(IProgressMonitor monitor) {
        if (this.cRS != null) {
            return this.cRS;
        }
        return this.getCRSInternal(monitor);
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 0: {
                if (this.eInternalContainer() != null) {
                    msgs = this.eBasicRemoveFromContainer(msgs);
                }
                return this.basicSetContextModel((ContextModel)otherEnd, msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 0: {
                return this.basicSetContextModel(null, msgs);
            }
            case 2: {
                return this.basicSetStyleBlackboard(null, msgs);
            }
            case 18: {
                return ((InternalEList)((EMap.InternalMapView)this.getInteractionMap()).eMap()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
        switch (this.eContainerFeatureID()) {
            case 0: {
                return this.eInternalContainer().eInverseRemove((InternalEObject)this, 0, ContextModel.class, msgs);
            }
        }
        return super.eBasicRemoveFromContainerFeature(msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getContextModel();
            }
            case 1: {
                return this.getFilter();
            }
            case 2: {
                return this.getStyleBlackboard();
            }
            case 3: {
                return this.getZorder();
            }
            case 4: {
                return this.getStatus();
            }
            case 5: {
                return this.getName();
            }
            case 6: {
                return this.getCatalogRef();
            }
            case 7: {
                return this.getID();
            }
            case 8: {
                return this.isVisible();
            }
            case 9: {
                return this.getGeoResource();
            }
            case 10: {
                return this.getGeoResources();
            }
            case 11: {
                return this.getCRS();
            }
            case 12: {
                return this.getProperties();
            }
            case 13: {
                return this.getColourScheme();
            }
            case 14: {
                return this.getDefaultColor();
            }
            case 15: {
                return this.getFeatureChanges();
            }
            case 16: {
                return this.getMinScaleDenominator();
            }
            case 17: {
                return this.getMaxScaleDenominator();
            }
            case 18: {
                if (coreType) {
                    return ((EMap.InternalMapView)this.getInteractionMap()).eMap();
                }
                return this.getInteractionMap();
            }
            case 19: {
                return this.isShown();
            }
            case 20: {
                return this.getIcon();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setContextModel((ContextModel)newValue);
                return;
            }
            case 1: {
                this.setFilter((Filter)newValue);
                return;
            }
            case 2: {
                this.setStyleBlackboard((StyleBlackboard)newValue);
                return;
            }
            case 3: {
                this.setZorder((Integer)newValue);
                return;
            }
            case 4: {
                this.setStatus((Integer)newValue);
                return;
            }
            case 5: {
                this.setName((String)newValue);
                return;
            }
            case 6: {
                this.setCatalogRef((CatalogRef)newValue);
                return;
            }
            case 7: {
                this.setID((URL)newValue);
                return;
            }
            case 8: {
                this.setVisible((Boolean)newValue);
                return;
            }
            case 9: {
                this.setGeoResource((IGeoResource)newValue);
                return;
            }
            case 11: {
                this.setCRS((CoordinateReferenceSystem)newValue);
                return;
            }
            case 13: {
                this.setColourScheme((ColourScheme)newValue);
                return;
            }
            case 14: {
                this.setDefaultColor((Color)newValue);
                return;
            }
            case 15: {
                this.getFeatureChanges().clear();
                this.getFeatureChanges().addAll((Collection)newValue);
                return;
            }
            case 16: {
                this.setMinScaleDenominator((Double)newValue);
                return;
            }
            case 17: {
                this.setMaxScaleDenominator((Double)newValue);
                return;
            }
            case 18: {
                ((EStructuralFeature.Setting)((EMap.InternalMapView)this.getInteractionMap()).eMap()).set(newValue);
                return;
            }
            case 19: {
                this.setShown((Boolean)newValue);
                return;
            }
            case 20: {
                this.setIcon((ImageDescriptor)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.setContextModel(null);
                return;
            }
            case 1: {
                this.setFilter(FILTER_EDEFAULT);
                return;
            }
            case 2: {
                this.setStyleBlackboard(null);
                return;
            }
            case 3: {
                this.setZorder(0);
                return;
            }
            case 4: {
                this.setStatus(0);
                return;
            }
            case 5: {
                this.setName(NAME_EDEFAULT);
                return;
            }
            case 6: {
                this.setCatalogRef(CATALOG_REF_EDEFAULT);
                return;
            }
            case 7: {
                this.setID(ID_EDEFAULT);
                return;
            }
            case 8: {
                this.setVisible(true);
                return;
            }
            case 9: {
                this.setGeoResource(GEO_RESOURCE_EDEFAULT);
                return;
            }
            case 11: {
                this.setCRS(CRS_EDEFAULT);
                return;
            }
            case 13: {
                this.setColourScheme(COLOUR_SCHEME_EDEFAULT);
                return;
            }
            case 14: {
                this.setDefaultColor(DEFAULT_COLOR_EDEFAULT);
                return;
            }
            case 15: {
                this.getFeatureChanges().clear();
                return;
            }
            case 16: {
                this.setMinScaleDenominator(Double.NaN);
                return;
            }
            case 17: {
                this.setMaxScaleDenominator(Double.NaN);
                return;
            }
            case 18: {
                this.getInteractionMap().clear();
                return;
            }
            case 19: {
                this.setShown(false);
                return;
            }
            case 20: {
                this.setIcon(ICON_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.getContextModel() != null;
            }
            case 1: {
                return FILTER_EDEFAULT == null ? this.filter != null : !FILTER_EDEFAULT.equals(this.filter);
            }
            case 2: {
                return this.styleBlackboard != null;
            }
            case 3: {
                return this.zorder != 0;
            }
            case 4: {
                return this.status != 0;
            }
            case 5: {
                return NAME_EDEFAULT == null ? this.name != null : !NAME_EDEFAULT.equals(this.name);
            }
            case 6: {
                return CATALOG_REF_EDEFAULT == null ? this.catalogRef != null : !CATALOG_REF_EDEFAULT.equals(this.catalogRef);
            }
            case 7: {
                return ID_EDEFAULT == null ? this.iD != null : !ID_EDEFAULT.equals(this.iD);
            }
            case 8: {
                return !this.visible;
            }
            case 9: {
                return GEO_RESOURCE_EDEFAULT == null ? this.geoResource != null : !GEO_RESOURCE_EDEFAULT.equals((Object)this.geoResource);
            }
            case 10: {
                return this.geoResources != null && !this.geoResources.isEmpty();
            }
            case 11: {
                return CRS_EDEFAULT == null ? this.cRS != null : !CRS_EDEFAULT.equals(this.cRS);
            }
            case 12: {
                return this.properties != null;
            }
            case 13: {
                return COLOUR_SCHEME_EDEFAULT == null ? this.colourScheme != null : !COLOUR_SCHEME_EDEFAULT.equals((Object)this.colourScheme);
            }
            case 14: {
                return DEFAULT_COLOR_EDEFAULT == null ? this.defaultColor != null : !DEFAULT_COLOR_EDEFAULT.equals(this.defaultColor);
            }
            case 15: {
                return this.featureChanges != null && !this.featureChanges.isEmpty();
            }
            case 16: {
                return this.minScaleDenominator != Double.NaN;
            }
            case 17: {
                return this.maxScaleDenominator != Double.NaN;
            }
            case 18: {
                return this.interactionMap != null && !this.interactionMap.isEmpty();
            }
            case 19: {
                return this.shown;
            }
            case 20: {
                return ICON_EDEFAULT == null ? this.icon != null : !ICON_EDEFAULT.equals(this.icon);
            }
        }
        return super.eIsSet(featureID);
    }

    private CoordinateReferenceSystem getCRSInternal(IProgressMonitor monitor) {
        try {
            CoordinateReferenceSystem crs = this.getGeoResource().getInfo(monitor).getCRS();
            if (crs != null) {
                return crs;
            }
        }
        catch (Exception e) {
            ProjectPlugin.log(null, e);
        }
        List<IGeoResource> list = this.getGeoResources();
        for (IGeoResource resource : list) {
            try {
                if (resource.getInfo(monitor).getCRS() == null) continue;
                return resource.getInfo(monitor).getCRS();
            }
            catch (Exception e) {
                ProjectPlugin.log(null, e);
            }
        }
        return UNKNOWN_CRS;
    }

    @Override
    public void refresh(Envelope bounds) {
        if (!this.isVisible()) {
            return;
        }
        if (this.getMap() == null || this.getMap().getRenderManager() == null) {
            return;
        }
        Envelope transformedbounds = bounds;
        if (bounds != null) {
            try {
                transformedbounds = JTS.transform((Envelope)bounds, (MathTransform)this.layerToMapTransform());
            }
            catch (TransformException e) {
                ProjectPlugin.log("", e);
                transformedbounds = bounds;
            }
        }
        this.getMap().getRenderManager().refresh(this, transformedbounds);
    }

    @Override
    public MathTransform layerToMapTransform() {
        LinearTransform layerToMapTransform;
        try {
            layerToMapTransform = CRS.findMathTransform((CoordinateReferenceSystem)this.getCRS(), (CoordinateReferenceSystem)this.getMap().getViewportModel().getCRS(), (boolean)true);
        }
        catch (Exception exception) {
            layerToMapTransform = IdentityTransform.create((int)2);
        }
        return layerToMapTransform;
    }

    @Override
    public MathTransform mapToLayerTransform() {
        LinearTransform mapToLayerTransform;
        try {
            mapToLayerTransform = CRS.findMathTransform((CoordinateReferenceSystem)this.getMap().getViewportModel().getCRS(), (CoordinateReferenceSystem)this.getCRS(), (boolean)true);
        }
        catch (Exception exception) {
            mapToLayerTransform = IdentityTransform.create((int)2);
        }
        return mapToLayerTransform;
    }

    @Override
    public void setBounds(ReferencedEnvelope bounds) {
        this.bounds = bounds;
    }

    @Override
    public ReferencedEnvelope getBounds(IProgressMonitor monitor, CoordinateReferenceSystem crs) {
        ReferencedEnvelope result;
        if (crs == null) {
            crs = this.getCRS();
        }
        if ((result = this.bounds == null ? this.obtainBoundsFromResources(monitor) : this.bounds) != null && !result.isNull()) {
            DefaultEngineeringCRS generic2d = DefaultEngineeringCRS.GENERIC_2D;
            if (crs != null && result.getCoordinateReferenceSystem() != generic2d) {
                try {
                    result = result.transform(crs, true);
                }
                catch (Exception fe) {
                    ProjectPlugin.log("failure to transform layer bounds", fe);
                }
            }
        } else {
            return new ReferencedEnvelope(new Envelope(), null);
        }
        return result;
    }

    private ReferencedEnvelope obtainBoundsFromResources(IProgressMonitor monitor) {
        ReferencedEnvelope result = null;
        for (IGeoResource resource : this.getGeoResources()) {
            IGeoResourceInfo info = this.getInfo(resource, monitor);
            ReferencedEnvelope tmp = null;
            if (info != null) {
                tmp = info.getBounds();
            }
            if ((result = tmp instanceof ReferencedEnvelope && tmp.getCoordinateReferenceSystem() != null ? tmp : new ReferencedEnvelope(tmp.getMinX(), tmp.getMaxX(), tmp.getMinY(), tmp.getMaxY(), this.getCRS())) != null) break;
        }
        return result;
    }

    private IGeoResourceInfo getInfo(final IGeoResource resource, final IProgressMonitor monitor) {
        Callable<IGeoResourceInfo> job = new Callable<IGeoResourceInfo>(){

            @Override
            public IGeoResourceInfo call() throws Exception {
                return resource.getInfo(monitor);
            }
        };
        FutureTask<IGeoResourceInfo> task = new FutureTask<IGeoResourceInfo>(job);
        Thread t = new Thread(task);
        t.start();
        IGeoResourceInfo info = null;
        try {
            info = task.get();
        }
        catch (InterruptedException interruptedException) {
        }
        catch (ExecutionException executionException) {}
        return info;
    }

    @Override
    public Filter createBBoxFilter(Envelope boundingBox, IProgressMonitor monitor) {
        FilterFactory2 factory = (FilterFactory2)CommonFactoryFinder.getFilterFactory((Hints)GeoTools.getDefaultHints());
        Intersects bboxFilter = null;
        if (!this.hasResource(FeatureSource.class)) {
            return Filter.EXCLUDE;
        }
        try {
            Envelope bbox;
            try {
                MathTransform transform = this.mapToLayerTransform();
                bbox = JTS.transform((Envelope)boundingBox, (MathTransform)transform);
            }
            catch (Exception exception) {
                bbox = boundingBox;
            }
            String geom = this.getSchema().getGeometryDescriptor().getName().getLocalPart();
            Geometry bboxGeom = new GeometryFactory().toGeometry(bbox);
            bboxFilter = factory.intersects((Expression)factory.property(geom), (Expression)factory.literal((Object)bboxGeom));
        }
        catch (Exception e) {
            ProjectPlugin.getPlugin().log(e);
        }
        return bboxFilter;
    }

    @Override
    public Map getMapInternal() {
        ContextModel context = this.getContextModel();
        if (context == null) {
            return null;
        }
        return context.getMap();
    }

    @Override
    public IMap getMap() {
        return this.getMapInternal();
    }

    public <T> T getAdapter(Class<T> adapter, IProgressMonitor monitor) throws IOException {
        if (this.hasResource(adapter)) {
            ArrayList<T> list = new ArrayList<T>();
            monitor.beginTask(Messages.LayerImpl_resolveAdapter, -1);
            list.add(this.getResource(adapter, monitor));
            return (T)list.get(0);
        }
        if (adapter.isAssignableFrom(CoordinateReferenceSystem.class)) {
            return adapter.cast(this.getCRS(monitor));
        }
        return null;
    }

    public <T> boolean canAdaptTo(Class<T> adapter) {
        return this.hasResource(adapter) || adapter.isAssignableFrom(CoordinateReferenceSystem.class);
    }

    @Override
    public void setStatusMessage(String message) {
        this.statusMessage = message == null ? "" : message;
    }

    @Override
    public String getStatusMessage() {
        if (this.geoResources == NULL || this.status == 2) {
            return this.statusMessage;
        }
        if (this.isUnknownCRS()) {
            return Messages.LayerImpl_unkownCRS;
        }
        return this.statusMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EList eAdapters() {
        if (this.eAdapters == null) {
            LayerImpl layerImpl = this;
            synchronized (layerImpl) {
                if (this.eAdapters == null) {
                    this.eAdapters = new SynchronizedEList(super.eAdapters());
                }
            }
        }
        return this.eAdapters;
    }

    void resetConnection(IResolveDelta delta) {
        if (PlatformUI.getWorkbench().isClosing() || this.getMap() == null) {
            return;
        }
        this.warned = false;
        if (delta.getKind() == IResolveDelta.Kind.CHANGED) {
            Map map = this.getMapInternal();
            Resource eResource = map.eResource();
            if (eResource != null) {
                eResource.setModified(true);
            }
            if (delta.getNewValue() == null) {
                if (delta.getOldValue() == null) {
                    return;
                }
                return;
            }
            if (delta.getNewValue().equals(delta.getOldValue())) {
                return;
            }
            if (delta.getNewValue() instanceof Envelope) {
                this.updateBounds();
            } else {
                this.resetGeoResources();
            }
        } else if (delta.getKind() == IResolveDelta.Kind.REPLACED) {
            this.resetGeoResources();
        }
    }

    private void updateBounds() {
        ProjectPlugin.trace("net.refractions.udig.project/debug/model/trace", this.getClass(), "bounds changed " + this.getID(), null);
        this.refresh(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetGeoResources() {
        LayerImpl layerImpl = this;
        synchronized (layerImpl) {
            this.geoResources = null;
            this.geoResource = null;
            this.cRS = null;
            this.unknownCRS = null;
        }
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 10, null, null));
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 9, null, null));
            ProjectPlugin.trace("net.refractions.udig.project/debug/model/trace", this.getClass(), "Smack " + this.getID(), null);
            this.refresh(null);
        }
    }

    public void changed(IResolveChangeEvent event) {
        if (this.eIsProxy()) {
            CatalogPlugin.removeListener((IResolveChangeListener)this);
            return;
        }
        if (this.getMap() == null) {
            this.geoResources = null;
            return;
        }
        if (this.geoResources == null) {
            return;
        }
        if (this.gettingResources.get()) {
            return;
        }
        if (event.getType() != IResolveChangeEvent.Type.POST_CHANGE) {
            return;
        }
        IResolveDelta delta = event.getDelta();
        IResolve hit = event.getResolve();
        if (delta.getKind() == IResolveDelta.Kind.CHANGED && hit != null) {
            ID affected = hit.getID();
            ID id = this.getResourceID();
            if (id == null) {
                return;
            }
            EList<IGeoResource> resources = this.geoResources;
            for (IGeoResource resource : resources) {
                if (!affected.equals((Object)resource.getID())) continue;
                this.resetConnection(delta);
                return;
            }
        }
        if ((delta = SearchIDDeltaVisitor.search((URL)this.getID(), (IResolveChangeEvent)event)) != null) {
            ProjectPlugin.trace("net.refractions.udig.project/debug/model/trace", this.getClass(), "Reset resource" + this.getID(), null);
            this.resetConnection(delta);
        }
    }

    public static int doComparison(ILayer layer, ILayer layer2) {
        int i2;
        if (layer2 == null) {
            return 1;
        }
        if (layer2 == layer) {
            return 0;
        }
        int i1 = layer.getZorder();
        if (i1 == (i2 = layer2.getZorder())) {
            return 0;
        }
        return i1 < i2 ? -1 : 1;
    }

    @Override
    public Set<Range> getScaleRange() {
        Map mapInternal = this.getMapInternal();
        if (mapInternal == null) {
            return Collections.emptySet();
        }
        RenderManager manager = mapInternal.getRenderManagerInternal();
        if (manager == null) {
            return Collections.emptySet();
        }
        RendererCreator rendererCreator = manager.getRendererCreator();
        if (rendererCreator == null) {
            return Collections.emptySet();
        }
        Collection<AbstractRenderMetrics> metrics = rendererCreator.getAvailableRendererMetrics(this);
        HashSet<Range> allRanges = new HashSet<Range>();
        for (AbstractRenderMetrics metrics2 : metrics) {
            try {
                if (!metrics2.getRenderMetricsFactory().canRender(metrics2.getRenderContext())) continue;
                allRanges.addAll(metrics2.getValidScaleRanges());
            }
            catch (IOException iOException) {}
        }
        return allRanges;
    }
}

