/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.internal.impl;

import java.net.URI;
import java.util.Set;
import javax.swing.Icon;
import net.refractions.udig.catalog.IGeoResourceInfo;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.IResourceInterceptor;
import net.refractions.udig.project.internal.impl.LayerImpl;
import net.refractions.udig.project.internal.impl.MapImpl;
import org.eclipse.jface.resource.ImageDescriptor;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.crs.DefaultEngineeringCRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class GeoResourceInfoInterceptor
implements IResourceInterceptor<IGeoResourceInfo> {
    static final ReferencedEnvelope UNKNOWN_BOUNDS = new ReferencedEnvelope(-179.99, 179.99, -79.99, 79.99, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);

    @Override
    public IGeoResourceInfo run(ILayer layer, IGeoResourceInfo resource, Class requestedType) {
        if (layer instanceof LayerImpl) {
            LayerImpl impl = (LayerImpl)layer;
            return new Wrapper(impl, resource);
        }
        return resource;
    }

    private static class Wrapper
    extends IGeoResourceInfo {
        private final IGeoResourceInfo info;
        private LayerImpl layer;

        public Wrapper(LayerImpl impl, IGeoResourceInfo info) {
            this.info = info;
            this.layer = impl;
        }

        public ReferencedEnvelope getBounds() {
            ReferencedEnvelope tmp = this.info.getBounds();
            if (tmp == null) {
                ReferencedEnvelope referencedEnvelope = MapImpl.toReferencedEnvelope(this.getCRS().getDomainOfValidity(), this.getCRS());
                if (referencedEnvelope != null) {
                    return referencedEnvelope;
                }
                tmp = UNKNOWN_BOUNDS;
            }
            if (tmp.isNull()) {
                return new ReferencedEnvelope(this.getCRS());
            }
            return tmp;
        }

        public CoordinateReferenceSystem getCRS() {
            if (this.layer.cRS != null) {
                return this.layer.cRS;
            }
            CoordinateReferenceSystem crs = this.info.getCRS();
            if (crs == null) {
                return DefaultEngineeringCRS.GENERIC_2D;
            }
            return crs;
        }

        public String getDescription() {
            return this.info.getDescription();
        }

        public ImageDescriptor getImageDescriptor() {
            return this.info.getImageDescriptor();
        }

        public Icon getIcon() {
            return this.info.getIcon();
        }

        public Set<String> getKeywords() {
            return this.info.getKeywords();
        }

        public String getName() {
            return this.info.getName();
        }

        public URI getSchema() {
            return this.info.getSchema();
        }

        public String getTitle() {
            return this.info.getTitle();
        }

        public String toString() {
            return this.info.toString();
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.info == null ? 0 : this.info.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Wrapper other = (Wrapper)((Object)obj);
            return !(this.info == null ? other.info != null : !this.info.equals(other.info));
        }
    }
}

