/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.internal.impl;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import net.refractions.udig.core.internal.ExtensionPointProcessor;
import net.refractions.udig.core.internal.ExtensionPointUtil;
import net.refractions.udig.project.BlackboardEvent;
import net.refractions.udig.project.IBlackboard;
import net.refractions.udig.project.IBlackboardListener;
import net.refractions.udig.project.IPersister;
import net.refractions.udig.project.IProvider;
import net.refractions.udig.project.internal.Blackboard;
import net.refractions.udig.project.internal.BlackboardEntry;
import net.refractions.udig.project.internal.ProjectPackage;
import net.refractions.udig.project.internal.ProjectPlugin;
import net.refractions.udig.project.internal.impl.BlackboardEntryImpl;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.XMLMemento;

public class BlackboardImpl
extends EObjectImpl
implements Blackboard {
    HashMap<String, BlackboardEntry> blackboard = new HashMap();
    ArrayList<IPersister<?>> persisters;
    ArrayList<IProvider<Object>> providers;
    boolean initialized = false;
    protected EList<BlackboardEntry> entries;
    CopyOnWriteArraySet<IBlackboardListener> listeners = new CopyOnWriteArraySet();

    protected BlackboardImpl() {
    }

    protected EClass eStaticClass() {
        return ProjectPackage.Literals.BLACKBOARD;
    }

    @Override
    public List<BlackboardEntry> getEntries() {
        if (this.entries == null) {
            this.entries = new EObjectContainmentEList(BlackboardEntry.class, (InternalEObject)this, 0);
        }
        return this.entries;
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 0: {
                return ((InternalEList)this.getEntries()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getEntries();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.getEntries().clear();
                this.getEntries().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.getEntries().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.entries != null && !this.entries.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public boolean contains(String key) {
        return this.get(key) != null;
    }

    @Override
    public Object get(String key) {
        if (!this.initialized) {
            this.initialize();
        }
        if (key == null) {
            return null;
        }
        BlackboardEntry entry = this.blackboard.get(key);
        if (entry != null) {
            String memento2;
            Object object;
            block12: {
                if (entry.getObject() != null) {
                    return entry.getObject();
                }
                object = null;
                memento2 = entry.getMemento();
                if (memento2 != null && memento2.length() != 0) break block12;
                return null;
            }
            try {
                XMLMemento memento = XMLMemento.createReadRoot((Reader)new StringReader(memento2));
                IPersister<?> persister = this.findPersister(entry, memento);
                if (persister != null) {
                    object = persister.load((IMemento)memento);
                    entry.setObject(object);
                    entry.setObjectClass(object.getClass());
                }
            }
            catch (Exception e) {
                String msg = "Error loading content: " + entry.getObjectClass();
                Status status = new Status(2, "net.refractions.udig.project", 0, msg, (Throwable)e);
                ProjectPlugin.getPlugin().getLog().log((IStatus)status);
            }
            return object;
        }
        IProvider provider = this.findProvider(key);
        if (provider != null) {
            try {
                Object object = provider.provide();
                if (object != null) {
                    this.createEntry(key, object);
                    return object;
                }
            }
            catch (Exception e) {
                String msg = "provider exception :" + key;
                String id = provider.getExtension().getNamespace();
                Status status = new Status(2, id, 0, msg, (Throwable)e);
                ProjectPlugin.getPlugin().getLog().log((IStatus)status);
            }
        }
        return null;
    }

    private void initialize() {
        this.initialized = true;
        for (BlackboardEntry entry : this.getEntries()) {
            this.blackboard.put(entry.getKey(), entry);
        }
    }

    @Override
    public Object remove(String key) {
        if (key == null) {
            return null;
        }
        BlackboardEntry entry = this.blackboard.remove(key);
        if (entry == null) {
            return null;
        }
        Object oldValue = entry.getObject();
        entry.setMemento(null);
        entry.setObject(null);
        BlackboardEvent event = new BlackboardEvent(this, key, oldValue, null);
        for (IBlackboardListener l : this.listeners) {
            try {
                l.blackBoardChanged(event);
            }
            catch (Exception e) {
                ProjectPlugin.log("", e);
            }
        }
        return oldValue;
    }

    @Override
    public void put(String key, Object value) {
        if (key == null) {
            return;
        }
        if (value == null) {
            this.remove(key);
            return;
        }
        Object oldValue = null;
        BlackboardEntry entry = this.blackboard.get(key);
        if (entry == null) {
            entry = this.createEntry(key, value);
        } else {
            oldValue = entry.getObject();
        }
        entry.setObject(value);
        IPersister<?> persister = this.findPersister(entry, null);
        try {
            if (persister != null) {
                XMLMemento memento = XMLMemento.createWriteRoot((String)"blackboardContent");
                persister.save(value, (IMemento)memento);
                memento.putString("internalObjectClassStorage", entry.getObjectClass().getName());
                StringWriter writer = new StringWriter();
                memento.save((Writer)writer);
                entry.setMemento(writer.getBuffer().toString());
            }
        }
        catch (Exception e) {
            String msg = "Error persisting content: " + value.getClass();
            if (persister != null) {
                IExtension ext = persister.getExtension();
                Status status = new Status(2, ext.getNamespaceIdentifier(), 0, msg, (Throwable)e);
                ProjectPlugin.getPlugin().getLog().log((IStatus)status);
            }
            ProjectPlugin.log("error loading persister", e);
        }
        BlackboardEvent event = new BlackboardEvent(this, key, oldValue, value);
        for (IBlackboardListener l : this.listeners) {
            try {
                l.blackBoardChanged(event);
            }
            catch (Exception e) {
                ProjectPlugin.log("", e);
            }
        }
    }

    @Override
    public Float getFloat(String key) {
        Object o = this.get(key);
        if (o != null && o instanceof Float) {
            return (Float)o;
        }
        return null;
    }

    @Override
    public Integer getInteger(String key) {
        Object o = this.get(key);
        if (o != null && o instanceof Integer) {
            return (Integer)o;
        }
        return null;
    }

    @Override
    public String getString(String key) {
        Object o = this.get(key);
        if (o != null && o instanceof String) {
            return (String)o;
        }
        return null;
    }

    @Override
    public void putFloat(String key, float value) {
        this.put(key, Float.valueOf(value));
    }

    @Override
    public void putInteger(String key, int value) {
        this.put(key, value);
    }

    @Override
    public void putString(String key, String value) {
        this.put(key, value);
    }

    @Override
    public void clear() {
        this.blackboard.clear();
        for (IBlackboardListener l : this.listeners) {
            l.blackBoardCleared(this);
        }
    }

    @Override
    public boolean addListener(IBlackboardListener listener) {
        return this.listeners.add(listener);
    }

    @Override
    public boolean removeListener(IBlackboardListener listener) {
        return this.listeners.remove(listener);
    }

    @Override
    public void flush() {
        for (BlackboardEntry entry : this.blackboard.values()) {
            entry.setObject(null);
        }
    }

    private IProvider findProvider(String key) {
        if (this.providers == null) {
            this.providers = new ArrayList();
            ProviderProcessor p = new ProviderProcessor(this.providers);
            ExtensionPointUtil.process((Plugin)ProjectPlugin.getPlugin(), (String)"net.refractions.udig.project.provider", (ExtensionPointProcessor)p);
        }
        for (IProvider<Object> provider : this.providers) {
            if (provider.getKey() == null || !provider.getKey().equals(key)) continue;
            return provider;
        }
        return null;
    }

    private BlackboardEntryImpl createEntry(String key, Object object) {
        BlackboardEntryImpl entry = new BlackboardEntryImpl();
        entry.setKey(key);
        entry.setObjectClass(object != null ? object.getClass() : null);
        this.blackboard.put(key, entry);
        this.getEntries().add(entry);
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IPersister<?> findPersister(BlackboardEntry entry, XMLMemento memento) {
        if (this.persisters == null) {
            BlackboardImpl blackboardImpl = this;
            synchronized (blackboardImpl) {
                if (this.persisters == null) {
                    this.persisters = new ArrayList();
                    PersisterProcessor p = new PersisterProcessor(this.persisters);
                    ExtensionPointUtil.process((Plugin)ProjectPlugin.getPlugin(), (String)"net.refractions.udig.project.persister", (ExtensionPointProcessor)p);
                }
            }
        }
        ArrayList possible = new ArrayList();
        for (IPersister<?> persister : this.persisters) {
            Class type;
            Class<?> persistenceTarget = persister.getPersistee();
            if (persistenceTarget == null) continue;
            if (entry.getObjectClass() != null && persistenceTarget.isAssignableFrom(type = entry.getObjectClass())) {
                possible.add(persister);
                continue;
            }
            Class<?> objectClass = entry.getObjectClass();
            if (objectClass != null || memento == null) continue;
            String className = memento.getString("internalObjectClassStorage");
            if (className.equals(persistenceTarget)) {
                possible.add(persister);
                continue;
            }
            try {
                ClassLoader classLoader = persistenceTarget.getClassLoader();
                objectClass = classLoader != null ? classLoader.loadClass(className) : Class.forName(className);
                if (objectClass == null || !objectClass.isAssignableFrom(persistenceTarget)) continue;
                possible.add(persister);
            }
            catch (Exception e) {
                if (!ProjectPlugin.isDebugging("blackboard")) continue;
                ProjectPlugin.trace(BlackboardImpl.class, String.valueOf(persister.getExtension().getExtensionPointUniqueIdentifier()) + "unable to load " + className, e);
            }
        }
        if (possible.isEmpty()) {
            ProjectPlugin.trace(BlackboardImpl.class, String.valueOf(entry.getKey()) + " cannot be persisted", null);
            return null;
        }
        Collections.sort(possible, new Comparator<IPersister<?>>(){

            @Override
            public int compare(IPersister<?> p1, IPersister<?> p2) {
                if (p1.getPersistee().equals(p2.getPersistee())) {
                    return 0;
                }
                if (p1.getPersistee().isAssignableFrom(p2.getPersistee())) {
                    return -1;
                }
                return 1;
            }
        });
        return (IPersister)possible.get(0);
    }

    @Override
    public void addAll(IBlackboard blackboard) {
        Set<String> keySet = blackboard.keySet();
        for (String key : keySet) {
            this.put(key, blackboard.get(key));
        }
    }

    @Override
    public Set<String> keySet() {
        return this.blackboard.keySet();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("StyleBlackBoardImpl: ");
        buf.append(this.blackboard.size());
        buf.append(" entries");
        for (Map.Entry<String, BlackboardEntry> entry : this.blackboard.entrySet()) {
            buf.append("\n\t");
            buf.append((Object)entry.getKey());
            buf.append("=");
            buf.append(entry.getValue());
        }
        return buf.toString();
    }

    static class PersisterProcessor
    implements ExtensionPointProcessor {
        List<IPersister<?>> persisters;

        PersisterProcessor(List<IPersister<?>> persisters) {
            this.persisters = persisters;
        }

        public void process(IExtension extension, IConfigurationElement element) throws Exception {
            try {
                IPersister persister = (IPersister)element.createExecutableExtension("class");
                if (persister != null) {
                    persister.setExtension(extension);
                    this.persisters.add(persister);
                }
            }
            catch (Throwable t) {
                ProjectPlugin.log(t.getLocalizedMessage(), t);
            }
        }
    }

    static class ProviderProcessor
    implements ExtensionPointProcessor {
        List<IProvider<Object>> providers;

        ProviderProcessor(List<IProvider<Object>> providers) {
            this.providers = providers;
        }

        public void process(IExtension extension, IConfigurationElement element) throws Exception {
            try {
                IProvider provider = (IProvider)element.createExecutableExtension("class");
                if (provider != null) {
                    this.providers.add(provider);
                    provider.setExtension(extension);
                    if (element.getAttribute("key") != null) {
                        provider.setKey(element.getAttribute("key"));
                    }
                }
            }
            catch (Throwable t) {
                ProjectPlugin.log(t.getLocalizedMessage(), t);
            }
        }
    }
}

