/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.internal.impl;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.util.List;
import net.refractions.udig.project.IEditManager;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.IMap;
import net.refractions.udig.project.IProject;
import net.refractions.udig.project.internal.AbstractContext;
import net.refractions.udig.project.internal.EditManager;
import net.refractions.udig.project.internal.Map;
import net.refractions.udig.project.internal.Project;
import net.refractions.udig.project.internal.render.RenderManager;
import net.refractions.udig.project.internal.render.ViewportModel;
import net.refractions.udig.project.render.IRenderManager;
import net.refractions.udig.project.render.IViewportModel;
import net.refractions.udig.project.render.displayAdapter.IMapDisplay;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.feature.FeatureCollection;
import org.geotools.geometry.jts.Decimator;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.LiteShape2;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.referencing.operation.matrix.GeneralMatrix;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.TransformException;

public abstract class AbstractContextImpl
implements AbstractContext {
    protected RenderManager renderManagerInternal = null;
    protected Map mapInternal = null;

    public AbstractContextImpl() {
    }

    public AbstractContextImpl(AbstractContextImpl impl) {
        this.setMapInternal(impl.getMapInternal());
        this.setRenderManagerInternal(impl.getRenderManagerInternal());
    }

    @Override
    public IViewportModel getViewportModel() {
        RenderManager renderManagerInternal2 = this.getRenderManagerInternal();
        if (renderManagerInternal2 != null) {
            return renderManagerInternal2.getViewportModelInternal();
        }
        return this.getMap().getViewportModel();
    }

    @Override
    public IProject getProject() {
        return this.getMapInternal().getProject();
    }

    @Override
    public IEditManager getEditManager() {
        if (this.getMapInternal() != null) {
            return this.getMapInternal().getEditManager();
        }
        return null;
    }

    @Override
    public Coordinate getPixelSize() {
        return this.getViewportModel().getPixelSize();
    }

    @Override
    public ViewportModel getViewportModelInternal() {
        return this.getMapInternal().getViewportModelInternal();
    }

    @Override
    public EditManager getEditManagerInternal() {
        return this.getMapInternal().getEditManagerInternal();
    }

    @Override
    public RenderManager getRenderManagerInternal() {
        return this.renderManagerInternal;
    }

    @Override
    public void setRenderManagerInternal(RenderManager newRenderManagerInternal) {
        this.renderManagerInternal = newRenderManagerInternal;
    }

    @Override
    public IMapDisplay getMapDisplay() {
        if (this.getRenderManager() == null || this.getRenderManagerInternal().isDisposed()) {
            return null;
        }
        return this.getRenderManager().getMapDisplay();
    }

    @Override
    public IRenderManager getRenderManager() {
        return this.getRenderManagerInternal();
    }

    @Override
    public IMap getMap() {
        return this.getMapInternal();
    }

    @Override
    public Map getMapInternal() {
        return this.mapInternal;
    }

    @Override
    public void setMapInternal(Map newMapInternal) {
        this.mapInternal = newMapInternal;
    }

    @Override
    public Project getProjectInternal() {
        return this.getMapInternal().getProjectInternal();
    }

    @Override
    public AffineTransform worldToScreenTransform() {
        return this.getViewportModel().worldToScreenTransform();
    }

    @Override
    public Point worldToPixel(Coordinate coord) {
        return this.getViewportModel().worldToPixel(coord);
    }

    @Override
    public MathTransform2D worldToScreenMathTransform() {
        GeneralMatrix matrix = new GeneralMatrix(this.getViewportModelInternal().worldToScreenTransform());
        try {
            return (MathTransform2D)ReferencingFactoryFinder.getMathTransformFactory(null).createAffineTransform((Matrix)matrix);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public Coordinate pixelToWorld(int x, int y) {
        return this.getViewportModel().pixelToWorld(x, y);
    }

    @Override
    public ReferencedEnvelope worldBounds(Rectangle rectangle) {
        Envelope start = new Envelope((double)rectangle.x, (double)(rectangle.x + rectangle.width), (double)rectangle.y, (double)(rectangle.y + rectangle.height));
        Envelope end = null;
        try {
            end = JTS.transform((Envelope)start, null, (MathTransform)this.worldToScreenMathTransform().inverse(), (int)10);
        }
        catch (Exception exception) {
            return null;
        }
        return new ReferencedEnvelope(end, this.getViewportModel().getCRS());
    }

    @Override
    public Envelope getPixelBoundingBox(Point screenLocation) {
        return this.getBoundingBox(screenLocation, 1);
    }

    @Override
    public ReferencedEnvelope getBoundingBox(Point screenLocation, int scalefactor) {
        Coordinate center = this.pixelToWorld(screenLocation.x, screenLocation.y);
        Coordinate size = this.getPixelSize();
        double dw = size.x / 2.0 * (double)scalefactor;
        double dh = size.y / 2.0 * (double)scalefactor;
        Envelope e = new Envelope(center.x - dw, center.x + dw, center.y - dh, center.y + dh);
        return new ReferencedEnvelope(e, this.getCRS());
    }

    @Override
    public CoordinateReferenceSystem getCRS() {
        return this.getViewportModel().getCRS();
    }

    @Override
    public Shape toShape(ReferencedEnvelope envelope) {
        return this.toShape(new GeometryFactory().toGeometry((Envelope)envelope), envelope.getCoordinateReferenceSystem());
    }

    @Override
    public Shape toShape(Geometry geometry, CoordinateReferenceSystem crs) {
        try {
            MathTransform transform = CRS.findMathTransform((CoordinateReferenceSystem)crs, (CoordinateReferenceSystem)this.getCRS(), (boolean)true);
            MathTransformFactory factory = ReferencingFactoryFinder.getMathTransformFactory(null);
            MathTransform toScreen = factory.createAffineTransform((Matrix)new GeneralMatrix(this.worldToScreenTransform()));
            transform = factory.createConcatenatedTransform(transform, toScreen);
            return new LiteShape2(geometry, transform, new Decimator(transform), false);
        }
        catch (FactoryException factoryException) {
            return null;
        }
        catch (TransformException transformException) {
            return null;
        }
    }

    public Query getQuery(ILayer layer, boolean selection) {
        return layer.getQuery(selection);
    }

    @Override
    public FeatureCollection<SimpleFeatureType, SimpleFeature> getFeaturesInBbox(ILayer layer, Envelope bbox) throws IOException {
        return layer.getResource(FeatureSource.class, null).getFeatures(layer.createBBoxFilter(bbox, null));
    }

    @Override
    public List<ILayer> getMapLayers() {
        return this.getMap().getMapLayers();
    }

    @Override
    public ILayer getSelectedLayer() {
        return this.getEditManager().getSelectedLayer();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.mapInternal == null ? 0 : this.mapInternal.hashCode());
        result = 31 * result + (this.renderManagerInternal == null ? 0 : this.renderManagerInternal.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractContextImpl other = (AbstractContextImpl)obj;
        if (this.mapInternal == null ? other.mapInternal != null : !this.mapInternal.equals(other.mapInternal)) {
            return false;
        }
        return !(this.renderManagerInternal == null ? other.renderManagerInternal != null : !this.renderManagerInternal.equals(other.renderManagerInternal));
    }

    @Override
    public Point tranformCoordinate(Envelope bbox, Dimension displaySize, Coordinate coordinate) {
        AffineTransform at = this.getViewportModelInternal().worldToScreenTransform(bbox, displaySize);
        Point2D.Double w = new Point2D.Double(coordinate.x, coordinate.y);
        Point2D p = at.transform(w, new Point2D.Double());
        return new Point((int)p.getX(), (int)p.getY());
    }
}

