/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.internal.commands.selection;

import net.refractions.udig.core.internal.FeatureUtils;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.command.AbstractCommand;
import net.refractions.udig.project.command.UndoableMapCommand;
import net.refractions.udig.project.internal.Layer;
import net.refractions.udig.project.internal.Messages;
import org.eclipse.core.runtime.IProgressMonitor;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.Id;

public class FIDSelectCommand
extends AbstractCommand
implements UndoableMapCommand {
    private Layer layer;
    private String id;
    private Filter oldFilter;

    public FIDSelectCommand(ILayer layer, String featureID) {
        this.layer = (Layer)layer;
        this.id = featureID;
    }

    public FIDSelectCommand(ILayer layer, SimpleFeature feature) {
        this.layer = (Layer)layer;
        this.id = feature.getID();
    }

    @Override
    public void rollback(IProgressMonitor monitor) {
        if (this.oldFilter != null) {
            this.layer.setFilter(this.oldFilter);
        }
    }

    @Override
    public void run(IProgressMonitor monitor) {
        this.oldFilter = this.layer.getFilter();
        FilterFactory filterFactory = CommonFactoryFinder.getFilterFactory((Hints)GeoTools.getDefaultHints());
        Id filter = filterFactory.id(FeatureUtils.stringToId((FilterFactory)filterFactory, (String)this.id));
        this.layer.setFilter((Filter)filter);
    }

    @Override
    public String getName() {
        return Messages.FIDSelectCommand_featureSelection;
    }
}

