/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.internal.commands.selection;

import com.vividsolutions.jts.geom.Envelope;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.refractions.udig.project.command.AbstractCommand;
import net.refractions.udig.project.command.UndoableMapCommand;
import net.refractions.udig.project.internal.Layer;
import net.refractions.udig.project.internal.Messages;
import org.eclipse.core.runtime.IProgressMonitor;
import org.opengis.filter.Filter;

public class BBoxSelectionCommand
extends AbstractCommand
implements UndoableMapCommand {
    public static final int ADD = 1;
    public static final int NONE = 0;
    public static final int SUBTRACT = -1;
    Envelope bbox = null;
    private int modifiers;
    private Map<Layer, Filter> undoState = new HashMap<Layer, Filter>();

    public BBoxSelectionCommand(Envelope bbox, int modifiers) {
        this.bbox = bbox;
        this.modifiers = modifiers;
    }

    @Override
    public void rollback(IProgressMonitor monitor) throws Exception {
        Set<Map.Entry<Layer, Filter>> state = this.undoState.entrySet();
        for (Map.Entry<Layer, Filter> entry : state) {
            entry.getKey().setFilter(entry.getValue());
        }
    }

    @Override
    public void run(IProgressMonitor monitor) throws Exception {
        List<Layer> layers = this.getMap().getLayersInternal();
        for (Layer layer : layers) {
            this.undoState.put(layer, layer.getFilter());
        }
        if (this.modifiers == 0) {
            this.getMap().select(this.bbox);
        } else if (this.modifiers == 1) {
            this.getMap().select(this.bbox, true);
        } else if (this.modifiers == -1) {
            this.getMap().select(this.bbox, false);
        }
    }

    @Override
    public String getName() {
        return Messages.BBoxSelectionCommand_boxSelection;
    }
}

