/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.internal.commands.edit;

import net.refractions.udig.core.internal.FeatureUtils;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.command.MapCommand;
import net.refractions.udig.project.command.UndoableMapCommand;
import net.refractions.udig.project.internal.Layer;
import net.refractions.udig.project.internal.Messages;
import net.refractions.udig.project.internal.ProjectPlugin;
import net.refractions.udig.project.internal.commands.edit.AbstractEditCommand;
import org.eclipse.core.runtime.IProgressMonitor;
import org.geotools.data.FeatureStore;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.Id;

public class WriteEditFeatureCommand
extends AbstractEditCommand
implements UndoableMapCommand {
    private SimpleFeature old;
    private boolean added = false;
    private boolean noChange = false;

    @Override
    public void run(IProgressMonitor monitor) throws Exception {
        monitor.beginTask(Messages.WriteEditFeatureCommand_runTask, -1);
        SimpleFeature editFeature = this.getMap().getEditManager().getEditFeature();
        ILayer editLayer = this.getMap().getEditManager().getEditLayer();
        editFeature = this.getMap().getEditManagerInternal().getEditFeature();
        editLayer = this.getMap().getEditManagerInternal().getEditLayerInternal();
        if (editFeature == null || editLayer == null) {
            this.noChange = true;
            return;
        }
        this.old = SimpleFeatureBuilder.copy((SimpleFeature)editFeature);
        SimpleFeatureType featureType = editFeature.getFeatureType();
        FilterFactory factory = CommonFactoryFinder.getFilterFactory((Hints)GeoTools.getDefaultHints());
        FeatureStore store = editLayer.getResource(FeatureStore.class, null);
        Id filter = factory.id(FeatureUtils.stringToId((FilterFactory)factory, (String)editFeature.getID()));
        FeatureCollection results = store.getFeatures((Filter)filter);
        FeatureIterator reader = results.features();
        try {
            if (reader.hasNext()) {
                try {
                    store.modifyFeatures(featureType.getAttributeDescriptors().toArray(new AttributeDescriptor[0]), editFeature.getAttributes().toArray(), (Filter)filter);
                }
                catch (Exception e) {
                    ProjectPlugin.log("", e);
                    this.noChange = true;
                }
            } else {
                this.added = true;
                this.getMap().getEditManagerInternal().addFeature(editFeature, (Layer)editLayer);
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        monitor.done();
    }

    @Override
    public MapCommand copy() {
        return new WriteEditFeatureCommand();
    }

    @Override
    public String getName() {
        return Messages.SetEditFeatureCommand_setCurrentEditFeature;
    }

    @Override
    public void rollback(IProgressMonitor monitor) throws Exception {
        if (this.noChange) {
            return;
        }
        monitor.beginTask(Messages.WriteEditFeatureCommand_rollbackTask, -1);
        SimpleFeature editFeature = this.getMap().getEditManager().getEditFeature();
        ILayer editLayer = this.getMap().getEditManager().getEditLayer();
        if (editFeature == null || editLayer == null) {
            return;
        }
        FilterFactory factory = CommonFactoryFinder.getFilterFactory((Hints)GeoTools.getDefaultHints());
        Id filter = factory.id(FeatureUtils.stringToId((FilterFactory)factory, (String)this.old.getID()));
        FeatureStore store = editLayer.getResource(FeatureStore.class, null);
        if (this.added) {
            store.removeFeatures((Filter)filter);
            this.getMap().getEditManagerInternal().setEditFeature(null, null);
        } else {
            SimpleFeatureType featureType = this.old.getFeatureType();
            store.modifyFeatures(featureType.getAttributeDescriptors().toArray(new AttributeDescriptor[0]), this.old.getAttributes().toArray(), (Filter)filter);
        }
        monitor.done();
    }
}

