/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.internal.commands.edit;

import com.vividsolutions.jts.geom.Geometry;
import net.refractions.udig.core.IBlockingProvider;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.command.UndoableCommand;
import net.refractions.udig.project.internal.commands.edit.SetAttributeCommand;
import org.eclipse.core.runtime.IProgressMonitor;
import org.geotools.referencing.CRS;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class SetGeometryCommand
extends SetAttributeCommand
implements UndoableCommand {
    public static final String DEFAULT = "DEFAULT_GEOMETRY";

    public SetGeometryCommand(IBlockingProvider<SimpleFeature> feature, IBlockingProvider<ILayer> layer, String xpath, Geometry geom) {
        super(feature, layer, xpath, (Object)geom);
    }

    public SetGeometryCommand(String xpath, Geometry geom) {
        super(xpath, geom);
    }

    public SetGeometryCommand(String featureID, IBlockingProvider<ILayer> layer, String xpath, Geometry geom) {
        super(featureID, layer, xpath, geom);
    }

    @Override
    public void run(IProgressMonitor monitor) throws Exception {
        CoordinateReferenceSystem crs;
        Geometry geometry;
        SimpleFeatureType schema = ((ILayer)this.editLayer.get(monitor, new Object[0])).getSchema();
        GeometryDescriptor geometryDescriptor = schema.getGeometryDescriptor();
        if (this.xpath.equals(DEFAULT)) {
            this.xpath = geometryDescriptor.getName().getLocalPart();
        }
        if ((geometry = (Geometry)this.value).getUserData() == null && (crs = geometryDescriptor.getCoordinateReferenceSystem()) != null) {
            String srsName = CRS.toSRS((CoordinateReferenceSystem)crs);
            geometry.setUserData((Object)srsName);
        }
        super.run(monitor);
    }
}

