/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.internal.commands.edit;

import java.io.IOException;
import net.refractions.udig.core.IBlockingProvider;
import net.refractions.udig.core.StaticBlockingProvider;
import net.refractions.udig.core.internal.FeatureUtils;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.command.MapCommand;
import net.refractions.udig.project.command.UndoableMapCommand;
import net.refractions.udig.project.internal.Layer;
import net.refractions.udig.project.internal.Messages;
import net.refractions.udig.project.internal.commands.edit.AbstractLayerManagerControlCommand;
import org.eclipse.core.runtime.IProgressMonitor;
import org.geotools.data.FeatureSource;
import org.geotools.data.FeatureStore;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.feature.FeatureCollection;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.ExcludeFilter;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.identity.FeatureId;

public class SetEditFeatureCommand
extends AbstractLayerManagerControlCommand
implements UndoableMapCommand {
    private IBlockingProvider<SimpleFeature> newVictim;
    private IBlockingProvider<ILayer> newLayer;
    private SimpleFeature oldEditVictim;
    private Layer oldEditLayer;
    private Filter oldSelection;
    private Layer layer;

    public SetEditFeatureCommand(SimpleFeature feature, ILayer layer) {
        this.init((IBlockingProvider<SimpleFeature>)new StaticBlockingProvider((Object)feature), (IBlockingProvider<ILayer>)new StaticBlockingProvider((Object)layer));
    }

    public SetEditFeatureCommand(final SimpleFeature feature) {
        this.newLayer = new IBlockingProvider<ILayer>(){

            public ILayer get(IProgressMonitor monitor, Object ... objects) throws IOException {
                for (Layer thisLayer : SetEditFeatureCommand.this.editManager.getMapInternal().getLayersInternal()) {
                    FilterFactory filterFactory;
                    FeatureStore fs;
                    FeatureCollection results;
                    if (!thisLayer.hasResource(FeatureSource.class) || (results = (fs = (FeatureStore)thisLayer.getResource(FeatureStore.class, null)).getFeatures((Filter)(filterFactory = CommonFactoryFinder.getFilterFactory((Hints)GeoTools.getDefaultHints())).id(FeatureUtils.stringToId((FilterFactory)filterFactory, (String)feature.getID())))).size() != 1) continue;
                    return thisLayer;
                }
                return null;
            }
        };
        this.init((IBlockingProvider<SimpleFeature>)new StaticBlockingProvider((Object)feature), this.newLayer);
    }

    public SetEditFeatureCommand(IBlockingProvider<SimpleFeature> feature, IBlockingProvider<ILayer> layer) {
        this.init(feature, layer);
    }

    private void init(IBlockingProvider<SimpleFeature> feature, IBlockingProvider<ILayer> layer2) {
        this.newVictim = feature;
        this.newLayer = layer2;
    }

    @Override
    public void run(IProgressMonitor monitor) throws Exception {
        this.oldEditVictim = this.editManager.getEditFeature();
        this.oldEditLayer = this.editManager.getEditLayerInternal();
        if (this.newVictim == null) {
            this.editManager.setEditFeature(null, null);
            this.layer = (Layer)this.newLayer.get(monitor, new Object[0]);
            if (this.layer != null) {
                this.oldSelection = this.layer.getFilter();
                this.layer.setFilter((Filter)Filter.EXCLUDE);
            }
        } else {
            SimpleFeature feature = (SimpleFeature)this.newVictim.get(monitor, new Object[0]);
            this.layer = (Layer)this.newLayer.get(monitor, new Object[0]);
            if (this.layer != null) {
                ExcludeFilter filter;
                this.editManager.setEditFeature(feature, this.layer);
                this.oldSelection = this.layer.getFilter();
                if (feature == null) {
                    filter = Filter.EXCLUDE;
                } else {
                    FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2();
                    filter = ff.id(new FeatureId[]{feature.getIdentifier()});
                }
                this.layer.setFilter((Filter)filter);
            }
        }
    }

    @Override
    public MapCommand copy() {
        return new SetEditFeatureCommand(this.newVictim, this.newLayer);
    }

    @Override
    public String getName() {
        return Messages.SetEditFeatureCommand_setCurrentEditFeature;
    }

    @Override
    public void rollback(IProgressMonitor monitor) throws Exception {
        if (this.layer != null) {
            this.layer.setFilter(this.oldSelection);
        }
        this.editManager.setEditFeature(this.oldEditVictim, this.oldEditLayer);
    }
}

