/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.internal.commands.edit;

import net.refractions.udig.core.IBlockingProvider;
import net.refractions.udig.core.internal.FeatureUtils;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.command.MapCommand;
import net.refractions.udig.project.command.PostDeterminedEffectCommand;
import net.refractions.udig.project.command.UndoableMapCommand;
import net.refractions.udig.project.internal.Layer;
import net.refractions.udig.project.internal.Messages;
import net.refractions.udig.project.internal.commands.edit.AbstractEditCommand;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.geotools.data.FeatureStore;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;

public class DeleteFeatureCommand
extends AbstractEditCommand
implements UndoableMapCommand,
PostDeterminedEffectCommand {
    IBlockingProvider<SimpleFeature> featureProvider;
    private IBlockingProvider<ILayer> layerProvider;
    protected boolean done;
    private SimpleFeature feature;
    private ILayer oldLayer;

    public DeleteFeatureCommand(IBlockingProvider<SimpleFeature> featureProvider, IBlockingProvider<ILayer> layerProvider) {
        this.featureProvider = featureProvider;
        this.layerProvider = layerProvider;
    }

    @Override
    public void run(IProgressMonitor monitor) throws Exception {
        this.execute(monitor);
    }

    @Override
    public boolean execute(IProgressMonitor monitor) throws Exception {
        monitor.beginTask(Messages.DeleteFeatureCommand_deleteFeature, 4);
        monitor.worked(1);
        this.feature = (SimpleFeature)this.featureProvider.get((IProgressMonitor)new SubProgressMonitor(monitor, 1), new Object[0]);
        if (this.feature == null) {
            return false;
        }
        this.oldLayer = (ILayer)this.layerProvider.get((IProgressMonitor)new SubProgressMonitor(monitor, 1), new Object[0]);
        FilterFactory filterFactory = CommonFactoryFinder.getFilterFactory((Hints)GeoTools.getDefaultHints());
        this.oldLayer.getResource(FeatureStore.class, null).removeFeatures((Filter)filterFactory.id(FeatureUtils.stringToId((FilterFactory)filterFactory, (String)this.feature.getID())));
        this.map.getEditManagerInternal().setEditFeature(null, null);
        return true;
    }

    @Override
    public MapCommand copy() {
        return new DeleteFeatureCommand(this.featureProvider, this.layerProvider);
    }

    @Override
    public String getName() {
        return Messages.DeleteFeatureCommand_deleteFeature;
    }

    @Override
    public void rollback(IProgressMonitor monitor) throws Exception {
        if (this.feature == null) {
            return;
        }
        this.map.getEditManagerInternal().setEditFeature(this.feature, (Layer)this.oldLayer);
        this.map.getEditManagerInternal().addFeature(this.feature, (Layer)this.oldLayer);
    }
}

