/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.internal.commands.edit;

import java.net.URL;
import java.util.List;
import net.refractions.udig.catalog.CatalogPlugin;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.project.command.AbstractCommand;
import net.refractions.udig.project.command.UndoableMapCommand;
import net.refractions.udig.project.internal.Layer;
import net.refractions.udig.project.internal.Messages;
import org.eclipse.core.runtime.IProgressMonitor;

public class CreateLayerCommand
extends AbstractCommand
implements UndoableMapCommand {
    IGeoResource resource;
    private URL id;
    private Layer layer;

    public CreateLayerCommand(IGeoResource resource) {
        this.resource = resource;
        this.id = resource.getIdentifier();
    }

    public CreateLayerCommand(URL id2) {
        assert (id2.getRef() != null && id2.getRef().trim().length() != 0);
        this.id = id2;
    }

    @Override
    public void run(IProgressMonitor monitor) throws Exception {
        if (this.resource == null) {
            List resources = CatalogPlugin.getDefault().getLocalCatalog().find(this.id, monitor);
            if (resources.size() == 0) {
                throw new Exception(String.valueOf(Messages.CreateLayerCommand_badID) + this.id + Messages.CreateLayerCommand_badID2);
            }
            this.resource = (IGeoResource)resources.get(0);
        }
        this.layer = this.getMap().getLayerFactory().createLayer(this.resource);
        this.getMap().getLayersInternal().add(this.layer);
    }

    @Override
    public String getName() {
        return String.valueOf(Messages.CreateLayerCommand_name) + this.id;
    }

    @Override
    public void rollback(IProgressMonitor monitor) throws Exception {
        if (this.layer == null) {
            throw new IllegalStateException(String.valueOf(Messages.CreateLayerCommand_illegalRollback) + Messages.CreateLayerCommand_illegalRollback2);
        }
        this.getMap().getLayersInternal().remove(this.layer);
    }
}

