/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.internal.commands.edit;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import java.util.List;
import java.util.Random;
import net.refractions.udig.core.internal.ExtensionPointList;
import net.refractions.udig.core.internal.FeatureUtils;
import net.refractions.udig.core.internal.GeometryBuilder;
import net.refractions.udig.project.AdaptableFeature;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.command.MapCommand;
import net.refractions.udig.project.command.UndoableMapCommand;
import net.refractions.udig.project.interceptor.FeatureInterceptor;
import net.refractions.udig.project.internal.Layer;
import net.refractions.udig.project.internal.Messages;
import net.refractions.udig.project.internal.ProjectPlugin;
import net.refractions.udig.project.internal.commands.edit.AbstractEditCommand;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.geotools.data.FeatureStore;
import org.geotools.data.Transaction;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.referencing.CRS;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.util.CodeList;

public class CreateFeatureCommand
extends AbstractEditCommand
implements UndoableMapCommand {
    private Coordinate[] coordinates;
    String fid;

    public CreateFeatureCommand(Coordinate[] coordinates) {
        int i = 0;
        if (coordinates != null) {
            i = coordinates.length;
        }
        Coordinate[] c = new Coordinate[i];
        if (coordinates != null) {
            System.arraycopy(coordinates, 0, c, 0, c.length);
        }
        this.coordinates = c;
    }

    @Override
    public void run(IProgressMonitor monitor) throws Exception {
        ILayer editLayer = this.getMap().getEditManager().getEditLayer();
        if (editLayer == null) {
            editLayer = this.findEditLayer();
        }
        if (editLayer == null) {
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.CreateFeatureCommand_error_title, (String)Messages.CreateFeatureCommand_error_message);
            return;
        }
        FeatureStore store = editLayer.getResource(FeatureStore.class, null);
        this.transform();
        if (store.getTransaction() == Transaction.AUTO_COMMIT) {
            throw new Exception("Error transaction has not been started");
        }
        SimpleFeatureType type = (SimpleFeatureType)store.getSchema();
        String proposedFid = "newFeaturenewFeature" + new Random().nextInt();
        SimpleFeature newFeature = SimpleFeatureBuilder.template((SimpleFeatureType)type, (String)proposedFid);
        Class geomType = type.getGeometryDescriptor().getType().getBinding();
        Geometry geom = GeometryBuilder.create().safeCreateGeometry(geomType, this.coordinates);
        newFeature.setDefaultGeometry((Object)geom);
        this.fid = newFeature.getID();
        AdaptableFeature feature = new AdaptableFeature(newFeature, editLayer);
        CreateFeatureCommand.runFeatureCreationInterceptors((Feature)feature);
        this.map.getEditManagerInternal().addFeature(newFeature, (Layer)editLayer);
    }

    private Object toDefaultValue(AttributeDescriptor type) {
        if (type.getDefaultValue() != null) {
            return type.getDefaultValue();
        }
        if (Boolean.class.isAssignableFrom(type.getType().getBinding()) || Boolean.TYPE.isAssignableFrom(type.getType().getBinding())) {
            return Boolean.FALSE;
        }
        if (String.class.isAssignableFrom(type.getType().getBinding())) {
            return "";
        }
        if (Integer.class.isAssignableFrom(type.getType().getBinding())) {
            return 0;
        }
        if (Double.class.isAssignableFrom(type.getType().getBinding())) {
            return 0.0;
        }
        if (Float.class.isAssignableFrom(type.getType().getBinding())) {
            return Float.valueOf(0.0f);
        }
        if (CodeList.class.isAssignableFrom(type.getType().getBinding())) {
            return type.getDefaultValue();
        }
        return null;
    }

    private Layer findEditLayer() {
        Layer layer2 = null;
        if (this.map.getEditManagerInternal().getEditLayerInternal() != null) {
            return this.map.getEditManagerInternal().getEditLayerInternal();
        }
        for (Layer layer2 : this.map.getLayersInternal()) {
            if (layer2.hasResource(FeatureStore.class) && layer2.isSelectable() && layer2.isVisible()) break;
        }
        return layer2;
    }

    private void transform() throws Exception {
        ILayer editLayer = this.getMap().getEditManager().getEditLayer();
        if (this.map.getViewportModel().getCRS().equals(editLayer.getCRS(null))) {
            return;
        }
        MathTransform mt = CRS.findMathTransform((CoordinateReferenceSystem)this.map.getViewportModel().getCRS(), (CoordinateReferenceSystem)editLayer.getCRS(), (boolean)true);
        if (mt == null || mt.isIdentity()) {
            return;
        }
        double[] coords = new double[this.coordinates.length * 2];
        int i = 0;
        while (i < this.coordinates.length) {
            coords[i * 2] = this.coordinates[i].x;
            coords[i * 2 + 1] = this.coordinates[i].y;
            ++i;
        }
        mt.transform(coords, 0, coords, 0, this.coordinates.length);
        i = 0;
        while (i < this.coordinates.length) {
            this.coordinates[i].x = coords[i * 2];
            this.coordinates[i].y = coords[i * 2 + 1];
            ++i;
        }
    }

    @Override
    public MapCommand copy() {
        return new CreateFeatureCommand(this.coordinates);
    }

    @Override
    public String getName() {
        return Messages.CreateFeatureCommand_createFeature;
    }

    @Override
    public void rollback(IProgressMonitor monitor) throws Exception {
        ILayer editLayer = this.getMap().getEditManager().getEditLayer();
        FilterFactory filterFactory = CommonFactoryFinder.getFilterFactory((Hints)GeoTools.getDefaultHints());
        editLayer.getResource(FeatureStore.class, null).removeFeatures((Filter)filterFactory.id(FeatureUtils.stringToId((FilterFactory)filterFactory, (String)this.fid)));
    }

    public static void runFeatureCreationInterceptors(Feature feature) {
        List interceptors = ExtensionPointList.getExtensionPointList((String)"net.refractions.udig.project.featureInterceptor");
        for (IConfigurationElement element : interceptors) {
            String id = element.getAttribute("id");
            if (!"featureCreated".equals(element.getName())) continue;
            try {
                FeatureInterceptor interceptor = (FeatureInterceptor)element.createExecutableExtension("class");
                interceptor.run(feature);
            }
            catch (Exception e) {
                ProjectPlugin.log("FeatureInterceptor " + id + ":" + e, e);
            }
        }
    }
}

