/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.internal.commands.edit;

import com.vividsolutions.jts.geom.Envelope;
import java.awt.Rectangle;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.refractions.udig.core.internal.FeatureUtils;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.command.AbstractCommand;
import net.refractions.udig.project.command.UndoableMapCommand;
import net.refractions.udig.project.internal.Layer;
import net.refractions.udig.project.internal.Messages;
import net.refractions.udig.project.internal.ProjectPlugin;
import net.refractions.udig.project.internal.render.ViewportModel;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.swt.widgets.Display;
import org.geotools.data.DefaultQuery;
import org.geotools.data.FeatureEvent;
import org.geotools.data.FeatureListener;
import org.geotools.data.FeatureSource;
import org.geotools.data.FeatureStore;
import org.geotools.data.Query;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.collection.AdaptorFeatureCollection;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.Id;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public class CopyFeaturesCommand
extends AbstractCommand
implements UndoableMapCommand {
    private Layer destinationLayer;
    private Filter filter;
    private ILayer sourceLayer;
    private Id addedFeaturesFilter;
    private Filter previousDesinationLayerFilter;
    private ReferencedEnvelope previousEnvelope;

    public CopyFeaturesCommand(ILayer sourceLayer, Filter filter, ILayer destinationLayer) {
        this.sourceLayer = sourceLayer;
        this.filter = filter;
        this.destinationLayer = (Layer)destinationLayer;
    }

    @Override
    public void run(IProgressMonitor monitor) throws Exception {
        if (this.sourceLayer == null || this.destinationLayer == null) {
            return;
        }
        this.previousEnvelope = this.getMap().getViewportModel().getBounds();
        this.previousDesinationLayerFilter = this.destinationLayer.getFilter();
        this.copyFeatures(this.sourceLayer, this.filter, this.destinationLayer, monitor);
    }

    private void copyFeatures(ILayer sourceLayer, Filter filter, Layer targetLayer, final IProgressMonitor monitor) {
        final String copyFeaturesCommand_name = Messages.CopyFeaturesCommand_name;
        String name = MessageFormat.format(copyFeaturesCommand_name, 0);
        monitor.setTaskName(name);
        monitor.beginTask(name, 104);
        int[] worked = new int[]{-3};
        monitor.worked(1);
        try {
            SubProgressMonitor subProgressMonitor = new SubProgressMonitor(monitor, 2);
            FeatureStore destination = (FeatureStore)targetLayer.getResource(FeatureStore.class, (IProgressMonitor)subProgressMonitor);
            subProgressMonitor.done();
            worked[0] = worked[0] + 2;
            subProgressMonitor = new SubProgressMonitor(monitor, 2);
            FeatureSource source = sourceLayer.getResource(FeatureSource.class, (IProgressMonitor)subProgressMonitor);
            subProgressMonitor.done();
            worked[0] = worked[0] + 2;
            if (destination == null || source == null) {
                targetLayer.setFilter(filter);
                return;
            }
            HashMap<String, String> attributeMap = new HashMap<String, String>();
            Query query = this.createQuery(sourceLayer, filter, targetLayer, attributeMap);
            if (attributeMap.isEmpty()) {
                targetLayer.setFilter(filter);
                return;
            }
            try {
                MathTransform mt = this.createMathTransform(sourceLayer, targetLayer);
                FeatureCollection features = source.getFeatures(query);
                SimpleFeatureType schema = targetLayer.getSchema();
                CopyFeatureCollection c = new CopyFeatureCollection(schema, (FeatureCollection<SimpleFeatureType, SimpleFeature>)features, monitor, worked, mt, attributeMap, targetLayer.layerToMapTransform());
                ReferencedEnvelope env = c.env;
                targetLayer.eSetDeliver(false);
                FeatureListener listener = new FeatureListener(){
                    long lastUpdate = System.currentTimeMillis();
                    long count = 0L;

                    public void changed(FeatureEvent event) {
                        if (event.getType() == FeatureEvent.Type.ADDED) {
                            ++this.count;
                            if (System.currentTimeMillis() - this.lastUpdate > 1000L) {
                                Display.getDefault().asyncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        String name2 = MessageFormat.format(copyFeaturesCommand_name, 0);
                                        monitor.setTaskName(name2);
                                    }
                                });
                                this.lastUpdate = System.currentTimeMillis();
                            }
                        }
                    }
                };
                boolean performedZoom = false;
                try {
                    destination.addFeatureListener(listener);
                    List fids = destination.addFeatures((FeatureCollection)c);
                    performedZoom = this.displayCopiedFeatures((Envelope)env);
                    FilterFactory filterFactory = CommonFactoryFinder.getFilterFactory((Hints)GeoTools.getDefaultHints());
                    this.addedFeaturesFilter = filterFactory.id(new HashSet(fids));
                }
                finally {
                    targetLayer.eSetDeliver(true);
                    destination.removeFeatureListener(listener);
                }
                if (performedZoom) {
                    this.getMap().getRenderManager().refresh(null);
                } else {
                    targetLayer.refresh((Envelope)env);
                }
                this.getMap().getRenderManager().refresh(targetLayer, (Envelope)env);
            }
            catch (IOException e) {
                throw (RuntimeException)new RuntimeException().initCause(e);
            }
        }
        finally {
            monitor.done();
        }
    }

    private boolean displayCopiedFeatures(Envelope env) {
        if (!this.getMap().getViewportModel().getBounds().intersects(env) && !env.isNull() || this.tooSmallOnScreen(env)) {
            double d = env.getHeight() / 2.0;
            double e = env.getWidth() / 2.0;
            ViewportModel viewportModel = this.getMap().getViewportModelInternal();
            viewportModel.eSetDeliver(false);
            try {
                viewportModel.setBounds(env.getMinX() - e, env.getMaxX() + e, env.getMinY() - d, env.getMaxY() + d);
                return true;
            }
            finally {
                viewportModel.eSetDeliver(true);
            }
        }
        return false;
    }

    private MathTransform createMathTransform(ILayer sourceLayer, ILayer targetLayer) {
        MathTransform temp;
        try {
            CoordinateReferenceSystem targetCRS = targetLayer.getCRS();
            CoordinateReferenceSystem sourceCRS = sourceLayer.getCRS();
            temp = targetCRS.equals(sourceCRS) ? null : CRS.findMathTransform((CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)targetCRS, (boolean)true);
            if (temp == null || temp.isIdentity()) {
                temp = null;
            }
        }
        catch (FactoryException e1) {
            ProjectPlugin.log("", e1);
            temp = null;
        }
        if (temp == null) {
            try {
                return CRS.findMathTransform((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
            }
            catch (Exception e) {
                ProjectPlugin.log("", e);
                return null;
            }
        }
        return temp;
    }

    boolean tooSmallOnScreen(Envelope env) {
        double[] d = new double[]{env.getMinX(), env.getMinY(), env.getMaxX(), env.getMaxY()};
        this.getMap().getViewportModel().worldToScreenTransform().transform(d, 0, d, 0, 2);
        Rectangle r = new Rectangle((int)d[0], (int)d[1], (int)Math.abs(d[2] - d[0]), (int)Math.abs(d[3] - d[1]));
        return r.getWidth() < (double)this.getMap().getRenderManager().getMapDisplay().getWidth() / 16.0 && r.getHeight() < (double)this.getMap().getRenderManager().getMapDisplay().getHeight() / 16.0;
    }

    public static int updateProgress(IProgressMonitor monitor, int numberToCopyForIncrement, int[] worked) {
        int result = 0;
        if (numberToCopyForIncrement < 1) {
            monitor.worked(1);
            worked[0] = worked[0] + 1;
            int i = 100 / (100 - worked[0]);
            result = 1000 * i;
        } else {
            result = numberToCopyForIncrement - 1;
        }
        return result;
    }

    private Query createQuery(ILayer sourceLayer, Filter filter, Layer targetLayer, Map<String, String> queryAttributes) {
        SimpleFeatureType sourceSchema = sourceLayer.getSchema();
        SimpleFeatureType targetSchema = targetLayer.getSchema();
        queryAttributes.putAll(FeatureUtils.createAttributeMapping((SimpleFeatureType)sourceSchema, (SimpleFeatureType)targetSchema));
        HashSet<String> properties = new HashSet<String>(queryAttributes.values());
        return new DefaultQuery(sourceSchema.getName().getLocalPart(), filter, properties.toArray(new String[properties.size()]));
    }

    @Override
    public String getName() {
        return Messages.CopyFeaturesCommand_name;
    }

    @Override
    public void rollback(IProgressMonitor monitor) throws Exception {
        if (this.sourceLayer == null || this.destinationLayer == null) {
            return;
        }
        monitor.beginTask(String.valueOf(Messages.CopyFeaturesCommand_undo) + this.getName(), 4);
        monitor.worked(1);
        this.destinationLayer.eSetDeliver(false);
        try {
            FeatureStore store = (FeatureStore)this.destinationLayer.getResource(FeatureStore.class, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            store.removeFeatures((Filter)this.addedFeaturesFilter);
            this.destinationLayer.setFilter(this.previousDesinationLayerFilter);
        }
        finally {
            this.destinationLayer.eSetDeliver(true);
        }
        this.getMap().getViewportModelInternal().setBounds(this.previousEnvelope);
    }

    private static class CopyFeatureCollection
    extends AdaptorFeatureCollection {
        final SimpleFeatureType schema;
        final FeatureCollection<SimpleFeatureType, SimpleFeature> features;
        final IProgressMonitor monitor;
        final int[] worked;
        final MathTransform mt;
        final MathTransform toWorld;
        final Map<String, String> attributeMap;
        final ReferencedEnvelope env;
        Map<Iterator, FeatureIterator<SimpleFeature>> iterators = new HashMap<Iterator, FeatureIterator<SimpleFeature>>();

        CopyFeatureCollection(SimpleFeatureType schema, FeatureCollection<SimpleFeatureType, SimpleFeature> features, IProgressMonitor monitor, int[] worked, MathTransform mt, HashMap<String, String> attributeMap, MathTransform toWorld) {
            super("copyCollection", schema);
            this.schema = schema;
            this.features = features;
            this.monitor = monitor;
            this.worked = worked;
            this.mt = mt;
            this.attributeMap = attributeMap;
            this.env = new ReferencedEnvelope(schema.getCoordinateReferenceSystem());
            this.toWorld = toWorld;
        }

        public int size() {
            return this.features.size();
        }

        public ReferencedEnvelope getBounds() {
            return this.features.getBounds();
        }

        protected Iterator openIterator() {
            final FeatureIterator iter = this.features.features();
            Iterator i = new Iterator(){
                int numberToCopyForIncrement = 1000;
                private SimpleFeature next;
                Iterator<SimpleFeature> copiedFeatures;

                public SimpleFeature next() {
                    SimpleFeature result = this.next;
                    this.next = null;
                    return result;
                }

                @Override
                public boolean hasNext() {
                    while (this.next == null) {
                        if (this.copiedFeatures != null && this.copiedFeatures.hasNext()) {
                            this.next = this.copiedFeatures.next();
                            continue;
                        }
                        if (!iter.hasNext()) {
                            return false;
                        }
                        SimpleFeature source = (SimpleFeature)iter.next();
                        this.numberToCopyForIncrement = CopyFeaturesCommand.updateProgress(CopyFeatureCollection.this.monitor, this.numberToCopyForIncrement, CopyFeatureCollection.this.worked);
                        this.copiedFeatures = FeatureUtils.copyFeature((SimpleFeature)source, (SimpleFeatureType)CopyFeatureCollection.this.schema, CopyFeatureCollection.this.attributeMap, (MathTransform)CopyFeatureCollection.this.mt).iterator();
                        if (!this.copiedFeatures.hasNext()) {
                            return false;
                        }
                        this.next = this.copiedFeatures.next();
                        ReferencedEnvelope newbounds = new ReferencedEnvelope(this.next.getBounds());
                        try {
                            newbounds = newbounds.transform(CopyFeatureCollection.this.env.crs(), true);
                            CopyFeatureCollection.this.env.expandToInclude((Envelope)newbounds);
                        }
                        catch (TransformException e) {
                            ProjectPlugin.log("", e);
                        }
                        catch (FactoryException e) {
                            ProjectPlugin.log("", e);
                        }
                    }
                    return this.next != null;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
            this.iterators.put(i, (FeatureIterator<SimpleFeature>)iter);
            return i;
        }

        protected void closeIterator(Iterator close) {
            this.iterators.get(close).close();
        }
    }
}

