/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.internal.commands.edit;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import net.refractions.udig.core.internal.FeatureUtils;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.command.AbstractCommand;
import net.refractions.udig.project.command.UndoableMapCommand;
import net.refractions.udig.project.internal.Messages;
import org.eclipse.core.runtime.IProgressMonitor;
import org.geotools.data.FeatureStore;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.collection.AdaptorFeatureCollection;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.identity.FeatureId;
import org.opengis.geometry.BoundingBox;

public class AddFeatureCommand
extends AbstractCommand
implements UndoableMapCommand {
    private SimpleFeature feature;
    private ILayer layer;
    private FeatureStore<SimpleFeatureType, SimpleFeature> resource;
    private String fid;

    public AddFeatureCommand(SimpleFeature feature, ILayer layer) {
        this.feature = feature;
        this.layer = layer;
    }

    @Override
    public void run(IProgressMonitor monitor) throws Exception {
        this.resource = this.layer.getResource(FeatureStore.class, monitor);
        if (this.resource == null) {
            return;
        }
        AdaptorFeatureCollection c = new AdaptorFeatureCollection("addFeatureCollection", (SimpleFeatureType)this.resource.getSchema()){

            public int size() {
                return 1;
            }

            public ReferencedEnvelope getBounds() {
                return ReferencedEnvelope.reference((BoundingBox)AddFeatureCommand.this.feature.getBounds());
            }

            protected Iterator openIterator() {
                return new Iterator(){
                    SimpleFeature next;
                    {
                        this.next = AddFeatureCommand.this.feature;
                    }

                    public Object next() {
                        SimpleFeature tmp = this.next;
                        this.next = null;
                        return tmp;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.next != null;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            protected void closeIterator(Iterator close) {
            }
        };
        List added = this.resource.addFeatures((FeatureCollection)c);
        Iterator iterator = added.iterator();
        if (iterator.hasNext()) {
            FeatureId featureId = (FeatureId)iterator.next();
            this.fid = featureId.getID();
        }
    }

    public SimpleFeature getNewFeature() throws IOException {
        if (this.resource != null) {
            FilterFactory filterFactory = CommonFactoryFinder.getFilterFactory((Hints)GeoTools.getDefaultHints());
            FeatureCollection features = this.resource.getFeatures((Filter)filterFactory.id(FeatureUtils.stringToId((FilterFactory)filterFactory, (String)this.fid)));
            FeatureIterator iter = features.features();
            try {
                SimpleFeature simpleFeature = (SimpleFeature)iter.next();
                return simpleFeature;
            }
            finally {
                features.close(iter);
            }
        }
        return null;
    }

    @Override
    public String getName() {
        return Messages.AddFeatureCommand_name;
    }

    @Override
    public void rollback(IProgressMonitor monitor) throws Exception {
        FilterFactory filterFactory = CommonFactoryFinder.getFilterFactory((Hints)GeoTools.getDefaultHints());
        this.resource.removeFeatures((Filter)filterFactory.id(FeatureUtils.stringToId((FilterFactory)filterFactory, (String)this.fid)));
    }

    public String getFid() {
        return this.fid;
    }
}

