/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.internal.commands;

import java.util.ArrayList;
import java.util.List;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.command.AbstractCommand;
import net.refractions.udig.project.command.UndoableMapCommand;
import net.refractions.udig.project.internal.Layer;
import net.refractions.udig.project.internal.Map;
import net.refractions.udig.project.internal.Messages;
import net.refractions.udig.project.internal.commands.DeleteLayerCommand;
import org.eclipse.core.runtime.IProgressMonitor;

public class DeleteLayersCommand
extends AbstractCommand
implements UndoableMapCommand {
    private List<ILayer> removedLayers = new ArrayList<ILayer>();
    private int index;
    private Map map = null;
    private ILayer selectedLayer;

    public DeleteLayersCommand(ILayer[] layers) {
        int i = 0;
        while (i < layers.length) {
            this.removedLayers.add(layers[i]);
            if (this.map == null) {
                this.map = ((Layer)layers[i]).getMapInternal();
            }
            ++i;
        }
    }

    @Override
    public void rollback(IProgressMonitor monitor) throws Exception {
        this.map.getMapLayers().addAll(this.index, this.removedLayers);
        if (this.selectedLayer != null) {
            this.map.getEditManagerInternal().setSelectedLayer((Layer)this.selectedLayer);
        }
    }

    @Override
    public void run(IProgressMonitor monitor) throws Exception {
        this.selectedLayer = this.map.getEditManager().getSelectedLayer();
        if (!DeleteLayerCommand.selectNewLayer(this.map, this.removedLayers)) {
            this.selectedLayer = null;
        }
        List<Layer> layers = this.map.getLayersInternal();
        layers.removeAll(this.removedLayers);
        for (ILayer layer : this.removedLayers) {
            this.map.getColourScheme().removeItem(layer.getID().toString(), ((Layer)layer).getDefaultColor());
        }
    }

    @Override
    public String getName() {
        return Messages.DeleteLayersCommand_name;
    }
}

