/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.internal.commands;

import java.util.List;
import net.refractions.udig.project.ILegendItem;
import net.refractions.udig.project.command.AbstractCommand;
import net.refractions.udig.project.command.UndoableMapCommand;
import net.refractions.udig.project.internal.Folder;
import net.refractions.udig.project.internal.Layer;
import net.refractions.udig.project.internal.Map;
import net.refractions.udig.project.internal.Messages;
import org.eclipse.core.runtime.IProgressMonitor;

public class DeleteLayerItemCommand
extends AbstractCommand
implements UndoableMapCommand {
    private Layer layer;
    private int index;
    private Folder folder;
    private boolean isInMap = false;

    public DeleteLayerItemCommand(Layer layer) {
        this.layer = layer;
    }

    @Override
    public String getName() {
        return Messages.DeleteLayerItemCommand_Name;
    }

    @Override
    public void run(IProgressMonitor monitor) throws Exception {
        this.initRunConditions(this.layer);
        if (this.layer != null && this.isInMap) {
            if (this.folder == null) {
                this.getMap().getLegend().remove(this.layer);
            } else {
                this.folder.getItems().remove(this.layer);
            }
        }
    }

    @Override
    public void rollback(IProgressMonitor monitor) throws Exception {
        if (this.layer != null && this.isInMap) {
            if (this.folder == null) {
                this.getMap().getLegend().add(this.index, this.layer);
            } else {
                this.folder.getItems().add(this.index, this.layer);
            }
        }
    }

    private void initRunConditions(Layer layer) {
        if (layer != null) {
            Object parent = this.getParent(this.getMap(), layer);
            if (parent == null) {
                this.isInMap = false;
            } else {
                this.isInMap = true;
                if (parent instanceof Folder) {
                    this.folder = (Folder)parent;
                }
            }
            this.index = this.folder == null ? this.getMap().getLegend().indexOf(layer) : this.folder.getItems().indexOf(layer);
        }
    }

    private Object getParent(Map map, Layer layer) {
        List<ILegendItem> legendItems = map.getLegend();
        for (ILegendItem legendItem : legendItems) {
            if (legendItem instanceof Folder) {
                List<ILegendItem> folderItems = ((Folder)legendItem).getItems();
                for (ILegendItem folderItem : folderItems) {
                    if (folderItem != layer) continue;
                    return legendItem;
                }
                continue;
            }
            if (legendItem != layer) continue;
            return map;
        }
        return null;
    }
}

