/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.internal.commands;

import java.util.List;
import net.refractions.udig.project.ILegendItem;
import net.refractions.udig.project.command.AbstractCommand;
import net.refractions.udig.project.command.UndoableMapCommand;
import net.refractions.udig.project.internal.Folder;
import net.refractions.udig.project.internal.Map;
import net.refractions.udig.project.internal.Messages;
import org.eclipse.core.runtime.IProgressMonitor;

public class DeleteFolderItemCommand
extends AbstractCommand
implements UndoableMapCommand {
    private Folder folder;
    private Object parent;
    private int index;

    public DeleteFolderItemCommand(Folder folder) {
        this.folder = folder;
    }

    @Override
    public String getName() {
        return Messages.DeleteFolderItemCommand_Name;
    }

    @Override
    public void run(IProgressMonitor monitor) throws Exception {
        this.initializeDelete();
        if (this.parent != null) {
            if (this.parent instanceof Map) {
                this.getMap().getLegend().remove(this.folder);
            } else if (this.parent instanceof Folder) {
                Folder parentFolder = (Folder)this.parent;
                parentFolder.getItems().remove(this.folder);
            }
        }
    }

    @Override
    public void rollback(IProgressMonitor monitor) throws Exception {
        this.getMap().getLegend().add(this.index, this.folder);
    }

    private void initializeDelete() {
        Map map = this.getMap();
        List<ILegendItem> items = map.getLegend();
        if (items.contains(this.folder)) {
            this.parent = this.getMap();
            this.index = items.indexOf(this.folder);
        } else {
            for (ILegendItem item : items) {
                boolean isSet;
                if (item instanceof Folder && (isSet = this.setParent((Folder)item))) break;
            }
        }
    }

    private boolean setParent(Folder parentFolder) {
        List<ILegendItem> items = parentFolder.getItems();
        if (items.contains(this.folder)) {
            this.parent = parentFolder;
            this.index = items.indexOf(this.folder);
            return true;
        }
        for (ILegendItem item : items) {
            boolean isSet;
            if (!(item instanceof Folder) || !(isSet = this.setParent((Folder)item))) continue;
            return true;
        }
        return false;
    }
}

