/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.internal.commands;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.catalog.IGeoResourceInfo;
import net.refractions.udig.project.IMap;
import net.refractions.udig.project.IProject;
import net.refractions.udig.project.IProjectElement;
import net.refractions.udig.project.command.AbstractCommand;
import net.refractions.udig.project.command.UndoableMapCommand;
import net.refractions.udig.project.internal.Layer;
import net.refractions.udig.project.internal.LayerFactory;
import net.refractions.udig.project.internal.Map;
import net.refractions.udig.project.internal.Messages;
import net.refractions.udig.project.internal.Project;
import net.refractions.udig.project.internal.ProjectFactory;
import net.refractions.udig.project.internal.ProjectPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class CreateMapCommand
extends AbstractCommand
implements UndoableMapCommand {
    String name;
    List<IGeoResource> resources;
    Project owner;
    Map map;

    public CreateMapCommand(String name, List<IGeoResource> resources, IProject owner) {
        this.name = name;
        this.resources = resources;
        this.owner = (Project)owner;
    }

    @Override
    public void run(IProgressMonitor monitor) throws Exception {
        if (this.owner == null) {
            this.owner = ProjectPlugin.getPlugin().getProjectRegistry().getCurrentProject();
        }
        if (this.name == null) {
            if (this.resources.size() > 0) {
                IGeoResourceInfo info;
                IGeoResource resource = this.resources.get(0);
                String title = resource.getTitle();
                if ((title == null || title.trim().length() == 0) && (info = resource.getInfo(monitor)) != null) {
                    title = info.getTitle();
                }
                if (title != null && !title.contains("(")) {
                    this.name = title;
                }
                if (this.name == null) {
                    this.name = resource.getID().toBaseFile();
                }
            }
            if (this.name == null) {
                this.name = Messages.CreateMapCommand_defaultname;
            }
            int i = 1;
            String newName = this.name;
            while (this.nameTaken(newName)) {
                newName = String.valueOf(this.name) + " " + ++i;
            }
            this.name = newName;
        }
        this.map = ProjectFactory.eINSTANCE.createMap(this.owner, this.name, new ArrayList());
        ScopedPreferenceStore store = ProjectPlugin.getPlugin().getPreferenceStore();
        RGB background = PreferenceConverter.getColor((IPreferenceStore)store, (String)"backgroundColor");
        this.map.getBlackboard().put("mapBackgroundColor", new Color(background.red, background.green, background.blue));
        LayerFactory layerFactory = this.map.getLayerFactory();
        ArrayList<Layer> toAdd = new ArrayList<Layer>(this.resources.size());
        for (IGeoResource resource : this.resources) {
            Layer layer = layerFactory.createLayer(resource);
            toAdd.add(layer);
        }
        this.map.getLayersInternal().addAll(toAdd);
        this.trace(toAdd);
    }

    private void trace(List<Layer> toAdd) {
        if (ProjectPlugin.isDebugging("net.refractions.udig.project/debug/commands/trace")) {
            ArrayList<String> ids = new ArrayList<String>();
            for (Layer layer : toAdd) {
                ids.add(layer.getID().toString());
            }
            ProjectPlugin.trace(this.getClass(), "Created Map: " + this.map.getName() + " and added Layers: " + ids, null);
        }
    }

    private boolean nameTaken(String newName) {
        for (IProjectElement element : this.owner.getElements()) {
            if (!newName.equals(element.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getName() {
        return Messages.CreateMapCommand_commandname;
    }

    public IMap getCreatedMap() {
        return this.map;
    }

    @Override
    public void rollback(IProgressMonitor monitor) throws Exception {
        this.owner.getElementsInternal().remove(this.map);
        this.map.eResource().unload();
    }
}

