/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.internal.command.navigation;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import net.refractions.udig.project.command.MapCommand;
import net.refractions.udig.project.internal.Messages;
import net.refractions.udig.project.internal.command.navigation.AbstractNavCommand;
import org.eclipse.core.runtime.IProgressMonitor;

public class ZoomCommand
extends AbstractNavCommand {
    private double zoomfactor = 1.0;
    private Coordinate fixedPoint;
    private Envelope envelope;

    public ZoomCommand(double zoomfactor) {
        this.zoomfactor = zoomfactor;
    }

    public ZoomCommand(Envelope envelope) {
        this.envelope = envelope;
    }

    public void setFixedPoint(Coordinate fixedPoint) {
        this.fixedPoint = fixedPoint;
    }

    @Override
    public MapCommand copy() {
        return new ZoomCommand(this.zoomfactor);
    }

    @Override
    protected void runImpl(IProgressMonitor monitor) {
        if (this.envelope != null) {
            this.model.zoomToBox(this.envelope);
        } else {
            this.model.zoom(this.zoomfactor, this.fixedPoint);
        }
    }

    @Override
    public String getName() {
        return Messages.ZoomCommand_zoom;
    }
}

