/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.internal.command.navigation;

import com.vividsolutions.jts.geom.Envelope;
import java.text.MessageFormat;
import net.refractions.udig.project.command.MapCommand;
import net.refractions.udig.project.internal.Messages;
import net.refractions.udig.project.internal.ProjectPlugin;
import net.refractions.udig.project.internal.command.navigation.AbstractNavCommand;
import org.eclipse.core.runtime.IProgressMonitor;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;

public class SetViewportBBoxCommand
extends AbstractNavCommand {
    private Envelope newbbox = null;
    private CoordinateReferenceSystem crs;
    private boolean forceContainBBoxZoom;

    public SetViewportBBoxCommand(Envelope bbox) {
        this.newbbox = bbox;
        if (bbox instanceof ReferencedEnvelope) {
            this.crs = ((ReferencedEnvelope)bbox).getCoordinateReferenceSystem();
        }
    }

    public SetViewportBBoxCommand(ReferencedEnvelope bbox) {
        this(bbox, false);
    }

    public SetViewportBBoxCommand(Envelope bounds, CoordinateReferenceSystem crs) {
        this(new ReferencedEnvelope(bounds, crs));
    }

    public SetViewportBBoxCommand(ReferencedEnvelope bbox, boolean forceContainBBoxZoom) {
        this.newbbox = bbox;
        this.crs = bbox.getCoordinateReferenceSystem();
        this.forceContainBBoxZoom = forceContainBBoxZoom;
    }

    @Override
    public MapCommand copy() {
        return new SetViewportBBoxCommand(this.newbbox, this.crs);
    }

    @Override
    protected void runImpl(IProgressMonitor monitor) {
        if (this.crs != null) {
            try {
                MathTransform mt = CRS.findMathTransform((CoordinateReferenceSystem)this.crs, (CoordinateReferenceSystem)this.model.getCRS(), (boolean)true);
                if (!mt.isIdentity()) {
                    Envelope transformedBounds = JTS.transform((Envelope)this.newbbox, null, (MathTransform)mt, (int)5);
                    this.crs = this.model.getCRS();
                    this.newbbox = transformedBounds;
                }
            }
            catch (Exception e) {
                ProjectPlugin.log("Error transforming from " + this.crs.getName() + " to " + this.model.getCRS().getName(), e);
            }
        } else {
            this.crs = this.model.getCRS();
        }
        this.model.setBounds(new ReferencedEnvelope(this.newbbox, this.crs), this.forceContainBBoxZoom);
    }

    @Override
    public String getName() {
        return MessageFormat.format(Messages.SetViewportBBoxCommand_setViewArea, this.newbbox);
    }
}

